/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResultWithImage;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Color;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastSwatch;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextContrastCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_TEXTVIEW_EMPTY = 3;
    public static final int RESULT_ID_COULD_NOT_GET_TEXT_COLOR = 4;
    public static final int RESULT_ID_COULD_NOT_GET_BACKGROUND_COLOR = 5;
    public static final int RESULT_ID_TEXT_MUST_BE_OPAQUE = 6;
    public static final int RESULT_ID_BACKGROUND_MUST_BE_OPAQUE = 7;
    public static final int RESULT_ID_TEXTVIEW_CONTRAST_NOT_SUFFICIENT = 8;
    public static final int RESULT_ID_HEURISTIC_COULD_NOT_GET_SCREENCAPTURE = 9;
    public static final int RESULT_ID_VIEW_NOT_WITHIN_SCREENCAPTURE = 10;
    public static final int RESULT_ID_TEXTVIEW_HEURISTIC_CONTRAST_NOT_SUFFICIENT = 11;
    public static final int RESULT_ID_TEXTVIEW_HEURISTIC_CONTRAST_BORDERLINE = 12;
    public static final int RESULT_ID_NOT_ENABLED = 13;
    public static final int RESULT_ID_SCREENCAPTURE_DATA_HIDDEN = 14;
    public static final int RESULT_ID_CUSTOMIZED_TEXTVIEW_HEURISTIC_CONTRAST_NOT_SUFFICIENT = 15;
    public static final int RESULT_ID_SCREENCAPTURE_UNIFORM_COLOR = 16;
    public static final String KEY_BACKGROUND_COLOR = "KEY_BACKGROUND_COLOR";
    public static final String KEY_BACKGROUND_OPACITY = "KEY_BACKGROUND_OPACITY";
    public static final String KEY_CONTRAST_RATIO = "KEY_CONTRAST_RATIO";
    public static final String KEY_FOREGROUND_COLOR = "KEY_FOREGROUND_COLOR";
    public static final String KEY_REQUIRED_CONTRAST_RATIO = "KEY_REQUIRED_CONTRAST_RATIO";
    public static final String KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO = "KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO";
    public static final String KEY_SCREENSHOT_BOUNDS_STRING = "KEY_SCREENSHOT_BOUNDS_STRING";
    public static final String KEY_TEXT_COLOR = "KEY_TEXT_COLOR";
    public static final String KEY_TEXT_OPACITY = "KEY_TEXT_OPACITY";
    public static final String KEY_TOLERANT_CONTRAST_RATIO = "KEY_TOLERANT_CONTRAST_RATIO";
    public static final String KEY_VIEW_BOUNDS_STRING = "KEY_VIEW_BOUNDS_STRING";
    public static final String KEY_IS_AGAINST_SCROLLABLE_EDGE = "KEY_IS_AGAINST_SCROLLABLE_EDGE";
    public static final String KEY_ADDITIONAL_FOREGROUND_COLORS = "KEY_ADDITIONAL_FOREGROUND_COLORS";
    public static final String KEY_ADDITIONAL_CONTRAST_RATIOS = "KEY_ADDITIONAL_CONTRAST_RATIOS";
    public static final String KEY_IS_POTENTIALLY_OBSCURED = "KEY_IS_POTENTIALLY_OBSCURED";
    public static final double CONTRAST_TOLERANCE = 0.01;
    private static final Class<? extends AccessibilityHierarchyCheck> CHECK_CLASS = TextContrastCheck.class;
    private static final int TYPEFACE_NORMAL = 0;
    private static final int TYPEFACE_BOLD = 1;

    @Override
    protected String getHelpTopic() {
        return "7158390";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.LOW_CONTRAST;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = TextContrastCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            AccessibilityHierarchyCheckResult heavyweightResult;
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView") || viewHierarchyElement.checkInstanceOf("android.widget.Switch")) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (TextUtils.isEmpty(viewHierarchyElement.getText())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            if (!viewHierarchyElement.isEnabled()) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 13, null));
                continue;
            }
            AccessibilityHierarchyCheckResult lightweightResult = this.attemptLightweightEval(viewHierarchyElement);
            if (lightweightResult == null) continue;
            results.add(lightweightResult);
            if (lightweightResult.getType() != AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN || (heavyweightResult = this.attemptHeavyweightEval(viewHierarchyElement, parameters)) == null) continue;
            results.add(heavyweightResult);
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 6: {
                StringBuilder builder = new StringBuilder().append(StringManager.getString(locale, "result_message_text_must_be_opaque")).append(" ").append(String.format(locale, StringManager.getString(locale, "result_message_addendum_opacity_description"), Float.valueOf(metadata.getFloat(KEY_TEXT_OPACITY))));
                return builder.toString();
            }
            case 7: {
                StringBuilder builder = new StringBuilder().append(StringManager.getString(locale, "result_message_background_must_be_opaque")).append(" ").append(String.format(locale, StringManager.getString(locale, "result_message_addendum_opacity_description"), Float.valueOf(metadata.getFloat(KEY_BACKGROUND_OPACITY))));
                return builder.toString();
            }
            case 8: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), metadata.getInt(KEY_TEXT_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF, metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 10: {
                return String.format(locale, StringManager.getString(locale, "result_message_view_not_within_screencapture"), metadata.getString(KEY_VIEW_BOUNDS_STRING), metadata.getString(KEY_SCREENSHOT_BOUNDS_STRING));
            }
            case 11: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), metadata.getInt(KEY_FOREGROUND_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF, 4.5, metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 12: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), metadata.getInt(KEY_FOREGROUND_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF, metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO), metadata.getDouble(KEY_TOLERANT_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 15: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_customized_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), metadata.getInt(KEY_FOREGROUND_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF, metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 6: {
                return StringManager.getString(locale, "result_message_text_must_be_opaque");
            }
            case 7: {
                return StringManager.getString(locale, "result_message_background_must_be_opaque");
            }
            case 10: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: {
                return StringManager.getString(locale, "result_message_brief_text_contrast_not_sufficient");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata = result.getMetadata();
        switch (result.getResultId()) {
            case 8: 
            case 11: 
            case 12: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_REQUIRED_CONTRAST_RATIO, 0.0) - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
            case 15: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, 0.0) - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
        }
        return null;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_text_contrast");
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
            case 13: {
                return StringManager.getString(locale, "result_message_not_enabled");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_textview_empty");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_could_not_get_text_color");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_could_not_get_background_color");
            }
            case 9: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 14: {
                return StringManager.getString(locale, "result_message_screencapture_data_hidden");
            }
            case 16: {
                return StringManager.getString(locale, "result_message_screencapture_uniform_color");
            }
        }
        return null;
    }

    private @Nullable AccessibilityHierarchyCheckResult attemptLightweightEval(ViewHierarchyElement view) {
        double requiredContrast;
        Integer textColor = view.getTextColor();
        Integer backgroundDrawableColor = view.getBackgroundDrawableColor();
        if (textColor == null) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 4, null);
        }
        if (backgroundDrawableColor == null) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 5, null);
        }
        int textAlpha = Color.alpha(textColor);
        if (textAlpha < 255) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putFloat(KEY_TEXT_OPACITY, (float)textAlpha / 255.0f * 100.0f);
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 6, resultMetadata);
        }
        int backgroundAlpha = Color.alpha(backgroundDrawableColor);
        if (backgroundAlpha < 255) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putFloat(KEY_BACKGROUND_OPACITY, (float)backgroundAlpha / 255.0f * 100.0f);
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 7, resultMetadata);
        }
        double contrastRatio = ContrastUtils.calculateContrastRatio(textColor, backgroundDrawableColor);
        double d = requiredContrast = TextContrastCheck.isLargeText(view) ? 3.0 : 4.5;
        if (requiredContrast - contrastRatio > 0.01) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putDouble(KEY_REQUIRED_CONTRAST_RATIO, requiredContrast);
            resultMetadata.putDouble(KEY_CONTRAST_RATIO, contrastRatio);
            resultMetadata.putInt(KEY_TEXT_COLOR, textColor);
            resultMetadata.putInt(KEY_BACKGROUND_COLOR, backgroundDrawableColor);
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, view, 8, resultMetadata);
        }
        return null;
    }

    private @Nullable AccessibilityHierarchyCheckResult attemptHeavyweightEval(ViewHierarchyElement view, @Nullable Parameters parameters) {
        Double customizedHeuristicContrastRatio;
        Image screenCapture;
        Image image = screenCapture = parameters == null ? null : parameters.getScreenCapture();
        if (screenCapture == null) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 9, null);
        }
        Rect screenCaptureBounds = new Rect(0, 0, screenCapture.getWidth(), screenCapture.getHeight());
        Rect viewBounds = view.getBoundsInScreen();
        if (viewBounds.isEmpty() || !screenCaptureBounds.contains(viewBounds)) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_VIEW_BOUNDS_STRING, viewBounds.toShortString());
            resultMetadata.putString(KEY_SCREENSHOT_BOUNDS_STRING, screenCaptureBounds.toShortString());
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 10, resultMetadata);
        }
        Image viewImage = this.crop(screenCapture, viewBounds);
        ContrastSwatch contrastSwatch = this.getContrastSwatch(viewImage, parameters == null ? null : parameters.getEnableEnhancedContrastEvaluation());
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        if (view.isAgainstScrollableEdge()) {
            resultMetadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
        }
        int foreground = (Integer)contrastSwatch.getForegroundColors().get(0);
        int background = contrastSwatch.getBackgroundColor();
        if (background == foreground) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, foreground == -16777216 ? 14 : 16, resultMetadata);
        }
        ImmutableList<Integer> foregroundColors = contrastSwatch.getForegroundColors();
        ImmutableList<Double> contrastRatios = contrastSwatch.getContrastRatios();
        ArrayList<Integer> lowForegroundColors = new ArrayList<Integer>();
        ArrayList<Double> lowContrastRatios = new ArrayList<Double>();
        Double d = customizedHeuristicContrastRatio = parameters == null ? null : parameters.getCustomContrastRatio();
        if (customizedHeuristicContrastRatio != null) {
            for (int i = 0; i < contrastRatios.size(); ++i) {
                if (!(customizedHeuristicContrastRatio - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, customizedHeuristicContrastRatio);
                this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 15, resultMetadata, parameters, viewImage);
            }
        } else {
            int i;
            for (i = 0; i < contrastRatios.size(); ++i) {
                if (!(3.0 - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_REQUIRED_CONTRAST_RATIO, 3.0);
                this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 11, resultMetadata, parameters, viewImage);
            }
            for (i = 0; i < contrastRatios.size(); ++i) {
                if (!(4.5 - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_REQUIRED_CONTRAST_RATIO, 4.5);
                resultMetadata.putDouble(KEY_TOLERANT_CONTRAST_RATIO, 3.0);
                this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 12, resultMetadata, parameters, viewImage);
            }
        }
        return null;
    }

    @VisibleForTesting
    ContrastSwatch getContrastSwatch(Image image, @Nullable Boolean enableEnhancedContrastEvaluation) {
        return new ContrastSwatch(image, enableEnhancedContrastEvaluation == null ? false : enableEnhancedContrastEvaluation);
    }

    private Image crop(Image screenCapture, Rect viewBounds) {
        return screenCapture.crop(viewBounds.getLeft(), viewBounds.getTop(), viewBounds.getWidth(), viewBounds.getHeight());
    }

    private AccessibilityHierarchyCheckResult resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType type, ViewHierarchyElement view, int resultId, ResultMetadata metadata, @Nullable Parameters parameters, @Nullable Image viewImage) {
        if (viewImage != null && parameters != null && Boolean.TRUE.equals(parameters.getSaveViewImages())) {
            return new AccessibilityHierarchyCheckResultWithImage(CHECK_CLASS, type, view, resultId, metadata, viewImage);
        }
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, type, view, resultId, metadata);
    }

    private void storeColorsAndContrastRatios(ResultMetadata resultMetadata, int background, List<Integer> foregroundColors, List<Double> contrastRatios) {
        resultMetadata.putInt(KEY_BACKGROUND_COLOR, background);
        this.storeForegroundColors(resultMetadata, foregroundColors);
        this.storeContrastRatios(resultMetadata, contrastRatios);
    }

    private void storeForegroundColors(ResultMetadata resultMetadata, List<Integer> foregroundColors) {
        resultMetadata.putInt(KEY_FOREGROUND_COLOR, foregroundColors.get(0));
        if (foregroundColors.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_FOREGROUND_COLORS, Lists.transform(foregroundColors.subList(1, foregroundColors.size()), integer2 -> integer2.toString()));
        }
    }

    private void storeContrastRatios(ResultMetadata resultMetadata, List<Double> contrastRatios) {
        resultMetadata.putDouble(KEY_CONTRAST_RATIO, contrastRatios.get(0));
        if (contrastRatios.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_CONTRAST_RATIOS, Lists.transform(contrastRatios.subList(1, contrastRatios.size()), ratio -> ratio.toString()));
        }
    }

    private static void appendMetadataStringsToMessageIfNeeded(Locale locale, ResultMetadata resultMetadata, StringBuilder builder) {
        if (resultMetadata.getBoolean(KEY_IS_POTENTIALLY_OBSCURED, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_view_potentially_obscured"));
        }
        if (resultMetadata.getBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_against_scrollable_edge"));
        }
    }

    private static boolean isLargeText(ViewHierarchyElement view) {
        float density = view.getWindow().getAccessibilityHierarchy().getDeviceState().getDefaultDisplayInfo().getMetricsWithoutDecoration().getScaledDensity();
        Float textSize = view.getTextSize();
        float dpSize = textSize != null ? textSize.floatValue() / density : 0.0f;
        int style2 = view.getTypefaceStyle() != null ? view.getTypefaceStyle() : 0;
        return dpSize >= 18.0f || dpSize >= 14.0f && (style2 & 1) != 0;
    }
}

