/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;

public class Span {
    private final String spanClassName;
    private final int start;
    private final int end;
    private final int flags;

    public Span(String spanClassName, int start, int end, int flags) {
        this.spanClassName = spanClassName;
        this.start = start;
        this.end = end;
        this.flags = flags;
    }

    public Span(AndroidFrameworkProtos.SpanProto proto) {
        this.spanClassName = proto.getSpanClassName();
        this.start = proto.getStart();
        this.end = proto.getEnd();
        this.flags = proto.getFlags();
    }

    public String getSpanClassName() {
        return this.spanClassName;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getFlags() {
        return this.flags;
    }

    public AndroidFrameworkProtos.SpanProto toProto() {
        AndroidFrameworkProtos.SpanProto.Builder builder = AndroidFrameworkProtos.SpanProto.newBuilder();
        builder.setSpanClassName(this.spanClassName);
        builder.setStart(this.start);
        builder.setEnd(this.end);
        builder.setFlags(this.flags);
        builder.setType(AndroidFrameworkProtos.SpanProto.SpanType.UNKNOWN);
        return (AndroidFrameworkProtos.SpanProto)builder.build();
    }

    protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
        return new Span(this.spanClassName, newStart, newEnd, this.flags);
    }
}

