/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.misc.CompoundEnumeration;

public class BaseDexClassLoader
extends ClassLoader {
    private static volatile Reporter reporter = null;
    @UnsupportedAppUsage
    private final DexPathList pathList;
    protected final ClassLoader[] sharedLibraryLoaders;

    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent) {
        this(dexPath, librarySearchPath, parent, null, false);
    }

    @UnsupportedAppUsage
    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent, boolean isTrusted) {
        this(dexPath, librarySearchPath, parent, null, isTrusted);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] libraries) {
        this(dexPath, librarySearchPath, parent, libraries, false);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] sharedLibraryLoaders, boolean isTrusted) {
        super(parent);
        this.sharedLibraryLoaders = sharedLibraryLoaders == null ? null : Arrays.copyOf(sharedLibraryLoaders, sharedLibraryLoaders.length);
        this.pathList = new DexPathList(this, dexPath, librarySearchPath, null, isTrusted);
        this.reportClassLoaderChain();
    }

    public void reportClassLoaderChain() {
        if (reporter == null) {
            return;
        }
        String[] classPathAndClassLoaderContexts = this.computeClassLoaderContextsNative();
        if (classPathAndClassLoaderContexts.length == 0) {
            return;
        }
        HashMap<String, String> dexFileMapping = new HashMap<String, String>(classPathAndClassLoaderContexts.length / 2);
        for (int i = 0; i < classPathAndClassLoaderContexts.length; i += 2) {
            dexFileMapping.put(classPathAndClassLoaderContexts[i], classPathAndClassLoaderContexts[i + 1]);
        }
        reporter.report(Collections.unmodifiableMap(dexFileMapping));
    }

    private String[] computeClassLoaderContextsNative() {
        return (String[])OverrideMethod.invokeA("dalvik.system.BaseDexClassLoader#computeClassLoaderContextsNative()[Ljava/lang/String;", true, this);
    }

    public BaseDexClassLoader(ByteBuffer[] dexFiles, String librarySearchPath, ClassLoader parent) {
        super(parent);
        this.sharedLibraryLoaders = null;
        this.pathList = new DexPathList(this, librarySearchPath);
        this.pathList.initByteBufferDexPath(dexFiles);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ArrayList<Throwable> suppressedExceptions;
        Class<?> c;
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if ((c = this.pathList.findClass(name, suppressedExceptions = new ArrayList<Throwable>())) == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException("Didn't find class \"" + name + "\" on path: " + this.pathList);
            for (Throwable t : suppressedExceptions) {
                cnfe.addSuppressed(t);
            }
            throw cnfe;
        }
        return c;
    }

    @UnsupportedAppUsage
    public void addDexPath(String dexPath) {
        this.addDexPath(dexPath, false);
    }

    @UnsupportedAppUsage
    public void addDexPath(String dexPath, boolean isTrusted) {
        this.pathList.addDexPath(dexPath, null, isTrusted);
    }

    public void addNativePath(Collection<String> libPaths) {
        this.pathList.addNativePath(libPaths);
    }

    @Override
    protected URL findResource(String name) {
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                URL url = loader.getResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return this.pathList.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Enumeration<URL> myResources = this.pathList.findResources(name);
        if (this.sharedLibraryLoaders == null) {
            return myResources;
        }
        Enumeration[] tmp = new Enumeration[this.sharedLibraryLoaders.length + 1];
        for (int i = 0; i < this.sharedLibraryLoaders.length; ++i) {
            try {
                tmp[i] = this.sharedLibraryLoaders[i].getResources(name);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        tmp[this.sharedLibraryLoaders.length] = myResources;
        return new CompoundEnumeration(tmp);
    }

    @Override
    public String findLibrary(String name) {
        return this.pathList.findLibrary(name);
    }

    @Override
    protected synchronized Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            Package pack = super.getPackage(name);
            if (pack == null) {
                pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
            }
            return pack;
        }
        return null;
    }

    @UnsupportedAppUsage
    public String getLdLibraryPath() {
        StringBuilder result = new StringBuilder();
        for (File directory : this.pathList.getNativeLibraryDirectories()) {
            if (result.length() > 0) {
                result.append(':');
            }
            result.append(directory);
        }
        return result.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.pathList + "]";
    }

    public static void setReporter(Reporter newReporter) {
        reporter = newReporter;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    public static interface Reporter {
        public void report(Map<String, String> var1);
    }
}

