/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.java.LinkedHashMap_Delegate;
import java.util.LinkedHashMap;
import java.util.Map;

public class BasicLruCache<K, V> {
    @UnsupportedAppUsage
    private final LinkedHashMap<K, V> map;
    private final int maxSize;

    @UnsupportedAppUsage
    public BasicLruCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public V get(K key) {
        V result;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        BasicLruCache basicLruCache = this;
        synchronized (basicLruCache) {
            result = this.map.get(key);
            if (result != null) {
                return result;
            }
        }
        result = this.create(key);
        basicLruCache = this;
        synchronized (basicLruCache) {
            if (result != null) {
                this.map.put(key, result);
                this.trimToSize(this.maxSize);
            }
        }
        return result;
    }

    @UnsupportedAppUsage
    public synchronized V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        V previous = this.map.put(key, value);
        this.trimToSize(this.maxSize);
        return previous;
    }

    private void trimToSize(int maxSize) {
        while (this.map.size() > maxSize) {
            Map.Entry<K, V> toEvict = LinkedHashMap_Delegate.eldest(this.map);
            K key = toEvict.getKey();
            V value = toEvict.getValue();
            this.map.remove(key);
            this.entryEvicted(key, value);
        }
    }

    protected void entryEvicted(K key, V value) {
    }

    protected V create(K key) {
        return null;
    }

    public synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    @UnsupportedAppUsage
    public synchronized void evictAll() {
        this.trimToSize(0);
    }
}

