/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;

class Tokeniser {
    static final char replacementChar = '\ufffd';
    private CharacterReader reader;
    private ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private Token emitPending;
    private boolean isEmitPending = false;
    private StringBuilder charBuffer = new StringBuilder();
    StringBuilder dataBuffer;
    Token.Tag tagPending;
    Token.Doctype doctypePending;
    Token.Comment commentPending;
    private Token.StartTag lastStartTag;
    private boolean selfClosingFlagAcknowledged = true;

    Tokeniser(CharacterReader reader, ParseErrorList errors) {
        this.reader = reader;
        this.errors = errors;
    }

    Token read() {
        if (!this.selfClosingFlagAcknowledged) {
            this.error("Self closing flag not acknowledged");
            this.selfClosingFlagAcknowledged = true;
        }
        while (!this.isEmitPending) {
            this.state.read(this, this.reader);
        }
        if (this.charBuffer.length() > 0) {
            String str = this.charBuffer.toString();
            this.charBuffer.delete(0, this.charBuffer.length());
            return new Token.Character(str);
        }
        this.isEmitPending = false;
        return this.emitPending;
    }

    void emit(Token token) {
        Validate.isFalse(this.isEmitPending, "There is an unread token pending!");
        this.emitPending = token;
        this.isEmitPending = true;
        if (token.type == Token.TokenType.StartTag) {
            Token.StartTag startTag;
            this.lastStartTag = startTag = (Token.StartTag)token;
            if (startTag.selfClosing) {
                this.selfClosingFlagAcknowledged = false;
            }
        } else if (token.type == Token.TokenType.EndTag) {
            Token.EndTag endTag = (Token.EndTag)token;
            if (endTag.attributes.size() > 0) {
                this.error("Attributes incorrectly present on end tag");
            }
        }
    }

    void emit(String str) {
        this.charBuffer.append(str);
    }

    void emit(char c) {
        this.charBuffer.append(c);
    }

    TokeniserState getState() {
        return this.state;
    }

    void transition(TokeniserState state) {
        this.state = state;
    }

    void advanceTransition(TokeniserState state) {
        this.reader.advance();
        this.state = state;
    }

    void acknowledgeSelfClosingFlag() {
        this.selfClosingFlagAcknowledged = true;
    }

    Character consumeCharacterReference(Character additionalAllowedCharacter, boolean inAttribute) {
        if (this.reader.isEmpty()) {
            return null;
        }
        if (additionalAllowedCharacter != null && additionalAllowedCharacter.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAny('\t', '\n', '\f', ' ', '<', '&')) {
            return null;
        }
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            String numRef;
            boolean isHexMode = this.reader.matchConsumeIgnoreCase("X");
            String string2 = numRef = isHexMode ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (numRef.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals");
                this.reader.rewindToMark();
                return null;
            }
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon");
            }
            int charval = -1;
            try {
                int base = isHexMode ? 16 : 10;
                charval = Integer.valueOf(numRef, base);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (charval == -1 || charval >= 55296 && charval <= 57343 || charval > 0x10FFFF) {
                this.characterReferenceError("character outside of valid range");
                return Character.valueOf('\ufffd');
            }
            return Character.valueOf((char)charval);
        }
        String nameRef = this.reader.consumeLetterThenDigitSequence();
        String origNameRef = new String(nameRef);
        boolean looksLegit = this.reader.matches(';');
        boolean found = false;
        while (nameRef.length() > 0 && !found) {
            if (Entities.isNamedEntity(nameRef)) {
                found = true;
                continue;
            }
            nameRef = nameRef.substring(0, nameRef.length() - 1);
            this.reader.unconsume();
        }
        if (!found) {
            if (looksLegit) {
                this.characterReferenceError(String.format("invalid named referenece '%s'", origNameRef));
            }
            this.reader.rewindToMark();
            return null;
        }
        if (inAttribute && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon");
        }
        return Entities.getCharacterByName(nameRef);
    }

    Token.Tag createTagPending(boolean start) {
        this.tagPending = start ? new Token.StartTag() : new Token.EndTag();
        return this.tagPending;
    }

    void emitTagPending() {
        this.tagPending.finaliseTag();
        this.emit(this.tagPending);
    }

    void createCommentPending() {
        this.commentPending = new Token.Comment();
    }

    void emitCommentPending() {
        this.emit(this.commentPending);
    }

    void createDoctypePending() {
        this.doctypePending = new Token.Doctype();
    }

    void emitDoctypePending() {
        this.emit(this.doctypePending);
    }

    void createTempBuffer() {
        this.dataBuffer = new StringBuilder();
    }

    boolean isAppropriateEndTagToken() {
        if (this.lastStartTag == null) {
            return false;
        }
        return this.tagPending.tagName.equals(this.lastStartTag.tagName);
    }

    String appropriateEndTagName() {
        return this.lastStartTag.tagName;
    }

    void error(TokeniserState state) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected character '%s' in input state [%s]", new Object[]{Character.valueOf(this.reader.current()), state}));
        }
    }

    void eofError(TokeniserState state) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpectedly reached end of file (EOF) in input state [%s]", new Object[]{state}));
        }
    }

    private void characterReferenceError(String message) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Invalid character reference: %s", message));
        }
    }

    private void error(String errorMsg) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), errorMsg));
        }
    }

    boolean currentNodeInHtmlNS() {
        return true;
    }
}

