/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.StrictMode;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ExponentiallyBucketedHistogram;
import com.android.tools.layoutlib.java.System_Delegate;
import java.util.Iterator;
import java.util.LinkedList;

public class QueuedWork {
    private static final String LOG_TAG = QueuedWork.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final long DELAY = 100L;
    private static final long MAX_WAIT_TIME_MILLIS = 512L;
    private static final Object sLock = new Object();
    private static Object sProcessingWork = new Object();
    @GuardedBy(value="sLock")
    private static final LinkedList<Runnable> sFinishers = new LinkedList();
    @GuardedBy(value="sLock")
    private static Handler sHandler = null;
    @GuardedBy(value="sLock")
    private static final LinkedList<Runnable> sWork = new LinkedList();
    @GuardedBy(value="sLock")
    private static boolean sCanDelay = true;
    @GuardedBy(value="sLock")
    private static final ExponentiallyBucketedHistogram mWaitTimes = new ExponentiallyBucketedHistogram(16);
    private static int mNumWaits = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sHandler == null) {
                HandlerThread handlerThread = new HandlerThread("queued-work-looper", -2);
                handlerThread.start();
                sHandler = new QueuedWorkHandler(handlerThread.getLooper());
            }
            return sHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFinisher(Runnable finisher) {
        Object object = sLock;
        synchronized (object) {
            sFinishers.add(finisher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFinisher(Runnable finisher) {
        Object object = sLock;
        synchronized (object) {
            sFinishers.remove(finisher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitToFinish() {
        long startTime = System_Delegate.currentTimeMillis();
        boolean hadMessages = false;
        Handler handler = QueuedWork.getHandler();
        Object object = sLock;
        synchronized (object) {
            if (handler.hasMessages(1)) {
                handler.removeMessages(1);
            }
            sCanDelay = false;
        }
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            QueuedWork.processPendingWork();
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        try {
            while (true) {
                Runnable finisher;
                Object object2 = sLock;
                synchronized (object2) {
                    finisher = sFinishers.poll();
                }
                if (finisher == null) {
                    break;
                }
                finisher.run();
            }
        }
        finally {
            sCanDelay = true;
        }
        Object object3 = sLock;
        synchronized (object3) {
            long waitTime = System_Delegate.currentTimeMillis() - startTime;
            if (waitTime > 0L || hadMessages) {
                mWaitTimes.add(Long.valueOf(waitTime).intValue());
                if (++mNumWaits % 1024 == 0 || waitTime > 512L) {
                    mWaitTimes.log(LOG_TAG, "waited: ");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Runnable work, boolean shouldDelay) {
        Handler handler = QueuedWork.getHandler();
        Object object = sLock;
        synchronized (object) {
            sWork.add(work);
            if (shouldDelay && sCanDelay) {
                handler.sendEmptyMessageDelayed(1, 100L);
            } else {
                handler.sendEmptyMessage(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPendingWork() {
        Object object = sLock;
        synchronized (object) {
            return !sWork.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingWork() {
        long startTime = 0L;
        Object object = sProcessingWork;
        synchronized (object) {
            LinkedList work;
            Iterator iterator = sLock;
            synchronized (iterator) {
                work = (LinkedList)sWork.clone();
                sWork.clear();
                QueuedWork.getHandler().removeMessages(1);
            }
            if (work.size() > 0) {
                for (Runnable w : work) {
                    w.run();
                }
            }
        }
    }

    private static class QueuedWorkHandler
    extends Handler {
        static final int MSG_RUN = 1;

        QueuedWorkHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                QueuedWork.processPendingWork();
            }
        }
    }
}

