/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.os.IBinder;
import android.os.IStatsManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidException;
import android.util.Slog;

@SystemApi
public class StatsManager {
    private static final String TAG = "StatsManager";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private IStatsManager mService;
    public static final String EXTRA_STATS_CONFIG_UID = "android.app.extra.STATS_CONFIG_UID";
    public static final String EXTRA_STATS_CONFIG_KEY = "android.app.extra.STATS_CONFIG_KEY";
    public static final String EXTRA_STATS_SUBSCRIPTION_ID = "android.app.extra.STATS_SUBSCRIPTION_ID";
    public static final String EXTRA_STATS_SUBSCRIPTION_RULE_ID = "android.app.extra.STATS_SUBSCRIPTION_RULE_ID";
    public static final String EXTRA_STATS_BROADCAST_SUBSCRIBER_COOKIES = "android.app.extra.STATS_BROADCAST_SUBSCRIBER_COOKIES";
    public static final String EXTRA_STATS_DIMENSIONS_VALUE = "android.app.extra.STATS_DIMENSIONS_VALUE";
    public static final String ACTION_STATSD_STARTED = "android.app.action.STATSD_STARTED";

    public StatsManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(long configKey, byte[] config) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                service.addConfiguration(configKey, config, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when adding configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public boolean addConfiguration(long configKey, byte[] config) {
        try {
            this.addConfig(configKey, config);
            return true;
        }
        catch (StatsUnavailableException | IllegalArgumentException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfig(long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                service.removeConfiguration(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when removing configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public boolean removeConfiguration(long configKey) {
        try {
            this.removeConfig(configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBroadcastSubscriber(PendingIntent pendingIntent, long configKey, long subscriberId) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (pendingIntent != null) {
                    IBinder intentSender = pendingIntent.getTarget().asBinder();
                    service.setBroadcastSubscriber(configKey, subscriberId, intentSender, this.mContext.getOpPackageName());
                } else {
                    service.unsetBroadcastSubscriber(configKey, subscriberId, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when adding broadcast subscriber", e);
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public boolean setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent) {
        try {
            this.setBroadcastSubscriber(pendingIntent, configKey, subscriberId);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchReportsOperation(PendingIntent pendingIntent, long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (pendingIntent == null) {
                    service.removeDataFetchOperation(configKey, this.mContext.getOpPackageName());
                } else {
                    IBinder intentSender = pendingIntent.getTarget().asBinder();
                    service.setDataFetchOperation(configKey, intentSender, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when registering data listener.");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public boolean setDataFetchOperation(long configKey, PendingIntent pendingIntent) {
        try {
            this.setFetchReportsOperation(pendingIntent, configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    public byte[] getReports(long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                return service.getData(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when getting data");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public byte[] getData(long configKey) {
        try {
            return this.getReports(configKey);
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    public byte[] getStatsMetadata() throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                return service.getMetadata(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to connect to statsd when getting metadata");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    public byte[] getMetadata() {
        try {
            return this.getStatsMetadata();
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    private IStatsManager getIStatsManagerLocked() throws StatsUnavailableException {
        if (this.mService != null) {
            return this.mService;
        }
        this.mService = IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
        if (this.mService == null) {
            throw new StatsUnavailableException("could not be found");
        }
        try {
            this.mService.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
        }
        catch (RemoteException e) {
            throw new StatsUnavailableException("could not connect when linkToDeath", e);
        }
        return this.mService;
    }

    public static class StatsUnavailableException
    extends AndroidException {
        public StatsUnavailableException(String reason) {
            super("Failed to connect to statsd: " + reason);
        }

        public StatsUnavailableException(String reason, Throwable e) {
            super("Failed to connect to statsd: " + reason, e);
        }
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            StatsdDeathRecipient statsdDeathRecipient = this;
            synchronized (statsdDeathRecipient) {
                StatsManager.this.mService = null;
            }
        }
    }
}

