/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHidDeviceAppQosSettings;
import android.bluetooth.BluetoothHidDeviceAppSdpSettings;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHidDevice;
import android.bluetooth.IBluetoothHidDeviceCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class BluetoothHidDevice
implements BluetoothProfile {
    private static final String TAG = BluetoothHidDevice.class.getSimpleName();
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hiddevice.profile.action.CONNECTION_STATE_CHANGED";
    public static final byte SUBCLASS1_NONE = 0;
    public static final byte SUBCLASS1_KEYBOARD = 64;
    public static final byte SUBCLASS1_MOUSE = -128;
    public static final byte SUBCLASS1_COMBO = -64;
    public static final byte SUBCLASS2_UNCATEGORIZED = 0;
    public static final byte SUBCLASS2_JOYSTICK = 1;
    public static final byte SUBCLASS2_GAMEPAD = 2;
    public static final byte SUBCLASS2_REMOTE_CONTROL = 3;
    public static final byte SUBCLASS2_SENSING_DEVICE = 4;
    public static final byte SUBCLASS2_DIGITIZER_TABLET = 5;
    public static final byte SUBCLASS2_CARD_READER = 6;
    public static final byte REPORT_TYPE_INPUT = 1;
    public static final byte REPORT_TYPE_OUTPUT = 2;
    public static final byte REPORT_TYPE_FEATURE = 3;
    public static final byte ERROR_RSP_SUCCESS = 0;
    public static final byte ERROR_RSP_NOT_READY = 1;
    public static final byte ERROR_RSP_INVALID_RPT_ID = 2;
    public static final byte ERROR_RSP_UNSUPPORTED_REQ = 3;
    public static final byte ERROR_RSP_INVALID_PARAM = 4;
    public static final byte ERROR_RSP_UNKNOWN = 14;
    public static final byte PROTOCOL_BOOT_MODE = 0;
    public static final byte PROTOCOL_REPORT_MODE = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private volatile IBluetoothHidDevice mService;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(TAG, "onBluetoothStateChange: up=" + up);
            ServiceConnection serviceConnection = BluetoothHidDevice.this.mConnection;
            synchronized (serviceConnection) {
                if (up) {
                    try {
                        if (BluetoothHidDevice.this.mService == null) {
                            Log.d(TAG, "Binding HID Device service...");
                            BluetoothHidDevice.this.doBind();
                        }
                    }
                    catch (IllegalStateException e) {
                        Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                    }
                    catch (SecurityException e) {
                        Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                    }
                } else {
                    Log.d(TAG, "Unbinding service...");
                    BluetoothHidDevice.this.doUnbind();
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d(TAG, "onServiceConnected()");
            BluetoothHidDevice.this.mService = IBluetoothHidDevice.Stub.asInterface(service);
            if (BluetoothHidDevice.this.mServiceListener != null) {
                BluetoothHidDevice.this.mServiceListener.onServiceConnected(19, BluetoothHidDevice.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Log.d(TAG, "onServiceDisconnected()");
            BluetoothHidDevice.this.mService = null;
            if (BluetoothHidDevice.this.mServiceListener != null) {
                BluetoothHidDevice.this.mServiceListener.onServiceDisconnected(19);
            }
        }
    };

    BluetoothHidDevice(Context context, BluetoothProfile.ServiceListener listener) {
        this.mContext = context;
        this.mServiceListener = listener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.doBind();
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothHidDevice.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e(TAG, "Could not bind to Bluetooth HID Device Service with " + intent);
            return false;
        }
        Log.d(TAG, "Bound to HID Device Service");
        return true;
    }

    void doUnbind() {
        if (this.mService != null) {
            this.mService = null;
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Unable to unbind HidDevService", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            this.doUnbind();
        }
        this.mServiceListener = null;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean registerApp(BluetoothHidDeviceAppSdpSettings sdp, BluetoothHidDeviceAppQosSettings inQos, BluetoothHidDeviceAppQosSettings outQos, Executor executor, Callback callback) {
        boolean result = false;
        if (sdp == null) {
            throw new IllegalArgumentException("sdp parameter cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor parameter cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null");
        }
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                CallbackWrapper cbw = new CallbackWrapper(executor, callback);
                result = service.registerApp(sdp, inQos, outQos, cbw);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean unregisterApp() {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.unregisterApp();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean sendReport(BluetoothDevice device, int id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.sendReport(device, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean replyReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.replyReport(device, type, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean reportError(BluetoothDevice device, byte error) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.reportError(device, error);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public String getUserAppName() {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getUserAppName();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return "";
    }

    public boolean connect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean disconnect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private static class CallbackWrapper
    extends IBluetoothHidDeviceCallback.Stub {
        private final Executor mExecutor;
        private final Callback mCallback;

        CallbackWrapper(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onAppStatusChanged(pluggedDevice, registered));
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice device, int state) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onConnectionStateChanged(device, state));
        }

        @Override
        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onGetReport(device, type, id2, bufferSize));
        }

        @Override
        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetReport(device, type, id2, data));
        }

        @Override
        public void onSetProtocol(BluetoothDevice device, byte protocol) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetProtocol(device, protocol));
        }

        @Override
        public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onInterruptData(device, reportId, data));
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice device) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onVirtualCableUnplug(device));
        }
    }

    public static abstract class Callback {
        private static final String TAG = "BluetoothHidDevCallback";

        public void onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            Log.d(TAG, "onAppStatusChanged: pluggedDevice=" + pluggedDevice + " registered=" + registered);
        }

        public void onConnectionStateChanged(BluetoothDevice device, int state) {
            Log.d(TAG, "onConnectionStateChanged: device=" + device + " state=" + state);
        }

        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            Log.d(TAG, "onGetReport: device=" + device + " type=" + type + " id=" + id2 + " bufferSize=" + bufferSize);
        }

        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            Log.d(TAG, "onSetReport: device=" + device + " type=" + type + " id=" + id2);
        }

        public void onSetProtocol(BluetoothDevice device, byte protocol) {
            Log.d(TAG, "onSetProtocol: device=" + device + " protocol=" + protocol);
        }

        public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            Log.d(TAG, "onInterruptData: device=" + device + " reportId=" + reportId);
        }

        public void onVirtualCableUnplug(BluetoothDevice device) {
            Log.d(TAG, "onVirtualCableUnplug: device=" + device);
        }
    }
}

