/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.BridgeAssetManager;
import android.graphics.FontFamily;
import android.graphics.fonts.FontVariationAxis;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;
import libcore.util.NativeAllocationRegistry_Delegate;
import sun.font.FontUtilities;

public class FontFamily_Delegate {
    public static final int DEFAULT_FONT_WEIGHT = 400;
    public static final int BOLD_FONT_WEIGHT_DELTA = 300;
    public static final int BOLD_FONT_WEIGHT = 700;
    private static final String FONT_SUFFIX_ITALIC = "Italic.ttf";
    private static final String FN_ALL_FONTS_LIST = "fontsInSdk.txt";
    private static final String EXTENSION_OTF = ".otf";
    private static final int CACHE_SIZE = 10;
    private static final Map<String, FontInfo> sCache = new LinkedHashMap<String, FontInfo>(10){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FontInfo> eldest) {
            return this.size() > 10;
        }

        @Override
        public FontInfo put(String key, FontInfo value) {
            FontInfo removed = (FontInfo)this.remove(key);
            super.put(key, value);
            return removed;
        }
    };
    private static final DelegateManager<FontFamily_Delegate> sManager = new DelegateManager<FontFamily_Delegate>(FontFamily_Delegate.class);
    private static long sFamilyFinalizer = -1L;
    private static String sFontLocation;
    private static final List<FontFamily_Delegate> sPostInitDelegate;
    private static Set<String> SDK_FONTS;
    private Map<FontInfo, Font> mFonts = new LinkedHashMap<FontInfo, Font>();
    private FontVariant mVariant;
    private List<Runnable> mPostInitRunnables = new ArrayList<Runnable>();
    private boolean mValid = false;

    public static FontFamily_Delegate getDelegate(long nativeFontFamily) {
        return sManager.getDelegate(nativeFontFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setFontLocation(String fontLocation) {
        sFontLocation = fontLocation;
        File allFonts = new File(fontLocation, FN_ALL_FONTS_LIST);
        HashSet<String> allFontsList = new HashSet<String>(128);
        try (Scanner scanner = null;){
            scanner = new Scanner(allFonts);
            while (scanner.hasNext()) {
                String name = scanner.next();
                if (name.endsWith(".xml")) continue;
                allFontsList.add(name);
            }
        }
        SDK_FONTS = Collections.unmodifiableSet(allFontsList);
        for (FontFamily_Delegate fontFamily : sPostInitDelegate) {
            fontFamily.init();
        }
        sPostInitDelegate.clear();
    }

    public Font getFont(int desiredWeight, boolean isItalic) {
        FontInfo desiredStyle = new FontInfo();
        desiredStyle.mWeight = desiredWeight;
        desiredStyle.mIsItalic = isItalic;
        Font cachedFont = this.mFonts.get(desiredStyle);
        if (cachedFont != null) {
            return cachedFont;
        }
        FontInfo bestFont = null;
        if (this.mFonts.size() == 1) {
            bestFont = this.mFonts.keySet().iterator().next();
        } else {
            int bestMatch = Integer.MAX_VALUE;
            for (FontInfo font : this.mFonts.keySet()) {
                int match = FontFamily_Delegate.computeMatch(font, desiredStyle);
                if (match >= bestMatch) continue;
                bestMatch = match;
                bestFont = font;
                if (bestMatch != 0) continue;
                break;
            }
        }
        if (bestFont == null) {
            return null;
        }
        this.deriveFont(bestFont, desiredStyle);
        this.addFont(desiredStyle);
        return desiredStyle.mFont;
    }

    public FontVariant getVariant() {
        return this.mVariant;
    }

    public boolean isValid() {
        return this.mValid;
    }

    private static Font loadFont(String path) {
        if (path.startsWith("/system/fonts/")) {
            String relativePath = path.substring("/system/fonts/".length());
            File f = new File(sFontLocation, relativePath);
            try {
                return Font.createFont(0, f);
            }
            catch (Exception e) {
                if (path.endsWith(EXTENSION_OTF) && e instanceof FontFormatException) {
                    return null;
                }
                Bridge.getLog().fidelityWarning("broken", String.format("Unable to load font %1$s", relativePath), (Throwable)e, null);
            }
        } else {
            Bridge.getLog().fidelityWarning("unsupported", "Only platform fonts located in /system/fonts/can be loaded.", null, null);
        }
        return null;
    }

    static String getFontLocation() {
        return sFontLocation;
    }

    @LayoutlibDelegate
    static boolean addFont(FontFamily thisFontFamily, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (thisFontFamily.mBuilderPtr == 0L) {
            assert (false) : "Unable to call addFont after freezing.";
            return false;
        }
        FontFamily_Delegate delegate = FontFamily_Delegate.getDelegate(thisFontFamily.mBuilderPtr);
        return delegate != null && delegate.addFont(path, ttcIndex, weight, italic);
    }

    @LayoutlibDelegate
    static long nInitBuilder(String lang, int variant) {
        FontFamily_Delegate delegate = new FontFamily_Delegate();
        assert (variant < 3);
        delegate.mVariant = FontVariant.values()[variant];
        if (sFontLocation != null) {
            delegate.init();
        } else {
            sPostInitDelegate.add(delegate);
        }
        return sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static long nCreateFamily(long builderPtr) {
        return builderPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetFamilyReleaseFunc() {
        Class<FontFamily_Delegate> clazz = FontFamily_Delegate.class;
        synchronized (FontFamily_Delegate.class) {
            if (sFamilyFinalizer == -1L) {
                sFamilyFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFamilyFinalizer;
        }
    }

    @LayoutlibDelegate
    static boolean nAddFont(long builderPtr, ByteBuffer font, int ttcIndex, int weight, int isItalic) {
        assert (false) : "The only client of this method has been overridden.";
        return false;
    }

    @LayoutlibDelegate
    static boolean nAddFontWeightStyle(long builderPtr, ByteBuffer font, int ttcIndex, int weight, int isItalic) {
        assert (false) : "The only client of this method has been overridden.";
        return false;
    }

    @LayoutlibDelegate
    static void nAddAxisValue(long builderPtr, int tag, float value) {
        assert (false) : "The only client of this method has been overridden.";
    }

    static boolean addFont(long builderPtr, String path, int weight, boolean isItalic) {
        int italic;
        FontFamily_Delegate delegate = FontFamily_Delegate.getDelegate(builderPtr);
        int n = italic = isItalic ? 1 : 0;
        if (delegate != null) {
            if (sFontLocation == null) {
                delegate.mPostInitRunnables.add(() -> delegate.addFont(path, weight, italic));
                return true;
            }
            return delegate.addFont(path, weight, italic);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LayoutlibDelegate
    static boolean nAddFontFromAssetManager(long builderPtr, AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic) {
        FontFamily_Delegate ffd = sManager.getDelegate(builderPtr);
        if (ffd == null) {
            return false;
        }
        ffd.mValid = true;
        if (mgr == null) {
            return false;
        }
        if (!(mgr instanceof BridgeAssetManager)) {
            Bridge.getLog().error("broken", "You have found a bug in the rendering library. Please file a bug at b.android.com.", (Throwable)new RuntimeException("Asset Manager is not an instance of BridgeAssetManager"), null);
            return false;
        }
        InputStream fontStream = null;
        try {
            AssetRepository assetRepository = ((BridgeAssetManager)mgr).getAssetRepository();
            if (assetRepository == null) {
                Bridge.getLog().error("missingasset", "Asset not found: " + path, null);
                boolean bl = false;
                return bl;
            }
            if (!assetRepository.isSupported()) {
                boolean bl = false;
                return bl;
            }
            FontInfo fontInfo = sCache.get(path);
            if (fontInfo != null) {
                sCache.put(path, fontInfo);
                ffd.addFont(fontInfo);
                boolean bl = true;
                return bl;
            }
            InputStream inputStream = fontStream = isAsset ? assetRepository.openAsset(path, 2) : assetRepository.openNonAsset(cookie, path, 2);
            if (fontStream == null) {
                Bridge.getLog().error("missingasset", "Asset not found: " + path, (Object)path);
                boolean bl = false;
                return bl;
            }
            Font font = Font.createFont(0, fontStream);
            fontInfo = new FontInfo();
            fontInfo.mFont = font;
            fontInfo.mWeight = weight == -1 ? FontUtilities.getFont2D(font).getWeight() : weight;
            fontInfo.mIsItalic = isItalic == -1 ? (FontUtilities.getFont2D(font).getStyle() & 2) != 0 : isItalic == 1;
            ffd.addFont(fontInfo);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Bridge.getLog().error("missingasset", "Unable to load font " + path, (Throwable)e, (Object)path);
            return false;
        }
        catch (FontFormatException e) {
            if (path.endsWith(EXTENSION_OTF)) {
                Bridge.getLog().fidelityWarning("unsupported", "OpenType fonts are not supported yet: " + path, null, (Object)path);
                return false;
            }
            Bridge.getLog().error("broken", "Unable to load font " + path, (Throwable)e, (Object)path);
            return false;
        }
        finally {
            if (fontStream != null) {
                try {
                    fontStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @LayoutlibDelegate
    static long nGetBuilderReleaseFunc() {
        return -1L;
    }

    private void init() {
        for (Runnable postInitRunnable : this.mPostInitRunnables) {
            postInitRunnable.run();
        }
        this.mPostInitRunnables = null;
    }

    private boolean addFont(String path, int ttcIndex, int weight, int italic) {
        if (sFontLocation == null) {
            this.mPostInitRunnables.add(() -> this.addFont(path, weight, italic));
            return true;
        }
        return this.addFont(path, weight, italic);
    }

    private boolean addFont(String path) {
        return this.addFont(path, 400, path.endsWith(FONT_SUFFIX_ITALIC) ? 1 : -1);
    }

    private boolean addFont(String path, int weight, int italic) {
        if (path.startsWith("/system/fonts/") && !SDK_FONTS.contains(path.substring("/system/fonts/".length()))) {
            Logger.getLogger(FontFamily_Delegate.class.getSimpleName()).warning("Unable to load font " + path);
            this.mValid = false;
            return false;
        }
        this.mValid = true;
        Font font = FontFamily_Delegate.loadFont(path);
        if (font == null) {
            return false;
        }
        FontInfo fontInfo = new FontInfo();
        fontInfo.mFont = font;
        fontInfo.mWeight = weight;
        fontInfo.mIsItalic = italic == -1 ? font.isItalic() : italic == 1;
        this.addFont(fontInfo);
        return true;
    }

    private boolean addFont(FontInfo fontInfo) {
        return this.mFonts.putIfAbsent(fontInfo, fontInfo.mFont) == null;
    }

    private static int computeMatch(FontInfo font1, FontInfo font2) {
        int score = Math.abs(font1.mWeight / 100 - font2.mWeight / 100);
        if (font1.mIsItalic != font2.mIsItalic) {
            score += 2;
        }
        return score;
    }

    private void deriveFont(FontInfo srcFont, FontInfo outFont) {
        int desiredWeight = outFont.mWeight;
        int srcWeight = srcFont.mWeight;
        assert (srcFont.mFont != null);
        Font derivedFont = srcFont.mFont;
        int derivedStyle = 0;
        if (desiredWeight >= 700 && desiredWeight - srcWeight > 150) {
            derivedStyle |= 1;
            srcWeight += 300;
        }
        if (outFont.mIsItalic && !srcFont.mIsItalic) {
            derivedStyle |= 2;
        } else if (outFont.mIsItalic != srcFont.mIsItalic) {
            outFont.mIsItalic = srcFont.mIsItalic;
        }
        if (derivedStyle != 0) {
            derivedFont = derivedFont.deriveFont(derivedStyle);
        }
        outFont.mFont = derivedFont;
        outFont.mWeight = srcWeight;
    }

    static {
        sPostInitDelegate = new ArrayList<FontFamily_Delegate>();
    }

    public static enum FontVariant {
        NONE,
        COMPACT,
        ELEGANT;

    }

    private static final class FontInfo {
        Font mFont;
        int mWeight;
        boolean mIsItalic;

        private FontInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontInfo fontInfo = (FontInfo)o;
            return this.mWeight == fontInfo.mWeight && this.mIsItalic == fontInfo.mIsItalic;
        }

        public int hashCode() {
            return Objects.hash(this.mWeight, this.mIsItalic);
        }

        public String toString() {
            return "FontInfo{mWeight=" + this.mWeight + ", mIsItalic=" + this.mIsItalic + '}';
        }
    }
}

