/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter_Delegate;
import android.graphics.PorterDuff;
import com.android.layoutlib.bridge.impl.PorterDuffUtility;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Graphics2D;

public class PorterDuffColorFilter_Delegate
extends ColorFilter_Delegate {
    private final Color mSrcColor;
    private final PorterDuff.Mode mMode;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getSupportMessage() {
        return "PorterDuff Color Filter is not supported for mode: " + this.mMode.name() + ".";
    }

    @Override
    public void applyFilter(Graphics2D g, int width, int height) {
        g.setComposite(PorterDuffUtility.getComposite(this.mMode, 255));
        g.setColor(this.mSrcColor);
        g.fillRect(0, 0, width, height);
    }

    @LayoutlibDelegate
    static long native_CreatePorterDuffFilter(int srcColor, int porterDuffMode) {
        PorterDuffColorFilter_Delegate newDelegate = new PorterDuffColorFilter_Delegate(srcColor, porterDuffMode);
        return sManager.addNewDelegate(newDelegate);
    }

    private PorterDuffColorFilter_Delegate(int srcColor, int mode) {
        this.mSrcColor = new Color(srcColor, true);
        this.mMode = this.getCompatibleMode(PorterDuffUtility.getPorterDuffMode(mode));
    }

    private PorterDuff.Mode getCompatibleMode(PorterDuff.Mode mode) {
        PorterDuff.Mode m = mode;
        switch (mode) {
            case SRC: {
                m = PorterDuff.Mode.SRC_IN;
                break;
            }
            case SRC_OVER: {
                m = PorterDuff.Mode.SRC_ATOP;
                break;
            }
            case DST_OVER: {
                m = PorterDuff.Mode.DST;
                break;
            }
            case SRC_OUT: {
                m = PorterDuff.Mode.CLEAR;
                break;
            }
            case DST_ATOP: {
                m = PorterDuff.Mode.DST_IN;
                break;
            }
            case XOR: {
                m = PorterDuff.Mode.DST_OUT;
            }
        }
        return m;
    }
}

