/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.shapes.Shape;

public class PathShape
extends Shape {
    private final float mStdWidth;
    private final float mStdHeight;
    private Path mPath;
    private float mScaleX;
    private float mScaleY;

    public PathShape(Path path, float stdWidth, float stdHeight) {
        this.mPath = path;
        this.mStdWidth = stdWidth;
        this.mStdHeight = stdHeight;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.save();
        canvas.scale(this.mScaleX, this.mScaleY);
        canvas.drawPath(this.mPath, paint);
        canvas.restore();
    }

    @Override
    protected void onResize(float width, float height) {
        this.mScaleX = width / this.mStdWidth;
        this.mScaleY = height / this.mStdHeight;
    }

    @Override
    public PathShape clone() throws CloneNotSupportedException {
        PathShape shape = (PathShape)super.clone();
        shape.mPath = new Path(this.mPath);
        return shape;
    }
}

