/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.hardware.contexthub.V1_0.PhysicalSensor;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class ContextHub {
    public String name = new String();
    public String vendor = new String();
    public String toolchain = new String();
    public int platformVersion;
    public int toolchainVersion;
    public int hubId;
    public float peakMips;
    public float stoppedPowerDrawMw;
    public float sleepPowerDrawMw;
    public float peakPowerDrawMw;
    public final ArrayList<PhysicalSensor> connectedSensors = new ArrayList();
    public int maxSupportedMsgLen;
    public long chrePlatformId;
    public byte chreApiMajorVersion;
    public byte chreApiMinorVersion;
    public short chrePatchVersion;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ContextHub.class) {
            return false;
        }
        ContextHub other = (ContextHub)otherObject;
        if (!HidlSupport.deepEquals(this.name, other.name)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.vendor, other.vendor)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.toolchain, other.toolchain)) {
            return false;
        }
        if (this.platformVersion != other.platformVersion) {
            return false;
        }
        if (this.toolchainVersion != other.toolchainVersion) {
            return false;
        }
        if (this.hubId != other.hubId) {
            return false;
        }
        if (this.peakMips != other.peakMips) {
            return false;
        }
        if (this.stoppedPowerDrawMw != other.stoppedPowerDrawMw) {
            return false;
        }
        if (this.sleepPowerDrawMw != other.sleepPowerDrawMw) {
            return false;
        }
        if (this.peakPowerDrawMw != other.peakPowerDrawMw) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.connectedSensors, other.connectedSensors)) {
            return false;
        }
        if (this.maxSupportedMsgLen != other.maxSupportedMsgLen) {
            return false;
        }
        if (this.chrePlatformId != other.chrePlatformId) {
            return false;
        }
        if (this.chreApiMajorVersion != other.chreApiMajorVersion) {
            return false;
        }
        if (this.chreApiMinorVersion != other.chreApiMinorVersion) {
            return false;
        }
        return this.chrePatchVersion == other.chrePatchVersion;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.name), HidlSupport.deepHashCode(this.vendor), HidlSupport.deepHashCode(this.toolchain), HidlSupport.deepHashCode(this.platformVersion), HidlSupport.deepHashCode(this.toolchainVersion), HidlSupport.deepHashCode(this.hubId), HidlSupport.deepHashCode(Float.valueOf(this.peakMips)), HidlSupport.deepHashCode(Float.valueOf(this.stoppedPowerDrawMw)), HidlSupport.deepHashCode(Float.valueOf(this.sleepPowerDrawMw)), HidlSupport.deepHashCode(Float.valueOf(this.peakPowerDrawMw)), HidlSupport.deepHashCode(this.connectedSensors), HidlSupport.deepHashCode(this.maxSupportedMsgLen), HidlSupport.deepHashCode(this.chrePlatformId), HidlSupport.deepHashCode(this.chreApiMajorVersion), HidlSupport.deepHashCode(this.chreApiMinorVersion), HidlSupport.deepHashCode(this.chrePatchVersion));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".name = ");
        builder.append(this.name);
        builder.append(", .vendor = ");
        builder.append(this.vendor);
        builder.append(", .toolchain = ");
        builder.append(this.toolchain);
        builder.append(", .platformVersion = ");
        builder.append(this.platformVersion);
        builder.append(", .toolchainVersion = ");
        builder.append(this.toolchainVersion);
        builder.append(", .hubId = ");
        builder.append(this.hubId);
        builder.append(", .peakMips = ");
        builder.append(this.peakMips);
        builder.append(", .stoppedPowerDrawMw = ");
        builder.append(this.stoppedPowerDrawMw);
        builder.append(", .sleepPowerDrawMw = ");
        builder.append(this.sleepPowerDrawMw);
        builder.append(", .peakPowerDrawMw = ");
        builder.append(this.peakPowerDrawMw);
        builder.append(", .connectedSensors = ");
        builder.append(this.connectedSensors);
        builder.append(", .maxSupportedMsgLen = ");
        builder.append(this.maxSupportedMsgLen);
        builder.append(", .chrePlatformId = ");
        builder.append(this.chrePlatformId);
        builder.append(", .chreApiMajorVersion = ");
        builder.append(this.chreApiMajorVersion);
        builder.append(", .chreApiMinorVersion = ");
        builder.append(this.chreApiMinorVersion);
        builder.append(", .chrePatchVersion = ");
        builder.append(this.chrePatchVersion);
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(120L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<ContextHub> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ContextHub> _hidl_vec = new ArrayList<ContextHub>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 120, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ContextHub _hidl_vec_element = new ContextHub();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 120);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.name = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.name.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.vendor = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.vendor.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.toolchain = _hidl_blob.getString(_hidl_offset + 32L);
        parcel.readEmbeddedBuffer(this.toolchain.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, false);
        this.platformVersion = _hidl_blob.getInt32(_hidl_offset + 48L);
        this.toolchainVersion = _hidl_blob.getInt32(_hidl_offset + 52L);
        this.hubId = _hidl_blob.getInt32(_hidl_offset + 56L);
        this.peakMips = _hidl_blob.getFloat(_hidl_offset + 60L);
        this.stoppedPowerDrawMw = _hidl_blob.getFloat(_hidl_offset + 64L);
        this.sleepPowerDrawMw = _hidl_blob.getFloat(_hidl_offset + 68L);
        this.peakPowerDrawMw = _hidl_blob.getFloat(_hidl_offset + 72L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 80L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 96, _hidl_blob.handle(), _hidl_offset + 80L + 0L, true);
        this.connectedSensors.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            PhysicalSensor _hidl_vec_element = new PhysicalSensor();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 96);
            this.connectedSensors.add(_hidl_vec_element);
        }
        this.maxSupportedMsgLen = _hidl_blob.getInt32(_hidl_offset + 96L);
        this.chrePlatformId = _hidl_blob.getInt64(_hidl_offset + 104L);
        this.chreApiMajorVersion = _hidl_blob.getInt8(_hidl_offset + 112L);
        this.chreApiMinorVersion = _hidl_blob.getInt8(_hidl_offset + 113L);
        this.chrePatchVersion = _hidl_blob.getInt16(_hidl_offset + 114L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(120);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<ContextHub> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 120);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 120);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.name);
        _hidl_blob.putString(_hidl_offset + 16L, this.vendor);
        _hidl_blob.putString(_hidl_offset + 32L, this.toolchain);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.platformVersion);
        _hidl_blob.putInt32(_hidl_offset + 52L, this.toolchainVersion);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.hubId);
        _hidl_blob.putFloat(_hidl_offset + 60L, this.peakMips);
        _hidl_blob.putFloat(_hidl_offset + 64L, this.stoppedPowerDrawMw);
        _hidl_blob.putFloat(_hidl_offset + 68L, this.sleepPowerDrawMw);
        _hidl_blob.putFloat(_hidl_offset + 72L, this.peakPowerDrawMw);
        int _hidl_vec_size = this.connectedSensors.size();
        _hidl_blob.putInt32(_hidl_offset + 80L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 80L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 96);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.connectedSensors.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 96);
        }
        _hidl_blob.putBlob(_hidl_offset + 80L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 96L, this.maxSupportedMsgLen);
        _hidl_blob.putInt64(_hidl_offset + 104L, this.chrePlatformId);
        _hidl_blob.putInt8(_hidl_offset + 112L, this.chreApiMajorVersion);
        _hidl_blob.putInt8(_hidl_offset + 113L, this.chreApiMinorVersion);
        _hidl_blob.putInt16(_hidl_offset + 114L, this.chrePatchVersion);
    }
}

