/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;

public class BufferingParams
implements Parcelable {
    private static final int BUFFERING_NO_MARK = -1;
    private int mInitialMarkMs = -1;
    private int mResumePlaybackMarkMs = -1;
    public static final Parcelable.Creator<BufferingParams> CREATOR = new Parcelable.Creator<BufferingParams>(){

        @Override
        public BufferingParams createFromParcel(Parcel in) {
            return new BufferingParams(in);
        }

        public BufferingParams[] newArray(int size) {
            return new BufferingParams[size];
        }
    };

    private BufferingParams() {
    }

    public int getInitialMarkMs() {
        return this.mInitialMarkMs;
    }

    public int getResumePlaybackMarkMs() {
        return this.mResumePlaybackMarkMs;
    }

    private BufferingParams(Parcel in) {
        this.mInitialMarkMs = in.readInt();
        this.mResumePlaybackMarkMs = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mInitialMarkMs);
        dest.writeInt(this.mResumePlaybackMarkMs);
    }

    public static class Builder {
        private int mInitialMarkMs = -1;
        private int mResumePlaybackMarkMs = -1;

        public Builder() {
        }

        public Builder(BufferingParams bp) {
            this.mInitialMarkMs = bp.mInitialMarkMs;
            this.mResumePlaybackMarkMs = bp.mResumePlaybackMarkMs;
        }

        public BufferingParams build() {
            BufferingParams bp = new BufferingParams();
            bp.mInitialMarkMs = this.mInitialMarkMs;
            bp.mResumePlaybackMarkMs = this.mResumePlaybackMarkMs;
            return bp;
        }

        public Builder setInitialMarkMs(int markMs) {
            this.mInitialMarkMs = markMs;
            return this;
        }

        public Builder setResumePlaybackMarkMs(int markMs) {
            this.mResumePlaybackMarkMs = markMs;
            return this;
        }
    }
}

