/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.DataSourceDesc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class MediaPlayerBase
implements AutoCloseable {
    public static final int PLAYER_STATE_IDLE = 0;
    public static final int PLAYER_STATE_PAUSED = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_ERROR = 3;
    public static final int BUFFERING_STATE_UNKNOWN = 0;
    public static final int BUFFERING_STATE_BUFFERING_AND_PLAYABLE = 1;
    public static final int BUFFERING_STATE_BUFFERING_AND_STARVED = 2;
    public static final int BUFFERING_STATE_BUFFERING_COMPLETE = 3;
    public static final long UNKNOWN_TIME = -1L;

    public abstract void play();

    public abstract void prepare();

    public abstract void pause();

    public abstract void reset();

    public abstract void skipToNext();

    public abstract void seekTo(long var1);

    public long getCurrentPosition() {
        return -1L;
    }

    public long getDuration() {
        return -1L;
    }

    public long getBufferedPosition() {
        return -1L;
    }

    public abstract int getPlayerState();

    public abstract int getBufferingState();

    public abstract void setAudioAttributes(AudioAttributes var1);

    public abstract AudioAttributes getAudioAttributes();

    public abstract void setDataSource(DataSourceDesc var1);

    public abstract void setNextDataSource(DataSourceDesc var1);

    public abstract void setNextDataSources(List<DataSourceDesc> var1);

    public abstract DataSourceDesc getCurrentDataSource();

    public abstract void loopCurrent(boolean var1);

    public abstract void setPlaybackSpeed(float var1);

    public float getPlaybackSpeed() {
        return 1.0f;
    }

    public boolean isReversePlaybackSupported() {
        return false;
    }

    public abstract void setPlayerVolume(float var1);

    public abstract float getPlayerVolume();

    public float getMaxPlayerVolume() {
        return 1.0f;
    }

    public abstract void registerPlayerEventCallback(Executor var1, PlayerEventCallback var2);

    public abstract void unregisterPlayerEventCallback(PlayerEventCallback var1);

    public static abstract class PlayerEventCallback {
        public void onCurrentDataSourceChanged(MediaPlayerBase mpb, DataSourceDesc dsd) {
        }

        public void onMediaPrepared(MediaPlayerBase mpb, DataSourceDesc dsd) {
        }

        public void onPlayerStateChanged(MediaPlayerBase mpb, int state) {
        }

        public void onBufferingStateChanged(MediaPlayerBase mpb, DataSourceDesc dsd, int state) {
        }

        public void onPlaybackSpeedChanged(MediaPlayerBase mpb, float speed) {
        }

        public void onSeekCompleted(MediaPlayerBase mpb, long position) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuffState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerState {
    }
}

