/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.server.NetworkManagementSocketTagger;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;

public class TrafficStats {
    public static final int UNSUPPORTED = -1;
    @Deprecated
    public static final long KB_IN_BYTES = 1024L;
    @Deprecated
    public static final long MB_IN_BYTES = 0x100000L;
    @Deprecated
    public static final long GB_IN_BYTES = 0x40000000L;
    @Deprecated
    public static final long TB_IN_BYTES = 0x10000000000L;
    @Deprecated
    public static final long PB_IN_BYTES = 0x4000000000000L;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    public static final int TAG_SYSTEM_BACKUP = -253;
    public static final int TAG_SYSTEM_RESTORE = -252;
    public static final int TAG_SYSTEM_APP = -251;
    public static final int TAG_SYSTEM_DHCP = -192;
    public static final int TAG_SYSTEM_NTP = -191;
    public static final int TAG_SYSTEM_PROBE = -190;
    public static final int TAG_SYSTEM_NEIGHBOR = -189;
    public static final int TAG_SYSTEM_GPS = -188;
    public static final int TAG_SYSTEM_PAC = -187;
    private static INetworkStatsService sStatsService;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;
    private static final String LOOPBACK_IFACE = "lo";
    private static final int TYPE_RX_BYTES = 0;
    private static final int TYPE_RX_PACKETS = 1;
    private static final int TYPE_TX_BYTES = 2;
    private static final int TYPE_TX_PACKETS = 3;
    private static final int TYPE_TCP_RX_PACKETS = 4;
    private static final int TYPE_TCP_TX_PACKETS = 5;

    private static synchronized INetworkStatsService getStatsService() {
        if (sStatsService == null) {
            sStatsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        }
        return sStatsService;
    }

    public static void setThreadStatsTag(int tag) {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(tag);
    }

    public static int getAndSetThreadStatsTag(int tag) {
        return NetworkManagementSocketTagger.setThreadSocketStatsTag(tag);
    }

    @SystemApi
    public static void setThreadStatsTagBackup() {
        TrafficStats.setThreadStatsTag(-253);
    }

    @SystemApi
    public static void setThreadStatsTagRestore() {
        TrafficStats.setThreadStatsTag(-252);
    }

    @SystemApi
    public static void setThreadStatsTagApp() {
        TrafficStats.setThreadStatsTag(-251);
    }

    public static int getThreadStatsTag() {
        return NetworkManagementSocketTagger.getThreadSocketStatsTag();
    }

    public static void clearThreadStatsTag() {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(-1);
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    public static void setThreadStatsUid(int uid) {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(uid);
    }

    public static int getThreadStatsUid() {
        return NetworkManagementSocketTagger.getThreadSocketStatsUid();
    }

    @Deprecated
    public static void setThreadStatsUidSelf() {
        TrafficStats.setThreadStatsUid(Process.myUid());
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    public static void clearThreadStatsUid() {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(-1);
    }

    public static void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagDatagramSocket(DatagramSocket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagFileDescriptor(FileDescriptor fd) throws IOException {
        SocketTagger.get().tag(fd);
    }

    public static void untagFileDescriptor(FileDescriptor fd) throws IOException {
        SocketTagger.get().untag(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            NetworkStats profilingStop = TrafficStats.getDataLayerSnapshotForUid(context);
            NetworkStats profilingDelta = NetworkStats.subtract(profilingStop, sActiveProfilingStart, null, null);
            sActiveProfilingStart = null;
            return profilingDelta;
        }
    }

    public static void incrementOperationCount(int operationCount) {
        int tag = TrafficStats.getThreadStatsTag();
        TrafficStats.incrementOperationCount(tag, operationCount);
    }

    public static void incrementOperationCount(int tag, int operationCount) {
        int uid = Process.myUid();
        try {
            TrafficStats.getStatsService().incrementOperationCount(uid, tag, operationCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void closeQuietly(INetworkStatsSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static long addIfSupported(long stat) {
        return stat == -1L ? 0L : stat;
    }

    public static long getMobileTxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxPackets(iface));
        }
        return total;
    }

    public static long getMobileRxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxPackets(iface));
        }
        return total;
    }

    public static long getMobileTxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxBytes(iface));
        }
        return total;
    }

    public static long getMobileRxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxBytes(iface));
        }
        return total;
    }

    public static long getMobileTcpRxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            long stat = -1L;
            try {
                stat = TrafficStats.getStatsService().getIfaceStats(iface, 4);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            total += TrafficStats.addIfSupported(stat);
        }
        return total;
    }

    public static long getMobileTcpTxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            long stat = -1L;
            try {
                stat = TrafficStats.getStatsService().getIfaceStats(iface, 5);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            total += TrafficStats.addIfSupported(stat);
        }
        return total;
    }

    public static long getTxPackets(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getRxPackets(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTxBytes(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getRxBytes(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackTxPackets() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackRxPackets() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackTxBytes() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackRxBytes() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalTxPackets() {
        try {
            return TrafficStats.getStatsService().getTotalStats(3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalRxPackets() {
        try {
            return TrafficStats.getStatsService().getTotalStats(1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalTxBytes() {
        try {
            return TrafficStats.getStatsService().getTotalStats(2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalRxBytes() {
        try {
            return TrafficStats.getStatsService().getTotalStats(0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getUidTxBytes(int uid) {
        int callingUid = Process.myUid();
        if (callingUid == 1000 || callingUid == uid) {
            try {
                return TrafficStats.getStatsService().getUidStats(uid, 2);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1L;
    }

    public static long getUidRxBytes(int uid) {
        int callingUid = Process.myUid();
        if (callingUid == 1000 || callingUid == uid) {
            try {
                return TrafficStats.getStatsService().getUidStats(uid, 0);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1L;
    }

    public static long getUidTxPackets(int uid) {
        int callingUid = Process.myUid();
        if (callingUid == 1000 || callingUid == uid) {
            try {
                return TrafficStats.getStatsService().getUidStats(uid, 3);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1L;
    }

    public static long getUidRxPackets(int uid) {
        int callingUid = Process.myUid();
        if (callingUid == 1000 || callingUid == uid) {
            try {
                return TrafficStats.getStatsService().getUidStats(uid, 1);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxPackets(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxPackets(int uid) {
        return -1L;
    }

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        int uid = Process.myUid();
        try {
            return TrafficStats.getStatsService().getDataLayerSnapshotForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static String[] getMobileIfaces() {
        try {
            return TrafficStats.getStatsService().getMobileIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static {
        sProfilingLock = new Object();
    }
}

