/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.InterfaceDisabledException;
import android.net.lowpan.JoinFailedAtAuthException;
import android.net.lowpan.JoinFailedAtScanException;
import android.net.lowpan.JoinFailedException;
import android.net.lowpan.LowpanRuntimeException;
import android.net.lowpan.NetworkAlreadyExistsException;
import android.net.lowpan.OperationCanceledException;
import android.net.lowpan.WrongStateException;
import android.os.ServiceSpecificException;
import android.util.AndroidException;

public class LowpanException
extends AndroidException {
    public LowpanException() {
    }

    public LowpanException(String message) {
        super(message);
    }

    public LowpanException(String message, Throwable cause) {
        super(message, cause);
    }

    public LowpanException(Exception cause) {
        super(cause);
    }

    static LowpanException rethrowFromServiceSpecificException(ServiceSpecificException e) throws LowpanException {
        switch (e.errorCode) {
            case 3: {
                throw new InterfaceDisabledException(e);
            }
            case 4: {
                throw new WrongStateException(e);
            }
            case 10: {
                throw new OperationCanceledException(e);
            }
            case 12: {
                throw new JoinFailedException(e);
            }
            case 13: {
                throw new JoinFailedAtScanException(e);
            }
            case 14: {
                throw new JoinFailedAtAuthException(e);
            }
            case 15: {
                throw new NetworkAlreadyExistsException(e);
            }
            case 11: {
                throw new LowpanException(e.getMessage() != null ? e.getMessage() : "Feature not supported", e);
            }
            case 7: {
                throw new LowpanRuntimeException(e.getMessage() != null ? e.getMessage() : "NCP problem", e);
            }
            case 2: {
                throw new LowpanRuntimeException(e.getMessage() != null ? e.getMessage() : "Invalid argument", e);
            }
        }
        throw new LowpanRuntimeException(e);
    }
}

