/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IProcessInfoService
extends IInterface {
    public void getProcessStatesFromPids(int[] var1, int[] var2) throws RemoteException;

    public void getProcessStatesAndOomScoresFromPids(int[] var1, int[] var2, int[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IProcessInfoService {
        private static final String DESCRIPTOR = "android.os.IProcessInfoService";
        static final int TRANSACTION_getProcessStatesFromPids = 1;
        static final int TRANSACTION_getProcessStatesAndOomScoresFromPids = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IProcessInfoService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IProcessInfoService) {
                return (IProcessInfoService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    this.getProcessStatesFromPids(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    int _arg1_length = data.readInt();
                    int[] _arg1 = _arg1_length < 0 ? null : new int[_arg1_length];
                    int _arg2_length = data.readInt();
                    int[] _arg2 = _arg2_length < 0 ? null : new int[_arg2_length];
                    this.getProcessStatesAndOomScoresFromPids(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeIntArray(_arg1);
                    reply.writeIntArray(_arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IProcessInfoService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getProcessStatesFromPids(int[] pids, int[] states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(pids);
                    if (states == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(states.length);
                    }
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _reply.readIntArray(states);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getProcessStatesAndOomScoresFromPids(int[] pids, int[] states, int[] scores) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(pids);
                    if (states == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(states.length);
                    }
                    if (scores == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(scores.length);
                    }
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _reply.readIntArray(states);
                    _reply.readIntArray(scores);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

