/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.IActivityManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.FileUriExposedException;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.os.strictmode.CleartextNetworkViolation;
import android.os.strictmode.ContentUriWithoutPermissionViolation;
import android.os.strictmode.CustomViolation;
import android.os.strictmode.DiskReadViolation;
import android.os.strictmode.DiskWriteViolation;
import android.os.strictmode.FileUriExposedViolation;
import android.os.strictmode.InstanceCountViolation;
import android.os.strictmode.IntentReceiverLeakedViolation;
import android.os.strictmode.LeakedClosableViolation;
import android.os.strictmode.NetworkViolation;
import android.os.strictmode.NonSdkApiUsedViolation;
import android.os.strictmode.ResourceMismatchViolation;
import android.os.strictmode.ServiceConnectionLeakedViolation;
import android.os.strictmode.SqliteObjectLeakedViolation;
import android.os.strictmode.UnbufferedIoViolation;
import android.os.strictmode.UntaggedSocketViolation;
import android.os.strictmode.Violation;
import android.os.strictmode.WebViewMethodCalledOnWrongThreadViolation;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.HexDump;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class StrictMode {
    private static final String TAG = "StrictMode";
    private static final boolean LOG_V = Log.isLoggable("StrictMode", 2);
    public static final String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    public static final String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static final String CLEARTEXT_PROPERTY = "persist.sys.strictmode.clear";
    private static final boolean DISABLE = false;
    private static final long MIN_VM_INTERVAL_MS = 1000L;
    private static final long MIN_LOG_INTERVAL_MS = 1000L;
    private static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static final int MAX_SPAN_TAGS = 20;
    private static final int MAX_OFFENSES_PER_LOOP = 10;
    public static final int DETECT_DISK_WRITE = 1;
    public static final int DETECT_DISK_READ = 2;
    public static final int DETECT_NETWORK = 4;
    public static final int DETECT_CUSTOM = 8;
    public static final int DETECT_RESOURCE_MISMATCH = 16;
    public static final int DETECT_UNBUFFERED_IO = 32;
    private static final int ALL_THREAD_DETECT_BITS = 63;
    public static final int DETECT_VM_CURSOR_LEAKS = 256;
    public static final int DETECT_VM_CLOSABLE_LEAKS = 512;
    public static final int DETECT_VM_ACTIVITY_LEAKS = 1024;
    public static final int DETECT_VM_INSTANCE_LEAKS = 2048;
    public static final int DETECT_VM_REGISTRATION_LEAKS = 4096;
    public static final int DETECT_VM_FILE_URI_EXPOSURE = 8192;
    public static final int DETECT_VM_CLEARTEXT_NETWORK = 16384;
    public static final int DETECT_VM_CONTENT_URI_WITHOUT_PERMISSION = 32768;
    public static final int DETECT_VM_UNTAGGED_SOCKET = Integer.MIN_VALUE;
    public static final int DETECT_VM_NON_SDK_API_USAGE = 0x40000000;
    private static final int ALL_VM_DETECT_BITS = -1073676544;
    public static final int PENALTY_LOG = 65536;
    public static final int PENALTY_DIALOG = 131072;
    public static final int PENALTY_DEATH = 262144;
    public static final int PENALTY_FLASH = 0x100000;
    public static final int PENALTY_DROPBOX = 0x200000;
    public static final int PENALTY_GATHER = 0x400000;
    public static final int PENALTY_DEATH_ON_NETWORK = 0x1000000;
    public static final int PENALTY_DEATH_ON_CLEARTEXT_NETWORK = 0x2000000;
    public static final int PENALTY_DEATH_ON_FILE_URI_EXPOSURE = 0x4000000;
    private static final int THREAD_PENALTY_MASK = 0x1770000;
    private static final int VM_PENALTY_MASK = 103088128;
    public static final int NETWORK_POLICY_ACCEPT = 0;
    public static final int NETWORK_POLICY_LOG = 1;
    public static final int NETWORK_POLICY_REJECT = 2;
    private static final HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP = new HashMap();
    private static volatile VmPolicy sVmPolicy = VmPolicy.LAX;
    private static final ViolationLogger LOGCAT_LOGGER;
    private static volatile ViolationLogger sLogger;
    private static final ThreadLocal<OnThreadViolationListener> sThreadViolationListener;
    private static final ThreadLocal<Executor> sThreadViolationExecutor;
    private static final AtomicInteger sDropboxCallsInFlight;
    private static final Consumer<String> sNonSdkApiUsageConsumer;
    private static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    private static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;
    private static final ThreadLocal<Handler> THREAD_HANDLER;
    private static final ThreadLocal<AndroidBlockGuardPolicy> THREAD_ANDROID_POLICY;
    private static long sLastInstanceCountCheckMillis;
    private static boolean sIsIdlerRegistered;
    private static final MessageQueue.IdleHandler sProcessIdleHandler;
    public static final String CLEARTEXT_DETECTED_MSG = "Detected cleartext network traffic from UID ";
    private static final HashMap<Integer, Long> sLastVmViolationTime;
    private static final Span NO_OP_SPAN;
    private static final ThreadLocal<ThreadSpanState> sThisThreadSpanState;
    private static Singleton<IWindowManager> sWindowManager;
    @GuardedBy(value="StrictMode.class")
    private static final HashMap<Class, Integer> sExpectedActivityInstanceCount;

    public static void setViolationLogger(ViolationLogger listener) {
        if (listener == null) {
            listener = LOGCAT_LOGGER;
        }
        sLogger = listener;
    }

    private StrictMode() {
    }

    public static void setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
        sThreadViolationListener.set(policy.mListener);
        sThreadViolationExecutor.set(policy.mCallbackExecutor);
    }

    public static void setThreadPolicyMask(int policyMask) {
        StrictMode.setBlockGuardPolicy(policyMask);
        Binder.setThreadStrictModePolicy(policyMask);
    }

    private static void setBlockGuardPolicy(int policyMask) {
        AndroidBlockGuardPolicy androidPolicy;
        if (policyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidPolicy = THREAD_ANDROID_POLICY.get();
            BlockGuard.setThreadPolicy(androidPolicy);
        }
        androidPolicy.setPolicyMask(policyMask);
    }

    private static void setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter());
        }
        CloseGuard.setEnabled(enabled);
    }

    public static int getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    public static ThreadPolicy getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        return new ThreadPolicy(StrictMode.allowThreadDiskWritesMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static int allowThreadDiskWritesMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    public static ThreadPolicy allowThreadDiskReads() {
        return new ThreadPolicy(StrictMode.allowThreadDiskReadsMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static int allowThreadDiskReadsMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    private static ThreadPolicy allowThreadViolations() {
        ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicyMask(0);
        return oldPolicy;
    }

    private static VmPolicy allowVmViolations() {
        VmPolicy oldPolicy = StrictMode.getVmPolicy();
        sVmPolicy = VmPolicy.LAX;
        return oldPolicy;
    }

    public static boolean isBundledSystemApp(ApplicationInfo ai) {
        if (ai == null || ai.packageName == null) {
            return true;
        }
        if (ai.isSystemApp()) {
            if (ai.packageName.equals("com.android.vending") || ai.packageName.equals("com.android.chrome")) {
                return false;
            }
            if (ai.packageName.equals("com.android.phone")) {
                return false;
            }
            if (ai.packageName.equals("android") || ai.packageName.startsWith("android.") || ai.packageName.startsWith("com.android.")) {
                return true;
            }
        }
        return false;
    }

    public static void initThreadDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        ThreadPolicy.Builder builder = new ThreadPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 11) {
            builder.detectNetwork();
            builder.penaltyDeathOnNetwork();
        }
        if (!_Original_Build.IS_USER && !SystemProperties.getBoolean(DISABLE_PROPERTY, false)) {
            if (_Original_Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.penaltyDropBox();
                    if (SystemProperties.getBoolean(VISUAL_PROPERTY, false)) {
                        builder.penaltyFlashScreen();
                    }
                }
            } else if (_Original_Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
                builder.penaltyFlashScreen();
            }
        }
        StrictMode.setThreadPolicy(builder.build());
    }

    public static void initVmDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        VmPolicy.Builder builder = new VmPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 24) {
            builder.detectFileUriExposure();
            builder.penaltyDeathOnFileUriExposure();
        }
        if (!_Original_Build.IS_USER && !SystemProperties.getBoolean(DISABLE_PROPERTY, false)) {
            if (_Original_Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.permitActivityLeaks();
                    builder.penaltyDropBox();
                }
            } else if (_Original_Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
            }
        }
        StrictMode.setVmPolicy(builder.build());
    }

    public static void enableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask | 0x2000 | 0x4000000, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    public static void disableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask & 0xFBFFDFFF, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    private static int parsePolicyFromMessage(String message) {
        if (message == null || !message.startsWith("policy=")) {
            return 0;
        }
        int spaceIndex = message.indexOf(32);
        if (spaceIndex == -1) {
            return 0;
        }
        String policyString = message.substring(7, spaceIndex);
        try {
            return Integer.parseInt(policyString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static boolean tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    private static void dropboxViolationAsync(int violationMaskSubset, ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d(TAG, "Dropboxing async; in-flight=" + outstanding);
        }
        BackgroundThread.getHandler().post(() -> {
            StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
            int outstandingInner = sDropboxCallsInFlight.decrementAndGet();
            if (LOG_V) {
                Log.d(TAG, "Dropbox complete; in-flight=" + outstandingInner);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleApplicationStrictModeViolation(int violationMaskSubset, ViolationInfo info) {
        int oldMask = StrictMode.getThreadPolicyMask();
        try {
            StrictMode.setThreadPolicyMask(0);
            IActivityManager am = ActivityManager.getService();
            if (am == null) {
                Log.w(TAG, "No activity manager; failed to Dropbox violation.");
            } else {
                am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
            }
        }
        catch (RemoteException e) {
            if (e instanceof DeadObjectException) {
            } else {
                Log.e(TAG, "RemoteException handling StrictMode violation", e);
            }
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    static boolean hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    public static void conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        int policySize = policy.classInstanceLimit.size();
        if (policySize == 0) {
            return;
        }
        System.gc();
        System.runFinalization();
        System.gc();
        Class[] classes = policy.classInstanceLimit.keySet().toArray(new Class[policySize]);
        long[] instanceCounts = VMDebug.countInstancesOfClasses(classes, false);
        for (int i = 0; i < classes.length; ++i) {
            long instances = instanceCounts[i];
            Class klass = classes[i];
            int limit = policy.classInstanceLimit.get(klass);
            if (instances <= (long)limit) continue;
            StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            INetworkManagementService netd;
            sVmPolicy = policy;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (StrictMode.sVmPolicy.mask & 0x6250000) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            int networkPolicy = 0;
            if ((StrictMode.sVmPolicy.mask & 0x4000) != 0) {
                networkPolicy = (StrictMode.sVmPolicy.mask & 0x40000) != 0 || (StrictMode.sVmPolicy.mask & 0x2000000) != 0 ? 2 : 1;
            }
            if ((netd = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"))) != null) {
                try {
                    netd.setUidCleartextNetworkPolicy(Process.myUid(), networkPolicy);
                }
                catch (RemoteException remoteException) {}
            } else if (networkPolicy != 0) {
                Log.w(TAG, "Dropping requested network policy due to missing service!");
            }
            if ((StrictMode.sVmPolicy.mask & 0x40000000) != 0) {
                VMRuntime.setNonSdkApiUsageConsumer(sNonSdkApiUsageConsumer);
                VMRuntime.setDedupeHiddenApiWarnings(false);
            } else {
                VMRuntime.setNonSdkApiUsageConsumer(null);
                VMRuntime.setDedupeHiddenApiWarnings(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VmPolicy getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x100) != 0;
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x200) != 0;
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x1000) != 0;
    }

    public static boolean vmFileUriExposureEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x2000) != 0;
    }

    public static boolean vmCleartextNetworkEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x4000) != 0;
    }

    public static boolean vmContentUriWithoutPermissionEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x8000) != 0;
    }

    public static boolean vmUntaggedSocketEnabled() {
        return (StrictMode.sVmPolicy.mask & Integer.MIN_VALUE) != 0;
    }

    public static void onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(new SqliteObjectLeakedViolation(message, originStack));
    }

    public static void onWebViewMethodCalledOnWrongThread(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new WebViewMethodCalledOnWrongThreadViolation(originStack));
    }

    public static void onIntentReceiverLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new IntentReceiverLeakedViolation(originStack));
    }

    public static void onServiceConnectionLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new ServiceConnectionLeakedViolation(originStack));
    }

    public static void onFileUriExposed(Uri uri, String location) {
        String message = uri + " exposed beyond app through " + location;
        if ((StrictMode.sVmPolicy.mask & 0x4000000) != 0) {
            throw new FileUriExposedException(message);
        }
        StrictMode.onVmPolicyViolation(new FileUriExposedViolation(message));
    }

    public static void onContentUriWithoutPermission(Uri uri, String location) {
        StrictMode.onVmPolicyViolation(new ContentUriWithoutPermissionViolation(uri, location));
    }

    public static void onCleartextNetworkDetected(byte[] firstPacket) {
        byte[] rawAddr = null;
        if (firstPacket != null) {
            if (firstPacket.length >= 20 && (firstPacket[0] & 0xF0) == 64) {
                rawAddr = new byte[4];
                System.arraycopy(firstPacket, 16, rawAddr, 0, 4);
            } else if (firstPacket.length >= 40 && (firstPacket[0] & 0xF0) == 96) {
                rawAddr = new byte[16];
                System.arraycopy(firstPacket, 24, rawAddr, 0, 16);
            }
        }
        int uid = Process.myUid();
        String msg = CLEARTEXT_DETECTED_MSG + uid;
        if (rawAddr != null) {
            try {
                msg = msg + " to " + InetAddress.getByAddress(rawAddr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        msg = msg + HexDump.dumpHexString(firstPacket).trim() + " ";
        boolean forceDeath = (StrictMode.sVmPolicy.mask & 0x2000000) != 0;
        StrictMode.onVmPolicyViolation(new CleartextNetworkViolation(msg), forceDeath);
    }

    public static void onUntaggedSocket() {
        StrictMode.onVmPolicyViolation(new UntaggedSocketViolation());
    }

    public static void onVmPolicyViolation(Violation originStack) {
        StrictMode.onVmPolicyViolation(originStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVmPolicyViolation(Violation violation, boolean forceDeath) {
        boolean penaltyDropbox = (StrictMode.sVmPolicy.mask & 0x200000) != 0;
        boolean penaltyDeath = (StrictMode.sVmPolicy.mask & 0x40000) != 0 || forceDeath;
        boolean penaltyLog = (StrictMode.sVmPolicy.mask & 0x10000) != 0;
        ViolationInfo info = new ViolationInfo(violation, StrictMode.sVmPolicy.mask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        synchronized (hashMap) {
            if (sLastVmViolationTime.containsKey(fingerprint)) {
                long lastViolationTime = sLastVmViolationTime.get(fingerprint);
                timeSinceLastViolationMillis = now - lastViolationTime;
            }
            if (timeSinceLastViolationMillis > 1000L) {
                sLastVmViolationTime.put(fingerprint, now);
            }
        }
        if (timeSinceLastViolationMillis <= 1000L) {
            return;
        }
        if (penaltyLog && sLogger != null && timeSinceLastViolationMillis > 1000L) {
            sLogger.log(info);
        }
        int violationMaskSubset = 0x200000 | 0xC000FF00 & StrictMode.sVmPolicy.mask;
        if (penaltyDropbox) {
            if (penaltyDeath) {
                StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
            } else {
                StrictMode.dropboxViolationAsync(violationMaskSubset, info);
            }
        }
        if (penaltyDeath) {
            System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
        if (StrictMode.sVmPolicy.mListener != null && StrictMode.sVmPolicy.mCallbackExecutor != null) {
            OnVmViolationListener listener = StrictMode.sVmPolicy.mListener;
            try {
                StrictMode.sVmPolicy.mCallbackExecutor.execute(() -> {
                    VmPolicy oldPolicy = StrictMode.allowVmViolations();
                    try {
                        listener.onVmViolation(violation);
                    }
                    finally {
                        StrictMode.setVmPolicy(oldPolicy);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Log.e(TAG, "VmPolicy penaltyCallback failed", e);
            }
        }
    }

    static void writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            int size = Math.min(violations.size(), 3);
            p.writeInt(size);
            for (int i = 0; i < size; ++i) {
                violations.get(i).writeToParcel(p, 0);
            }
        }
        gatheredViolations.set(null);
    }

    static void readAndHandleBinderCallViolations(Parcel p) {
        Throwable localCallSite = new Throwable();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & 0x400000) != 0;
        int size = p.readInt();
        for (int i = 0; i < size; ++i) {
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            info.addLocalStack(localCallSite);
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    private static void onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Span enterCriticalSpan(String name) {
        if (_Original_Build.IS_USER) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d(TAG, "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    public static void noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    public static void noteResourceMismatch(Object tag) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onResourceMismatch(tag);
    }

    public static void noteUnbufferedIO() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onUnbufferedIO();
    }

    public static void noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onReadFromDisk();
    }

    public static void noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onWriteToDisk();
    }

    public static Object trackActivity(Object instance) {
        return new InstanceTracker(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            int newExpected;
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            int n = newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            int limit = newExpected + 1;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int actual = InstanceTracker.getInstanceCount(klass);
            if (actual <= limit) {
                return;
            }
            System.gc();
            System.runFinalization();
            System.gc();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances > (long)limit) {
                StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
            }
            return;
        }
    }

    static {
        sLogger = LOGCAT_LOGGER = info -> {
            String msg = info.durationMillis != -1 ? "StrictMode policy violation; ~duration=" + info.durationMillis + " ms:" : "StrictMode policy violation:";
            Log.d(TAG, msg + " " + info.getStackTrace());
        };
        sThreadViolationListener = new ThreadLocal();
        sThreadViolationExecutor = new ThreadLocal();
        sDropboxCallsInFlight = new AtomicInteger(0);
        sNonSdkApiUsageConsumer = message -> StrictMode.onVmPolicyViolation(new NonSdkApiUsedViolation((String)message));
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return null;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return new ArrayList<ViolationInfo>();
            }
        };
        THREAD_HANDLER = new ThreadLocal<Handler>(){

            @Override
            protected Handler initialValue() {
                return new Handler();
            }
        };
        THREAD_ANDROID_POLICY = new ThreadLocal<AndroidBlockGuardPolicy>(){

            @Override
            protected AndroidBlockGuardPolicy initialValue() {
                return new AndroidBlockGuardPolicy(0);
            }
        };
        sLastInstanceCountCheckMillis = 0L;
        sIsIdlerRegistered = false;
        sProcessIdleHandler = new MessageQueue.IdleHandler(){

            @Override
            public boolean queueIdle() {
                long now = SystemClock.uptimeMillis();
                if (now - sLastInstanceCountCheckMillis > 30000L) {
                    sLastInstanceCountCheckMillis = now;
                    StrictMode.conditionallyCheckInstanceCounts();
                }
                return true;
            }
        };
        sLastVmViolationTime = new HashMap();
        NO_OP_SPAN = new Span(){

            @Override
            public void finish() {
            }
        };
        sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){

            @Override
            protected ThreadSpanState initialValue() {
                return new ThreadSpanState();
            }
        };
        sWindowManager = new Singleton<IWindowManager>(){

            @Override
            protected IWindowManager create() {
                return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }
        };
        sExpectedActivityInstanceCount = new HashMap();
    }

    private static class InstanceTracker {
        private static final HashMap<Class<?>, Integer> sInstanceCounts = new HashMap();
        private final Class<?> mKlass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceTracker(Object instance) {
            this.mKlass = instance.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(this.mKlass);
                int newValue = value != null ? value + 1 : 1;
                sInstanceCounts.put(this.mKlass, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                synchronized (hashMap) {
                    Integer value = sInstanceCounts.get(this.mKlass);
                    if (value != null) {
                        int newValue = value - 1;
                        if (newValue > 0) {
                            sInstanceCounts.put(this.mKlass, newValue);
                        } else {
                            sInstanceCounts.remove(this.mKlass);
                        }
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getInstanceCount(Class<?> klass) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(klass);
                return value != null ? value : 0;
            }
        }
    }

    public static class ViolationInfo
    implements Parcelable {
        private final Violation mViolation;
        private final Deque<StackTraceElement[]> mBinderStack = new ArrayDeque<StackTraceElement[]>();
        private String mStackTrace;
        private final int mPolicy;
        public int durationMillis = -1;
        public int numAnimationsRunning = 0;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances = -1L;
        public static final Parcelable.Creator<ViolationInfo> CREATOR = new Parcelable.Creator<ViolationInfo>(){

            @Override
            public ViolationInfo createFromParcel(Parcel in) {
                return new ViolationInfo(in);
            }

            public ViolationInfo[] newArray(int size) {
                return new ViolationInfo[size];
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViolationInfo(Violation tr, int policy) {
            this.mViolation = tr;
            this.mPolicy = policy;
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = (ThreadSpanState)sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).getNumberOfInstances();
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        public String getStackTrace() {
            if (this.mStackTrace == null) {
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
                this.mViolation.printStackTrace(pw);
                for (StackTraceElement[] traces : this.mBinderStack) {
                    pw.append("# via Binder call with stack:\n");
                    for (StackTraceElement traceElement : traces) {
                        pw.append("\tat ");
                        pw.append(traceElement.toString());
                        pw.append('\n');
                    }
                }
                ((PrintWriter)pw).flush();
                ((PrintWriter)pw).close();
                this.mStackTrace = sw.toString();
            }
            return this.mStackTrace;
        }

        public String getViolationDetails() {
            return this.mViolation.getMessage();
        }

        public int getPolicyMask() {
            return this.mPolicy;
        }

        boolean penaltyEnabled(int p) {
            return (this.mPolicy & p) != 0;
        }

        void addLocalStack(Throwable t) {
            this.mBinderStack.addFirst(t.getStackTrace());
        }

        public int getViolationBit() {
            if (this.mViolation instanceof DiskWriteViolation) {
                return 1;
            }
            if (this.mViolation instanceof DiskReadViolation) {
                return 2;
            }
            if (this.mViolation instanceof NetworkViolation) {
                return 4;
            }
            if (this.mViolation instanceof CustomViolation) {
                return 8;
            }
            if (this.mViolation instanceof ResourceMismatchViolation) {
                return 16;
            }
            if (this.mViolation instanceof UnbufferedIoViolation) {
                return 32;
            }
            if (this.mViolation instanceof SqliteObjectLeakedViolation) {
                return 256;
            }
            if (this.mViolation instanceof LeakedClosableViolation) {
                return 512;
            }
            if (this.mViolation instanceof InstanceCountViolation) {
                return 2048;
            }
            if (this.mViolation instanceof IntentReceiverLeakedViolation) {
                return 4096;
            }
            if (this.mViolation instanceof ServiceConnectionLeakedViolation) {
                return 4096;
            }
            if (this.mViolation instanceof FileUriExposedViolation) {
                return 8192;
            }
            if (this.mViolation instanceof CleartextNetworkViolation) {
                return 16384;
            }
            if (this.mViolation instanceof ContentUriWithoutPermissionViolation) {
                return 32768;
            }
            if (this.mViolation instanceof UntaggedSocketViolation) {
                return Integer.MIN_VALUE;
            }
            if (this.mViolation instanceof NonSdkApiUsedViolation) {
                return 0x40000000;
            }
            throw new IllegalStateException("missing violation bit");
        }

        public int hashCode() {
            int result = 17;
            if (this.mViolation != null) {
                result = 37 * result + this.mViolation.hashCode();
            }
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        public ViolationInfo(Parcel in) {
            this(in, false);
        }

        public ViolationInfo(Parcel in, boolean unsetGatheringBit) {
            this.mViolation = (Violation)in.readSerializable();
            int binderStackSize = in.readInt();
            for (int i = 0; i < binderStackSize; ++i) {
                StackTraceElement[] traceElements = new StackTraceElement[in.readInt()];
                for (int j = 0; j < traceElements.length; ++j) {
                    StackTraceElement element;
                    traceElements[j] = element = new StackTraceElement(in.readString(), in.readString(), in.readString(), in.readInt());
                }
                this.mBinderStack.add(traceElements);
            }
            int rawPolicy = in.readInt();
            this.mPolicy = unsetGatheringBit ? rawPolicy & 0xFFBFFFFF : rawPolicy;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeSerializable(this.mViolation);
            dest.writeInt(this.mBinderStack.size());
            for (StackTraceElement[] traceElements : this.mBinderStack) {
                dest.writeInt(traceElements.length);
                for (StackTraceElement element : traceElements) {
                    dest.writeString(element.getClassName());
                    dest.writeString(element.getMethodName());
                    dest.writeString(element.getFileName());
                    dest.writeInt(element.getLineNumber());
                }
            }
            int start = dest.dataPosition();
            dest.writeInt(this.mPolicy);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
            int total = dest.dataPosition() - start;
        }

        public void dump(Printer pw, String prefix) {
            pw.println(prefix + "stackTrace: " + this.getStackTrace());
            pw.println(prefix + "policy: " + this.mPolicy);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    private static class ThreadSpanState {
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private ThreadSpanState() {
        }
    }

    public static class Span {
        private String mName;
        private long mCreateMillis;
        private Span mNext;
        private Span mPrev;
        private final ThreadSpanState mContainerState;

        Span(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        protected Span() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter {
        private AndroidCloseGuardReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(new LeakedClosableViolation(message, allocationSite));
        }
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        private int mPolicyMask;
        private ArrayMap<Integer, Long> mLastViolationTime;

        public AndroidBlockGuardPolicy(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        public String toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }

        @Override
        public int getPolicyMask() {
            return this.mPolicyMask;
        }

        @Override
        public void onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskWriteViolation());
        }

        void onCustomSlowCall(String name) {
            if ((this.mPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new CustomViolation(name));
        }

        void onResourceMismatch(Object tag) {
            if ((this.mPolicyMask & 0x10) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new ResourceMismatchViolation(tag));
        }

        @Override
        public void onUnbufferedIO() {
            if ((this.mPolicyMask & 0x20) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new UnbufferedIoViolation());
        }

        @Override
        public void onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskReadViolation());
        }

        @Override
        public void onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mPolicyMask & 0x1000000) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new NetworkViolation());
        }

        public void setPolicyMask(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        void startHandlingViolationException(Violation e) {
            ViolationInfo info = new ViolationInfo(e, this.mPolicyMask);
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        void handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || (info.mPolicy & 0x1770000) == 262144) {
                info.durationMillis = -1;
                this.onThreadPolicyViolation(info);
                return;
            }
            ArrayList records = (ArrayList)violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = info.penaltyEnabled(0x100000) ? (IWindowManager)sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ((Handler)THREAD_HANDLER.get()).postAtFrontOfQueue(() -> {
                long loopFinishTime = SystemClock.uptimeMillis();
                if (windowManager != null) {
                    try {
                        windowManager.showStrictModeViolation(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                for (int n = 0; n < records.size(); ++n) {
                    ViolationInfo v = (ViolationInfo)records.get(n);
                    v.violationNumThisLoop = n + 1;
                    v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                    this.onThreadPolicyViolation(v);
                }
                records.clear();
            });
        }

        void onThreadPolicyViolation(ViolationInfo info) {
            long timeSinceLastViolationMillis;
            if (LOG_V) {
                Log.d(StrictMode.TAG, "onThreadPolicyViolation; policy=" + info.mPolicy);
            }
            if (info.penaltyEnabled(0x400000)) {
                ArrayList<ViolationInfo> violations = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (violations == null) {
                    violations = new ArrayList<ViolationInfo>(1);
                    gatheredViolations.set(violations);
                }
                for (ViolationInfo previous : violations) {
                    if (!info.getStackTrace().equals(previous.getStackTrace())) continue;
                    return;
                }
                violations.add(info);
                return;
            }
            Integer crashFingerprint = info.hashCode();
            long lastViolationTime = 0L;
            if (this.mLastViolationTime != null) {
                Long vtime = this.mLastViolationTime.get(crashFingerprint);
                if (vtime != null) {
                    lastViolationTime = vtime;
                }
            } else {
                this.mLastViolationTime = new ArrayMap(1);
            }
            long now = SystemClock.uptimeMillis();
            this.mLastViolationTime.put(crashFingerprint, now);
            long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
            if (info.penaltyEnabled(65536) && timeSinceLastViolationMillis > 1000L) {
                sLogger.log(info);
            }
            Violation violation = info.mViolation;
            int violationMaskSubset = 0;
            if (info.penaltyEnabled(131072) && timeSinceLastViolationMillis > 30000L) {
                violationMaskSubset |= 0x20000;
            }
            if (info.penaltyEnabled(0x200000) && lastViolationTime == 0L) {
                violationMaskSubset |= 0x200000;
            }
            if (violationMaskSubset != 0) {
                boolean justDropBox;
                violationMaskSubset |= info.getViolationBit();
                boolean bl = justDropBox = (info.mPolicy & 0x1770000) == 0x200000;
                if (justDropBox) {
                    StrictMode.dropboxViolationAsync(violationMaskSubset, info);
                } else {
                    StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
                }
            }
            if ((info.getPolicyMask() & 0x40000) != 0) {
                throw new RuntimeException("StrictMode ThreadPolicy violation", violation);
            }
            OnThreadViolationListener listener = (OnThreadViolationListener)sThreadViolationListener.get();
            Executor executor = (Executor)sThreadViolationExecutor.get();
            if (listener != null && executor != null) {
                try {
                    executor.execute(() -> {
                        ThreadPolicy oldPolicy = StrictMode.allowThreadViolations();
                        try {
                            listener.onThreadViolation(violation);
                        }
                        finally {
                            StrictMode.setThreadPolicy(oldPolicy);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    Log.e(StrictMode.TAG, "ThreadPolicy penaltyCallback failed", e);
                }
            }
        }
    }

    public static class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0, StrictMode.access$100(), null, null);
        final int mask;
        final OnVmViolationListener mListener;
        final Executor mCallbackExecutor;
        final HashMap<Class, Integer> classInstanceLimit;

        private VmPolicy(int mask, HashMap<Class, Integer> classInstanceLimit, OnVmViolationListener listener, Executor executor) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        public String toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            private int mMask;
            private OnVmViolationListener mListener;
            private Executor mExecutor;
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow = false;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(VmPolicy base) {
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
                this.mListener = base.mListener;
                this.mExecutor = base.mCallbackExecutor;
            }

            public Builder setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 0x800;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            public Builder detectActivityLeaks() {
                return this.enable(1024);
            }

            public Builder permitActivityLeaks() {
                return this.disable(1024);
            }

            public Builder detectNonSdkApiUsage() {
                return this.enable(0x40000000);
            }

            public Builder permitNonSdkApiUsage() {
                return this.disable(0x40000000);
            }

            public Builder detectAll() {
                this.detectLeakedSqlLiteObjects();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectActivityLeaks();
                    this.detectLeakedClosableObjects();
                }
                if (targetSdk >= 16) {
                    this.detectLeakedRegistrationObjects();
                }
                if (targetSdk >= 18) {
                    this.detectFileUriExposure();
                }
                if (targetSdk >= 23 && SystemProperties.getBoolean(StrictMode.CLEARTEXT_PROPERTY, false)) {
                    this.detectCleartextNetwork();
                }
                if (targetSdk >= 26) {
                    this.detectContentUriWithoutPermission();
                    this.detectUntaggedSockets();
                }
                return this;
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(256);
            }

            public Builder detectLeakedClosableObjects() {
                return this.enable(512);
            }

            public Builder detectLeakedRegistrationObjects() {
                return this.enable(4096);
            }

            public Builder detectFileUriExposure() {
                return this.enable(8192);
            }

            public Builder detectCleartextNetwork() {
                return this.enable(16384);
            }

            public Builder detectContentUriWithoutPermission() {
                return this.enable(32768);
            }

            public Builder detectUntaggedSockets() {
                return this.enable(Integer.MIN_VALUE);
            }

            public Builder permitUntaggedSockets() {
                return this.disable(Integer.MIN_VALUE);
            }

            public Builder penaltyDeath() {
                return this.enable(262144);
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                return this.enable(0x2000000);
            }

            public Builder penaltyDeathOnFileUriExposure() {
                return this.enable(0x4000000);
            }

            public Builder penaltyLog() {
                return this.enable(65536);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x200000);
            }

            public Builder penaltyListener(Executor executor, OnVmViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            public Builder penaltyListener(OnVmViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            Builder disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            public VmPolicy build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP, this.mListener, this.mExecutor);
            }
        }
    }

    public static class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0, null, null);
        final int mask;
        final OnThreadViolationListener mListener;
        final Executor mCallbackExecutor;

        private ThreadPolicy(int mask, OnThreadViolationListener listener, Executor executor) {
            this.mask = mask;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        public String toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            private int mMask = 0;
            private OnThreadViolationListener mListener;
            private Executor mExecutor;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy policy) {
                this.mMask = policy.mask;
                this.mListener = policy.mListener;
                this.mExecutor = policy.mCallbackExecutor;
            }

            public Builder detectAll() {
                this.detectDiskReads();
                this.detectDiskWrites();
                this.detectNetwork();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectCustomSlowCalls();
                }
                if (targetSdk >= 23) {
                    this.detectResourceMismatches();
                }
                if (targetSdk >= 26) {
                    this.detectUnbufferedIo();
                }
                return this;
            }

            public Builder permitAll() {
                return this.disable(63);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder detectCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder permitCustomSlowCalls() {
                return this.disable(8);
            }

            public Builder permitResourceMismatches() {
                return this.disable(16);
            }

            public Builder detectUnbufferedIo() {
                return this.enable(32);
            }

            public Builder permitUnbufferedIo() {
                return this.disable(32);
            }

            public Builder detectResourceMismatches() {
                return this.enable(16);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder penaltyDialog() {
                return this.enable(131072);
            }

            public Builder penaltyDeath() {
                return this.enable(262144);
            }

            public Builder penaltyDeathOnNetwork() {
                return this.enable(0x1000000);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(0x100000);
            }

            public Builder penaltyLog() {
                return this.enable(65536);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x200000);
            }

            public Builder penaltyListener(Executor executor, OnThreadViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            public Builder penaltyListener(OnThreadViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private Builder disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask, this.mListener, this.mExecutor);
            }
        }
    }

    public static interface OnVmViolationListener {
        public void onVmViolation(Violation var1);
    }

    public static interface OnThreadViolationListener {
        public void onThreadViolation(Violation var1);
    }

    public static interface ViolationLogger {
        public void log(ViolationInfo var1);
    }
}

