/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.AndroidBidi;
import android.text.AutoGrowArray;
import android.text.Layout;
import android.text.MeasuredParagraph_Delegate;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import android.util.Pools;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.util.Arrays;
import libcore.util.NativeAllocationRegistry;

public class MeasuredParagraph {
    private static final char OBJECT_REPLACEMENT_CHARACTER = '\ufffc';
    private static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(MeasuredParagraph.class.getClassLoader(), MeasuredParagraph.nGetReleaseFunc(), 1024L);
    private static final Pools.SynchronizedPool<MeasuredParagraph> sPool = new Pools.SynchronizedPool(1);
    private Spanned mSpanned;
    private int mTextStart;
    private int mTextLength;
    private char[] mCopiedBuffer;
    private int mParaDir;
    private boolean mLtrWithoutBidi;
    private AutoGrowArray.ByteArray mLevels = new AutoGrowArray.ByteArray();
    private float mWholeWidth;
    private AutoGrowArray.FloatArray mWidths = new AutoGrowArray.FloatArray();
    private AutoGrowArray.IntArray mSpanEndCache = new AutoGrowArray.IntArray(4);
    private AutoGrowArray.IntArray mFontMetrics = new AutoGrowArray.IntArray(16);
    private long mNativePtr = 0L;
    private Runnable mNativeObjectCleaner;
    private TextPaint mCachedPaint = new TextPaint();
    private Paint.FontMetricsInt mCachedFm;

    private MeasuredParagraph() {
    }

    private static MeasuredParagraph obtain() {
        MeasuredParagraph mt = sPool.acquire();
        return mt != null ? mt : new MeasuredParagraph();
    }

    public void recycle() {
        this.release();
        sPool.release(this);
    }

    private void bindNativeObject(long nativePtr) {
        this.mNativePtr = nativePtr;
        this.mNativeObjectCleaner = sRegistry.registerNativeAllocation((Object)this, nativePtr);
    }

    private void unbindNativeObject() {
        if (this.mNativePtr != 0L) {
            this.mNativeObjectCleaner.run();
            this.mNativePtr = 0L;
        }
    }

    public void release() {
        this.reset();
        this.mLevels.clearWithReleasingLargeArray();
        this.mWidths.clearWithReleasingLargeArray();
        this.mFontMetrics.clearWithReleasingLargeArray();
        this.mSpanEndCache.clearWithReleasingLargeArray();
    }

    private void reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mWholeWidth = 0.0f;
        this.mLevels.clear();
        this.mWidths.clear();
        this.mFontMetrics.clear();
        this.mSpanEndCache.clear();
        this.unbindNativeObject();
    }

    public int getTextLength() {
        return this.mTextLength;
    }

    public char[] getChars() {
        return this.mCopiedBuffer;
    }

    public int getParagraphDir() {
        return this.mParaDir;
    }

    public Layout.Directions getDirections(int start, int end) {
        if (this.mLtrWithoutBidi) {
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int length = end - start;
        return AndroidBidi.directions(this.mParaDir, this.mLevels.getRawArray(), start, this.mCopiedBuffer, start, length);
    }

    public float getWholeWidth() {
        return this.mWholeWidth;
    }

    public AutoGrowArray.FloatArray getWidths() {
        return this.mWidths;
    }

    public AutoGrowArray.IntArray getSpanEndCache() {
        return this.mSpanEndCache;
    }

    public AutoGrowArray.IntArray getFontMetrics() {
        return this.mFontMetrics;
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public float getWidth(int start, int end) {
        if (this.mNativePtr == 0L) {
            float[] widths = this.mWidths.getRawArray();
            float r = 0.0f;
            for (int i = start; i < end; ++i) {
                r += widths[i];
            }
            return r;
        }
        return MeasuredParagraph.nGetWidth(this.mNativePtr, start, end);
    }

    public void getBounds(int start, int end, Rect bounds) {
        MeasuredParagraph.nGetBounds(this.mNativePtr, this.mCopiedBuffer, start, end, bounds);
    }

    public static MeasuredParagraph buildForBidi(CharSequence text, int start, int end, TextDirectionHeuristic textDir, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        return mt;
    }

    public static MeasuredParagraph buildForMeasurement(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        mt.mWidths.resize(mt.mTextLength);
        if (mt.mTextLength == 0) {
            return mt;
        }
        if (mt.mSpanned == null) {
            mt.applyMetricsAffectingSpan(paint, null, start, end, 0L);
        } else {
            int spanStart = start;
            while (spanStart < end) {
                int spanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                mt.applyMetricsAffectingSpan(paint, spans, spanStart, spanEnd, 0L);
                spanStart = spanEnd;
            }
        }
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeasuredParagraph buildForStaticLayout(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir, boolean computeHyphenation, boolean computeLayout, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        if (mt.mTextLength == 0) {
            long nativeBuilderPtr = MeasuredParagraph.nInitBuilder();
            try {
                mt.bindNativeObject(MeasuredParagraph.nBuildNativeMeasuredParagraph(nativeBuilderPtr, mt.mCopiedBuffer, computeHyphenation, computeLayout));
            }
            finally {
                MeasuredParagraph.nFreeBuilder(nativeBuilderPtr);
            }
            return mt;
        }
        long nativeBuilderPtr = MeasuredParagraph.nInitBuilder();
        try {
            if (mt.mSpanned == null) {
                mt.applyMetricsAffectingSpan(paint, null, start, end, nativeBuilderPtr);
                mt.mSpanEndCache.append(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int spanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                    mt.applyMetricsAffectingSpan(paint, spans, spanStart, spanEnd, nativeBuilderPtr);
                    mt.mSpanEndCache.append(spanEnd);
                    spanStart = spanEnd;
                }
            }
            mt.bindNativeObject(MeasuredParagraph.nBuildNativeMeasuredParagraph(nativeBuilderPtr, mt.mCopiedBuffer, computeHyphenation, computeLayout));
        }
        finally {
            MeasuredParagraph.nFreeBuilder(nativeBuilderPtr);
        }
        return mt;
    }

    private void resetAndAnalyzeBidi(CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        this.mTextLength = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != this.mTextLength) {
            this.mCopiedBuffer = new char[this.mTextLength];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            ReplacementSpan[] spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int startInPara = this.mSpanned.getSpanStart(spans[i]) - start;
                int endInPara = this.mSpanned.getSpanEnd(spans[i]) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > this.mTextLength) {
                    endInPara = this.mTextLength;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if ((textDir == TextDirectionHeuristics.LTR || textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDir == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mCopiedBuffer, 0, this.mTextLength)) {
            this.mLevels.clear();
            this.mParaDir = 1;
            this.mLtrWithoutBidi = true;
        } else {
            boolean isRtl;
            int bidiRequest = textDir == TextDirectionHeuristics.LTR ? 1 : (textDir == TextDirectionHeuristics.RTL ? -1 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 2 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? -2 : ((isRtl = textDir.isRtl(this.mCopiedBuffer, 0, this.mTextLength)) ? -1 : 1))));
            this.mLevels.resize(this.mTextLength);
            this.mParaDir = AndroidBidi.bidi(bidiRequest, this.mCopiedBuffer, this.mLevels.getRawArray());
            this.mLtrWithoutBidi = false;
        }
    }

    private void applyReplacementRun(ReplacementSpan replacement, int start, int end, long nativeBuilderPtr) {
        float width = replacement.getSize(this.mCachedPaint, this.mSpanned, start + this.mTextStart, end + this.mTextStart, this.mCachedFm);
        if (nativeBuilderPtr == 0L) {
            this.mWidths.set(start, width);
            if (end > start + 1) {
                Arrays.fill(this.mWidths.getRawArray(), start + 1, end, 0.0f);
            }
            this.mWholeWidth += width;
        } else {
            MeasuredParagraph.nAddReplacementRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), start, end, width);
        }
    }

    private void applyStyleRun(int start, int end, long nativeBuilderPtr) {
        if (this.mLtrWithoutBidi) {
            if (nativeBuilderPtr == 0L) {
                this.mWholeWidth += this.mCachedPaint.getTextRunAdvances(this.mCopiedBuffer, start, end - start, start, end - start, false, this.mWidths.getRawArray(), start);
            } else {
                MeasuredParagraph.nAddStyleRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), start, end, false);
            }
        } else {
            byte level = this.mLevels.get(start);
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mLevels.get(levelEnd) != level) {
                    boolean isRtl;
                    boolean bl = isRtl = (level & 1) != 0;
                    if (nativeBuilderPtr == 0L) {
                        int levelLength = levelEnd - levelStart;
                        this.mWholeWidth += this.mCachedPaint.getTextRunAdvances(this.mCopiedBuffer, levelStart, levelLength, levelStart, levelLength, isRtl, this.mWidths.getRawArray(), levelStart);
                    } else {
                        MeasuredParagraph.nAddStyleRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), levelStart, levelEnd, isRtl);
                    }
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mLevels.get(levelEnd);
                }
                ++levelEnd;
            }
        }
    }

    private void applyMetricsAffectingSpan(TextPaint paint, MetricAffectingSpan[] spans, int start, int end, long nativeBuilderPtr) {
        boolean needFontMetrics;
        this.mCachedPaint.set(paint);
        this.mCachedPaint.baselineShift = 0;
        boolean bl = needFontMetrics = nativeBuilderPtr != 0L;
        if (needFontMetrics && this.mCachedFm == null) {
            this.mCachedFm = new Paint.FontMetricsInt();
        }
        ReplacementSpan replacement = null;
        if (spans != null) {
            for (int i = 0; i < spans.length; ++i) {
                MetricAffectingSpan span = spans[i];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateMeasureState(this.mCachedPaint);
            }
        }
        int startInCopiedBuffer = start - this.mTextStart;
        int endInCopiedBuffer = end - this.mTextStart;
        if (nativeBuilderPtr != 0L) {
            this.mCachedPaint.getFontMetricsInt(this.mCachedFm);
        }
        if (replacement != null) {
            this.applyReplacementRun(replacement, startInCopiedBuffer, endInCopiedBuffer, nativeBuilderPtr);
        } else {
            this.applyStyleRun(startInCopiedBuffer, endInCopiedBuffer, nativeBuilderPtr);
        }
        if (needFontMetrics) {
            if (this.mCachedPaint.baselineShift < 0) {
                this.mCachedFm.ascent += this.mCachedPaint.baselineShift;
                this.mCachedFm.top += this.mCachedPaint.baselineShift;
            } else {
                this.mCachedFm.descent += this.mCachedPaint.baselineShift;
                this.mCachedFm.bottom += this.mCachedPaint.baselineShift;
            }
            this.mFontMetrics.append(this.mCachedFm.top);
            this.mFontMetrics.append(this.mCachedFm.bottom);
            this.mFontMetrics.append(this.mCachedFm.ascent);
            this.mFontMetrics.append(this.mCachedFm.descent);
        }
    }

    int breakText(int limit, boolean forwards, float width) {
        int i;
        float[] w = this.mWidths.getRawArray();
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= w[i2]) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mCopiedBuffer[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= w[i]) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mCopiedBuffer[i + 1] == ' ' || w[i + 1] == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    float measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths.getRawArray();
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }

    public int getMemoryUsage() {
        return MeasuredParagraph.nGetMemoryUsage(this.mNativePtr);
    }

    @LayoutlibDelegate
    private static long nInitBuilder() {
        return MeasuredParagraph_Delegate.nInitBuilder();
    }

    @LayoutlibDelegate
    private static void nAddStyleRun(long l, long l2, int n, int n2, boolean bl) {
        MeasuredParagraph_Delegate.nAddStyleRun(l, l2, n, n2, bl);
    }

    @LayoutlibDelegate
    private static void nAddReplacementRun(long l, long l2, int n, int n2, float f) {
        MeasuredParagraph_Delegate.nAddReplacementRun(l, l2, n, n2, f);
    }

    @LayoutlibDelegate
    private static long nBuildNativeMeasuredParagraph(long l, char[] cArray, boolean bl, boolean bl2) {
        return MeasuredParagraph_Delegate.nBuildNativeMeasuredParagraph(l, cArray, bl, bl2);
    }

    @LayoutlibDelegate
    private static void nFreeBuilder(long l) {
        MeasuredParagraph_Delegate.nFreeBuilder(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetWidth(long l, int n, int n2) {
        return MeasuredParagraph_Delegate.nGetWidth(l, n, n2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nGetReleaseFunc() {
        return MeasuredParagraph_Delegate.nGetReleaseFunc();
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetMemoryUsage(long l) {
        return MeasuredParagraph_Delegate.nGetMemoryUsage(l);
    }

    @LayoutlibDelegate
    private static void nGetBounds(long l, char[] cArray, int n, int n2, Rect rect) {
        MeasuredParagraph_Delegate.nGetBounds(l, cArray, n, n2, rect);
    }
}

