/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.icu.text.BreakIterator;
import android.text.GreedyLineBreaker;
import android.text.LineBreaker;
import android.text.LineWidth;
import android.text.MeasuredParagraph_Delegate;
import android.text.OptimizingLineBreaker;
import android.text.Primitive;
import android.text.StaticLayout;
import android.text.TabStops;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;

public class StaticLayout_Delegate {
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_ZWSP = '\u200b';
    private static final DelegateManager<Builder> sBuilderManager = new DelegateManager<Builder>(Builder.class);

    @LayoutlibDelegate
    static long nInit(int breakStrategy, int hyphenationFrequency, boolean isJustified, int[] indents, int[] leftPaddings, int[] rightPaddings) {
        Builder builder = new Builder();
        builder.mBreakStrategy = breakStrategy;
        return sBuilderManager.addNewDelegate(builder);
    }

    @LayoutlibDelegate
    static void nFinish(long nativePtr) {
        sBuilderManager.removeJavaReferenceFor(nativePtr);
    }

    @LayoutlibDelegate
    static int nComputeLineBreaks(long nativePtr, char[] text, long measuredTextPtr, int length, float firstWidth, int firstWidthLineCount, float restWidth, int[] variableTabStops, int defaultTabStop, int indentsOffset, StaticLayout.LineBreaks recycle, int recycleLength, int[] recycleBreaks, float[] recycleWidths, float[] recycleAscents, float[] recycleDescents, int[] recycleFlags, float[] charWidths) {
        int loc;
        Builder builder = sBuilderManager.getDelegate(nativePtr);
        if (builder == null) {
            return 0;
        }
        builder.mText = text;
        builder.mWidths = new float[length];
        builder.mLineWidth = new LineWidth(firstWidth, firstWidthLineCount, restWidth);
        builder.mTabStopCalculator = new TabStops(variableTabStops, defaultTabStop);
        MeasuredParagraph_Delegate.computeRuns(measuredTextPtr, builder);
        BreakIterator it = BreakIterator.getLineInstance();
        it.setText(new Segment(builder.mText, 0, length));
        ArrayList<Integer> breaks = new ArrayList<Integer>((int)Math.ceil((double)length / 5.0));
        it.first();
        while ((loc = it.next()) != -1) {
            breaks.add(loc);
        }
        List<Primitive> primitives = StaticLayout_Delegate.computePrimitives(builder.mText, builder.mWidths, length, breaks);
        switch (builder.mBreakStrategy) {
            case 0: {
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            case 1: 
            case 2: {
                builder.mLineBreaker = new OptimizingLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            default: {
                assert (false) : "Unknown break strategy: " + Builder.access$000(builder);
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
            }
        }
        builder.mLineBreaker.computeBreaks(recycle);
        System.arraycopy(builder.mWidths, 0, charWidths, 0, builder.mWidths.length);
        return recycle.breaks.length;
    }

    private static List<Primitive> computePrimitives(char[] text, float[] widths, int length, List<Integer> breaks) {
        ArrayList<Primitive> primitives = new ArrayList<Primitive>((int)Math.ceil((double)length * 1.833));
        int breaksSize = breaks.size();
        int breakIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = text[i];
            if (c == ' ' || c == '\u200b') {
                primitives.add(Primitive.PrimitiveType.GLUE.getNewPrimitive(i, widths[i]));
                continue;
            }
            if (c == '\t') {
                primitives.add(Primitive.PrimitiveType.VARIABLE.getNewPrimitive(i));
                continue;
            }
            if (c == '\n') continue;
            while (breakIndex < breaksSize && breaks.get(breakIndex) < i) {
                ++breakIndex;
            }
            if (widths[i] != 0.0f) {
                Primitive p = breakIndex < breaksSize && breaks.get(breakIndex) == i ? Primitive.PrimitiveType.PENALTY.getNewPrimitive(i, 0.0f, 0.0f) : Primitive.PrimitiveType.WORD_BREAK.getNewPrimitive(i, 0.0f);
                primitives.add(p);
            }
            primitives.add(Primitive.PrimitiveType.BOX.getNewPrimitive(i, widths[i]));
        }
        primitives.add(Primitive.PrimitiveType.PENALTY.getNewPrimitive(length, 0.0f, -1.0E7f));
        return primitives;
    }

    public static abstract class Run {
        int mStart;
        int mEnd;

        Run(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        abstract void addTo(Builder var1);
    }

    public static class Builder {
        char[] mText;
        float[] mWidths;
        private LineBreaker mLineBreaker;
        private int mBreakStrategy;
        private LineWidth mLineWidth;
        private TabStops mTabStopCalculator;
    }
}

