/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.ImagePool;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Queue;

class Bucket {
    final Queue<SoftReference<BufferedImage>> mBufferedImageRef = new LinkedList<SoftReference<BufferedImage>>();

    Bucket() {
    }

    public boolean isEmpty() {
        return this.mBufferedImageRef.isEmpty();
    }

    public BufferedImage remove() {
        if (this.mBufferedImageRef.isEmpty()) {
            return null;
        }
        SoftReference<BufferedImage> reference = this.mBufferedImageRef.remove();
        return reference == null ? null : reference.get();
    }

    public void offer(BufferedImage img) {
        this.mBufferedImageRef.offer(new SoftReference<BufferedImage>(img));
    }

    public void clear() {
        this.mBufferedImageRef.clear();
    }

    static class BucketCreationMetaData {
        public final int mWidth;
        public final int mHeight;
        public final int mType;
        public final int mNumberOfCopies;
        public final ImagePool.Image.Orientation mOrientation;
        public final long mMaxCacheSize;

        BucketCreationMetaData(int width, int height, int type, int numberOfCopies, ImagePool.Image.Orientation orientation, long maxCacheSize) {
            this.mWidth = width;
            this.mHeight = height;
            this.mType = type;
            this.mNumberOfCopies = numberOfCopies;
            this.mOrientation = orientation;
            this.mMaxCacheSize = maxCacheSize;
        }
    }
}

