/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.ImagePoolStats;

class ImagePoolStatsProdImpl
implements ImagePoolStats {
    static int ESTIMATED_PIXEL_BYTES = 4;
    long mAllocateTotalBytes = 0L;
    int mTooBigForPoolCount = 0;

    ImagePoolStatsProdImpl() {
    }

    @Override
    public void recordBucketCreation(int widthBucket, int heightBucket) {
        this.mAllocateTotalBytes += (long)(widthBucket * heightBucket * ESTIMATED_PIXEL_BYTES);
    }

    @Override
    public boolean fitsMaxCacheSize(int width, int height, long maxCacheSize) {
        long newTotal = this.mAllocateTotalBytes + (long)(width * height * ESTIMATED_PIXEL_BYTES);
        return newTotal <= maxCacheSize;
    }

    @Override
    public void tooBigForCache() {
        ++this.mTooBigForPoolCount;
    }

    @Override
    public void clear() {
        this.mAllocateTotalBytes = 0L;
    }

    @Override
    public void recordBucketRequest(int w, int h) {
    }

    @Override
    public void recordAllocOutsidePool(int width, int height) {
    }

    @Override
    public void acquiredImage(Integer imageHash) {
    }

    @Override
    public void disposeImage(Integer imageHash) {
    }

    @Override
    public void start() {
    }

    @Override
    public String getStatistic() {
        return "";
    }
}

