/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.PathParser;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

public class DisplayCutout {
    private static final String TAG = "DisplayCutout";
    private static final String BOTTOM_MARKER = "@bottom";
    private static final String DP_MARKER = "@dp";
    private static final String RIGHT_MARKER = "@right";
    public static final String EMULATION_OVERLAY_CATEGORY = "com.android.internal.display_cutout_emulation";
    private static final Rect ZERO_RECT = new Rect();
    private static final Region EMPTY_REGION = new Region();
    public static final DisplayCutout NO_CUTOUT = new DisplayCutout(ZERO_RECT, EMPTY_REGION, false);
    private static final Pair<Path, DisplayCutout> NULL_PAIR = new Pair<Object, Object>(null, null);
    private static final Object CACHE_LOCK = new Object();
    @GuardedBy(value="CACHE_LOCK")
    private static String sCachedSpec;
    @GuardedBy(value="CACHE_LOCK")
    private static int sCachedDisplayWidth;
    @GuardedBy(value="CACHE_LOCK")
    private static int sCachedDisplayHeight;
    @GuardedBy(value="CACHE_LOCK")
    private static float sCachedDensity;
    @GuardedBy(value="CACHE_LOCK")
    private static Pair<Path, DisplayCutout> sCachedCutout;
    private final Rect mSafeInsets;
    private final Region mBounds;

    public DisplayCutout(Rect safeInsets, List<Rect> boundingRects) {
        this(safeInsets != null ? new Rect(safeInsets) : ZERO_RECT, DisplayCutout.boundingRectsToRegion(boundingRects), true);
    }

    private DisplayCutout(Rect safeInsets, Region bounds, boolean copyArguments) {
        Rect rect = safeInsets == null ? ZERO_RECT : (this.mSafeInsets = copyArguments ? new Rect(safeInsets) : safeInsets);
        this.mBounds = bounds == null ? Region.obtain() : (copyArguments ? Region.obtain(bounds) : bounds);
    }

    public boolean isEmpty() {
        return this.mSafeInsets.equals(ZERO_RECT);
    }

    public boolean isBoundsEmpty() {
        return this.mBounds.isEmpty();
    }

    public int getSafeInsetTop() {
        return this.mSafeInsets.top;
    }

    public int getSafeInsetBottom() {
        return this.mSafeInsets.bottom;
    }

    public int getSafeInsetLeft() {
        return this.mSafeInsets.left;
    }

    public int getSafeInsetRight() {
        return this.mSafeInsets.right;
    }

    public Rect getSafeInsets() {
        return new Rect(this.mSafeInsets);
    }

    public Region getBounds() {
        return Region.obtain(this.mBounds);
    }

    public List<Rect> getBoundingRects() {
        ArrayList<Rect> result = new ArrayList<Rect>();
        Region bounds = Region.obtain();
        bounds.set(this.mBounds);
        bounds.op(0, 0, Integer.MAX_VALUE, this.getSafeInsetTop(), Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.set(this.mBounds);
        bounds.op(0, 0, this.getSafeInsetLeft(), Integer.MAX_VALUE, Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.set(this.mBounds);
        bounds.op(this.getSafeInsetLeft() + 1, this.getSafeInsetTop() + 1, Integer.MAX_VALUE, Integer.MAX_VALUE, Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.recycle();
        return result;
    }

    public int hashCode() {
        int result = this.mSafeInsets.hashCode();
        result = result * 31 + this.mBounds.getBounds().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayCutout) {
            DisplayCutout c = (DisplayCutout)o;
            return this.mSafeInsets.equals(c.mSafeInsets) && this.mBounds.equals(c.mBounds);
        }
        return false;
    }

    public String toString() {
        return "DisplayCutout{insets=" + this.mSafeInsets + " boundingRect=" + this.mBounds.getBounds() + "}";
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mSafeInsets.writeToProto(proto, 0x10B00000001L);
        this.mBounds.getBounds().writeToProto(proto, 1146756268034L);
        proto.end(token);
    }

    public DisplayCutout inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        if (this.mBounds.isEmpty() || insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0) {
            return this;
        }
        Rect safeInsets = new Rect(this.mSafeInsets);
        Region bounds = Region.obtain(this.mBounds);
        if (insetTop > 0 || safeInsets.top > 0) {
            safeInsets.top = DisplayCutout.atLeastZero(safeInsets.top - insetTop);
        }
        if (insetBottom > 0 || safeInsets.bottom > 0) {
            safeInsets.bottom = DisplayCutout.atLeastZero(safeInsets.bottom - insetBottom);
        }
        if (insetLeft > 0 || safeInsets.left > 0) {
            safeInsets.left = DisplayCutout.atLeastZero(safeInsets.left - insetLeft);
        }
        if (insetRight > 0 || safeInsets.right > 0) {
            safeInsets.right = DisplayCutout.atLeastZero(safeInsets.right - insetRight);
        }
        bounds.translate(-insetLeft, -insetTop);
        return new DisplayCutout(safeInsets, bounds, false);
    }

    public DisplayCutout replaceSafeInsets(Rect safeInsets) {
        return new DisplayCutout(new Rect(safeInsets), this.mBounds, false);
    }

    private static int atLeastZero(int value) {
        return value < 0 ? 0 : value;
    }

    @VisibleForTesting
    public static DisplayCutout fromBoundingRect(int left, int top, int right, int bottom) {
        Region r = Region.obtain();
        r.set(left, top, right, bottom);
        return DisplayCutout.fromBounds(r);
    }

    public static DisplayCutout fromBounds(Region region) {
        return new DisplayCutout(ZERO_RECT, region, false);
    }

    public static DisplayCutout fromResourcesRectApproximation(Resources res, int displayWidth, int displayHeight) {
        return DisplayCutout.fromSpec(res.getString(17039695), displayWidth, displayHeight, (float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f);
    }

    public static Path pathFromResources(Resources res, int displayWidth, int displayHeight) {
        return (Path)DisplayCutout.pathAndDisplayCutoutFromSpec((String)res.getString((int)17039694), (int)displayWidth, (int)displayHeight, (float)((float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f)).first;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static DisplayCutout fromSpec(String spec, int displayWidth, int displayHeight, float density) {
        return (DisplayCutout)DisplayCutout.pathAndDisplayCutoutFromSpec((String)spec, (int)displayWidth, (int)displayHeight, (float)density).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Path, DisplayCutout> pathAndDisplayCutoutFromSpec(String spec, int displayWidth, int displayHeight, float density) {
        int bottomInset;
        Path p;
        float offsetX;
        if (TextUtils.isEmpty(spec)) {
            return NULL_PAIR;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (spec.equals(sCachedSpec) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight && sCachedDensity == density) {
                return sCachedCutout;
            }
        }
        spec = spec.trim();
        if (spec.endsWith(RIGHT_MARKER)) {
            offsetX = displayWidth;
            spec = spec.substring(0, spec.length() - RIGHT_MARKER.length()).trim();
        } else {
            offsetX = (float)displayWidth / 2.0f;
        }
        boolean inDp = spec.endsWith(DP_MARKER);
        if (inDp) {
            spec = spec.substring(0, spec.length() - DP_MARKER.length());
        }
        String bottomSpec = null;
        if (spec.contains(BOTTOM_MARKER)) {
            String[] splits = spec.split(BOTTOM_MARKER, 2);
            spec = splits[0].trim();
            bottomSpec = splits[1].trim();
        }
        Region r = Region.obtain();
        try {
            p = PathParser.createPathFromPathData(spec);
        }
        catch (Throwable e) {
            Log.wtf(TAG, "Could not inflate cutout: ", e);
            return NULL_PAIR;
        }
        Matrix m = new Matrix();
        if (inDp) {
            m.postScale(density, density);
        }
        m.postTranslate(offsetX, 0.0f);
        p.transform(m);
        Rect tmpRect = new Rect();
        DisplayCutout.toRectAndAddToRegion(p, r, tmpRect);
        int topInset = tmpRect.bottom;
        if (bottomSpec != null) {
            Path bottomPath;
            try {
                bottomPath = PathParser.createPathFromPathData(bottomSpec);
            }
            catch (Throwable e) {
                Log.wtf(TAG, "Could not inflate bottom cutout: ", e);
                return NULL_PAIR;
            }
            m.postTranslate(0.0f, displayHeight);
            bottomPath.transform(m);
            p.addPath(bottomPath);
            DisplayCutout.toRectAndAddToRegion(bottomPath, r, tmpRect);
            bottomInset = displayHeight - tmpRect.top;
        } else {
            bottomInset = 0;
        }
        tmpRect.set(0, topInset, 0, bottomInset);
        DisplayCutout cutout = new DisplayCutout(tmpRect, r, false);
        Pair<Path, DisplayCutout> result = new Pair<Path, DisplayCutout>(p, cutout);
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedSpec = spec;
            sCachedDisplayWidth = displayWidth;
            sCachedDisplayHeight = displayHeight;
            sCachedDensity = density;
            sCachedCutout = result;
        }
        return result;
    }

    private static void toRectAndAddToRegion(Path p, Region inoutRegion, Rect inoutRect) {
        RectF rectF = new RectF();
        p.computeBounds(rectF, false);
        rectF.round(inoutRect);
        inoutRegion.op(inoutRect, Region.Op.UNION);
    }

    private static Region boundingRectsToRegion(List<Rect> rects) {
        Region result = Region.obtain();
        if (rects != null) {
            for (Rect r : rects) {
                result.op(r, Region.Op.UNION);
            }
        }
        return result;
    }

    static {
        sCachedCutout = NULL_PAIR;
    }

    public static class ParcelableWrapper
    implements Parcelable {
        private DisplayCutout mInner;
        public static final Parcelable.Creator<ParcelableWrapper> CREATOR = new Parcelable.Creator<ParcelableWrapper>(){

            @Override
            public ParcelableWrapper createFromParcel(Parcel in) {
                return new ParcelableWrapper(ParcelableWrapper.readCutoutFromParcel(in));
            }

            public ParcelableWrapper[] newArray(int size) {
                return new ParcelableWrapper[size];
            }
        };

        public ParcelableWrapper() {
            this(NO_CUTOUT);
        }

        public ParcelableWrapper(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            ParcelableWrapper.writeCutoutToParcel(this.mInner, out, flags);
        }

        public static void writeCutoutToParcel(DisplayCutout cutout, Parcel out, int flags) {
            if (cutout == null) {
                out.writeInt(-1);
            } else if (cutout == NO_CUTOUT) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeTypedObject(cutout.mSafeInsets, flags);
                out.writeTypedObject(cutout.mBounds, flags);
            }
        }

        public void readFromParcel(Parcel in) {
            this.mInner = ParcelableWrapper.readCutoutFromParcel(in);
        }

        public static DisplayCutout readCutoutFromParcel(Parcel in) {
            int variant = in.readInt();
            if (variant == -1) {
                return null;
            }
            if (variant == 0) {
                return NO_CUTOUT;
            }
            Rect safeInsets = in.readTypedObject(Rect.CREATOR);
            Region bounds = in.readTypedObject(Region.CREATOR);
            return new DisplayCutout(safeInsets, bounds, false);
        }

        public DisplayCutout get() {
            return this.mInner;
        }

        public void set(ParcelableWrapper cutout) {
            this.mInner = cutout.get();
        }

        public void set(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        public int hashCode() {
            return this.mInner.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ParcelableWrapper && this.mInner.equals(((ParcelableWrapper)o).mInner);
        }

        public String toString() {
            return String.valueOf(this.mInner);
        }
    }
}

