/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewOverlay;
import android.view.ViewRootImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class ViewDebug {
    @Deprecated
    public static final boolean TRACE_HIERARCHY = false;
    @Deprecated
    public static final boolean TRACE_RECYCLER = false;
    public static final boolean DEBUG_DRAG = false;
    public static final boolean DEBUG_POSITIONING = false;
    private static HashMap<Class<?>, Method[]> mCapturedViewMethodsForClasses = null;
    private static HashMap<Class<?>, Field[]> mCapturedViewFieldsForClasses = null;
    private static final int CAPTURE_TIMEOUT = 4000;
    private static final String REMOTE_COMMAND_CAPTURE = "CAPTURE";
    private static final String REMOTE_COMMAND_DUMP = "DUMP";
    private static final String REMOTE_COMMAND_DUMP_THEME = "DUMP_THEME";
    private static final String REMOTE_COMMAND_INVALIDATE = "INVALIDATE";
    private static final String REMOTE_COMMAND_REQUEST_LAYOUT = "REQUEST_LAYOUT";
    private static final String REMOTE_PROFILE = "PROFILE";
    private static final String REMOTE_COMMAND_CAPTURE_LAYERS = "CAPTURE_LAYERS";
    private static final String REMOTE_COMMAND_OUTPUT_DISPLAYLIST = "OUTPUT_DISPLAYLIST";
    private static HashMap<Class<?>, Field[]> sFieldsForClasses;
    private static HashMap<Class<?>, Method[]> sMethodsForClasses;
    private static HashMap<AccessibleObject, ExportedProperty> sAnnotations;

    public static long getViewInstanceCount() {
        return Debug.countInstancesOfClass(View.class);
    }

    public static long getViewRootImplCount() {
        return Debug.countInstancesOfClass(ViewRootImpl.class);
    }

    @Deprecated
    public static void trace(View view, RecyclerTraceType type, int ... parameters) {
    }

    @Deprecated
    public static void startRecyclerTracing(String prefix, View view) {
    }

    @Deprecated
    public static void stopRecyclerTracing() {
    }

    @Deprecated
    public static void trace(View view, HierarchyTraceType type) {
    }

    @Deprecated
    public static void startHierarchyTracing(String prefix, View view) {
    }

    @Deprecated
    public static void stopHierarchyTracing() {
    }

    static void dispatchCommand(View view, String command, String parameters, OutputStream clientStream) throws IOException {
        view = view.getRootView();
        if (REMOTE_COMMAND_DUMP.equalsIgnoreCase(command)) {
            ViewDebug.dump(view, false, true, clientStream);
        } else if (REMOTE_COMMAND_DUMP_THEME.equalsIgnoreCase(command)) {
            ViewDebug.dumpTheme(view, clientStream);
        } else if (REMOTE_COMMAND_CAPTURE_LAYERS.equalsIgnoreCase(command)) {
            ViewDebug.captureLayers(view, new DataOutputStream(clientStream));
        } else {
            String[] params = parameters.split(" ");
            if (REMOTE_COMMAND_CAPTURE.equalsIgnoreCase(command)) {
                ViewDebug.capture(view, clientStream, params[0]);
            } else if (REMOTE_COMMAND_OUTPUT_DISPLAYLIST.equalsIgnoreCase(command)) {
                ViewDebug.outputDisplayList(view, params[0]);
            } else if (REMOTE_COMMAND_INVALIDATE.equalsIgnoreCase(command)) {
                ViewDebug.invalidate(view, params[0]);
            } else if (REMOTE_COMMAND_REQUEST_LAYOUT.equalsIgnoreCase(command)) {
                ViewDebug.requestLayout(view, params[0]);
            } else if (REMOTE_PROFILE.equalsIgnoreCase(command)) {
                ViewDebug.profile(view, clientStream, params[0]);
            }
        }
    }

    public static View findView(View root, String parameter) {
        if (parameter.indexOf(64) != -1) {
            String[] ids = parameter.split("@");
            String className = ids[0];
            int hashCode = (int)Long.parseLong(ids[1], 16);
            View view = root.getRootView();
            if (view instanceof ViewGroup) {
                return ViewDebug.findView((ViewGroup)view, className, hashCode);
            }
        } else {
            int id2 = root.getResources().getIdentifier(parameter, null, null);
            return root.getRootView().findViewById(id2);
        }
        return null;
    }

    private static void invalidate(View root, String parameter) {
        View view = ViewDebug.findView(root, parameter);
        if (view != null) {
            view.postInvalidate();
        }
    }

    private static void requestLayout(View root, String parameter) {
        final View view = ViewDebug.findView(root, parameter);
        if (view != null) {
            root.post(new Runnable(){

                @Override
                public void run() {
                    view.requestLayout();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void profile(View root, OutputStream clientStream, String parameter) throws IOException {
        View view = ViewDebug.findView(root, parameter);
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 32768);
            if (view != null) {
                ViewDebug.profileViewAndChildren(view, out);
            } else {
                out.write("-1 -1 -1");
                out.newLine();
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    public static void profileViewAndChildren(View view, BufferedWriter out) throws IOException {
        RenderNode node = RenderNode.create("ViewDebug", null);
        ViewDebug.profileViewAndChildren(view, node, out, true);
        node.destroy();
    }

    private static void profileViewAndChildren(View view, RenderNode node, BufferedWriter out, boolean root) throws IOException {
        long durationMeasure = root || (view.mPrivateFlags & 0x800) != 0 ? ViewDebug.profileViewMeasure(view) : 0L;
        long durationLayout = root || (view.mPrivateFlags & 0x2000) != 0 ? ViewDebug.profileViewLayout(view) : 0L;
        long durationDraw = root || !view.willNotDraw() || (view.mPrivateFlags & 0x20) != 0 ? ViewDebug.profileViewDraw(view, node) : 0L;
        out.write(String.valueOf(durationMeasure));
        out.write(32);
        out.write(String.valueOf(durationLayout));
        out.write(32);
        out.write(String.valueOf(durationDraw));
        out.newLine();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewDebug.profileViewAndChildren(group.getChildAt(i), node, out, false);
            }
        }
    }

    private static long profileViewMeasure(final View view) {
        return ViewDebug.profileViewOperation(view, new ViewOperation(){

            @Override
            public void pre() {
                this.forceLayout(view);
            }

            private void forceLayout(View view2) {
                view2.forceLayout();
                if (view2 instanceof ViewGroup) {
                    ViewGroup group = (ViewGroup)view2;
                    int count = group.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        this.forceLayout(group.getChildAt(i));
                    }
                }
            }

            @Override
            public void run() {
                view.measure(view.mOldWidthMeasureSpec, view.mOldHeightMeasureSpec);
            }
        });
    }

    private static long profileViewLayout(View view) {
        return ViewDebug.profileViewOperation(view, () -> view.layout(view.mLeft, view.mTop, view.mRight, view.mBottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long profileViewDraw(View view, RenderNode node) {
        DisplayMetrics dm = view.getResources().getDisplayMetrics();
        if (dm == null) {
            return 0L;
        }
        if (view.isHardwareAccelerated()) {
            DisplayListCanvas canvas = node.start(dm.widthPixels, dm.heightPixels);
            try {
                long l = ViewDebug.profileViewOperation(view, () -> view.draw(canvas));
                return l;
            }
            finally {
                node.end(canvas);
            }
        }
        Bitmap bitmap = Bitmap.createBitmap(dm, dm.widthPixels, dm.heightPixels, Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        try {
            long l = ViewDebug.profileViewOperation(view, () -> view.draw(canvas));
            return l;
        }
        finally {
            canvas.setBitmap(null);
            bitmap.recycle();
        }
    }

    private static long profileViewOperation(View view, ViewOperation operation) {
        CountDownLatch latch = new CountDownLatch(1);
        long[] duration = new long[1];
        view.post(() -> {
            try {
                operation.pre();
                long start = Debug.threadCpuTimeNanos();
                operation.run();
                duration[0] = Debug.threadCpuTimeNanos() - start;
            }
            finally {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(4000L, TimeUnit.MILLISECONDS)) {
                Log.w("View", "Could not complete the profiling of the view " + view);
                return -1L;
            }
        }
        catch (InterruptedException e) {
            Log.w("View", "Could not complete the profiling of the view " + view);
            Thread.currentThread().interrupt();
            return -1L;
        }
        return duration[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void captureLayers(View root, DataOutputStream clientStream) throws IOException {
        try {
            Rect outRect = new Rect();
            try {
                root.mAttachInfo.mSession.getDisplayFrame(root.mAttachInfo.mWindow, outRect);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            clientStream.writeInt(outRect.width());
            clientStream.writeInt(outRect.height());
            ViewDebug.captureViewLayer(root, clientStream, true);
            clientStream.write(2);
        }
        finally {
            clientStream.close();
        }
    }

    private static void captureViewLayer(View view, DataOutputStream clientStream, boolean visible) throws IOException {
        boolean localVisible;
        boolean bl = localVisible = view.getVisibility() == 0 && visible;
        if ((view.mPrivateFlags & 0x80) != 128) {
            int id2 = view.getId();
            String name = view.getClass().getSimpleName();
            if (id2 != -1) {
                name = ViewDebug.resolveId(view.getContext(), id2).toString();
            }
            clientStream.write(1);
            clientStream.writeUTF(name);
            clientStream.writeByte(localVisible ? 1 : 0);
            int[] position = new int[2];
            view.getLocationInWindow(position);
            clientStream.writeInt(position[0]);
            clientStream.writeInt(position[1]);
            clientStream.flush();
            Bitmap b = ViewDebug.performViewCapture(view, true);
            if (b != null) {
                ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(b.getWidth() * b.getHeight() * 2);
                b.compress(Bitmap.CompressFormat.PNG, 100, arrayOut);
                clientStream.writeInt(arrayOut.size());
                arrayOut.writeTo(clientStream);
            }
            clientStream.flush();
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewDebug.captureViewLayer(group.getChildAt(i), clientStream, localVisible);
            }
        }
        if (view.mOverlay != null) {
            ViewOverlay.OverlayViewGroup overlayContainer = view.getOverlay().mOverlayViewGroup;
            ViewDebug.captureViewLayer(overlayContainer, clientStream, localVisible);
        }
    }

    private static void outputDisplayList(View root, String parameter) throws IOException {
        View view = ViewDebug.findView(root, parameter);
        view.getViewRootImpl().outputDisplayList(view);
    }

    public static void outputDisplayList(View root, View target) {
        root.getViewRootImpl().outputDisplayList(target);
    }

    private static void capture(View root, OutputStream clientStream, String parameter) throws IOException {
        View captureView = ViewDebug.findView(root, parameter);
        ViewDebug.capture(root, clientStream, captureView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(View root, OutputStream clientStream, View captureView) throws IOException {
        Bitmap b = ViewDebug.performViewCapture(captureView, false);
        if (b == null) {
            Log.w("View", "Failed to create capture bitmap!");
            b = Bitmap.createBitmap(root.getResources().getDisplayMetrics(), 1, 1, Bitmap.Config.ARGB_8888);
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(clientStream, 32768);
            b.compress(Bitmap.CompressFormat.PNG, 100, out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            b.recycle();
        }
    }

    private static Bitmap performViewCapture(View captureView, boolean skipChildren) {
        if (captureView != null) {
            CountDownLatch latch = new CountDownLatch(1);
            Bitmap[] cache = new Bitmap[1];
            captureView.post(() -> {
                try {
                    CanvasProvider provider = captureView.isHardwareAccelerated() ? new HardwareCanvasProvider() : new SoftwareCanvasProvider();
                    cache[0] = captureView.createSnapshot(provider, skipChildren);
                }
                catch (OutOfMemoryError e) {
                    Log.w("View", "Out of memory for bitmap");
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await(4000L, TimeUnit.MILLISECONDS);
                return cache[0];
            }
            catch (InterruptedException e) {
                Log.w("View", "Could not complete the capture of the view " + captureView);
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void dump(View root, boolean skipChildren, boolean includeProperties, OutputStream clientStream) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream, "utf-8"), 32768);
            View view = root.getRootView();
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                ViewDebug.dumpViewHierarchy(group.getContext(), group, out, 0, skipChildren, includeProperties);
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    public static void dumpv2(final View view, ByteArrayOutputStream out) throws InterruptedException {
        final ViewHierarchyEncoder encoder = new ViewHierarchyEncoder(out);
        final CountDownLatch latch = new CountDownLatch(1);
        view.post(new Runnable(){

            @Override
            public void run() {
                encoder.addProperty("window:left", view.mAttachInfo.mWindowLeft);
                encoder.addProperty("window:top", view.mAttachInfo.mWindowTop);
                view.encode(encoder);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        encoder.endStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTheme(View view, OutputStream clientStream) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream, "utf-8"), 32768);
            String[] attributes = ViewDebug.getStyleAttributesDump(view.getContext().getResources(), view.getContext().getTheme());
            if (attributes != null) {
                for (int i = 0; i < attributes.length; i += 2) {
                    if (attributes[i] == null) continue;
                    out.write(attributes[i] + "\n");
                    out.write(attributes[i + 1] + "\n");
                }
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    private static String[] getStyleAttributesDump(Resources resources, Resources.Theme theme) {
        TypedValue outValue = new TypedValue();
        String nullString = "null";
        int i = 0;
        int[] attributes = theme.getAllAttributes();
        String[] data = new String[attributes.length * 2];
        for (int attributeId : attributes) {
            try {
                data[i] = resources.getResourceName(attributeId);
                data[i + 1] = theme.resolveAttribute(attributeId, outValue, true) ? outValue.coerceToString().toString() : nullString;
                i += 2;
                if (outValue.type != 1) continue;
                data[i - 1] = resources.getResourceName(outValue.resourceId);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return data;
    }

    private static View findView(ViewGroup group, String className, int hashCode) {
        if (ViewDebug.isRequestedView(group, className, hashCode)) {
            return group;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View found;
            View view = group.getChildAt(i);
            if (view instanceof ViewGroup) {
                found = ViewDebug.findView((ViewGroup)view, className, hashCode);
                if (found != null) {
                    return found;
                }
            } else if (ViewDebug.isRequestedView(view, className, hashCode)) {
                return view;
            }
            if (view.mOverlay != null && (found = ViewDebug.findView(view.mOverlay.mOverlayViewGroup, className, hashCode)) != null) {
                return found;
            }
            if (!(view instanceof HierarchyHandler) || (found = ((HierarchyHandler)((Object)view)).findHierarchyView(className, hashCode)) == null) continue;
            return found;
        }
        return null;
    }

    private static boolean isRequestedView(View view, String className, int hashCode) {
        if (view.hashCode() == hashCode) {
            String viewClassName = view.getClass().getName();
            if (className.equals("ViewOverlay")) {
                return viewClassName.equals("android.view.ViewOverlay$OverlayViewGroup");
            }
            return className.equals(viewClassName);
        }
        return false;
    }

    private static void dumpViewHierarchy(Context context, ViewGroup group, BufferedWriter out, int level, boolean skipChildren, boolean includeProperties) {
        if (!ViewDebug.dumpView(context, group, out, level, includeProperties)) {
            return;
        }
        if (skipChildren) {
            return;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = group.getChildAt(i);
            if (view instanceof ViewGroup) {
                ViewDebug.dumpViewHierarchy(context, (ViewGroup)view, out, level + 1, skipChildren, includeProperties);
            } else {
                ViewDebug.dumpView(context, view, out, level + 1, includeProperties);
            }
            if (view.mOverlay == null) continue;
            ViewOverlay overlay = view.getOverlay();
            ViewOverlay.OverlayViewGroup overlayContainer = overlay.mOverlayViewGroup;
            ViewDebug.dumpViewHierarchy(context, overlayContainer, out, level + 2, skipChildren, includeProperties);
        }
        if (group instanceof HierarchyHandler) {
            ((HierarchyHandler)((Object)group)).dumpViewHierarchyWithProperties(out, level + 1);
        }
    }

    private static boolean dumpView(Context context, View view, BufferedWriter out, int level, boolean includeProperties) {
        try {
            for (int i = 0; i < level; ++i) {
                out.write(32);
            }
            String className = view.getClass().getName();
            if (className.equals("android.view.ViewOverlay$OverlayViewGroup")) {
                className = "ViewOverlay";
            }
            out.write(className);
            out.write(64);
            out.write(Integer.toHexString(view.hashCode()));
            out.write(32);
            if (includeProperties) {
                ViewDebug.dumpViewProperties(context, view, out);
            }
            out.newLine();
        }
        catch (IOException e) {
            Log.w("View", "Error while dumping hierarchy tree");
            return false;
        }
        return true;
    }

    private static Field[] getExportedPropertyFields(Class<?> klass) {
        HashMap<Class<?>, Field[]> map;
        Field[] fields;
        if (sFieldsForClasses == null) {
            sFieldsForClasses = new HashMap();
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        if ((fields = (map = sFieldsForClasses).get(klass)) != null) {
            return fields;
        }
        try {
            Field[] declaredFields = klass.getDeclaredFieldsUnchecked(false);
            ArrayList<Field> foundFields = new ArrayList<Field>();
            for (Field field : declaredFields) {
                if (field.getType() == null || !field.isAnnotationPresent(ExportedProperty.class)) continue;
                field.setAccessible(true);
                foundFields.add(field);
                sAnnotations.put(field, field.getAnnotation(ExportedProperty.class));
            }
            fields = foundFields.toArray(new Field[foundFields.size()]);
            map.put(klass, fields);
        }
        catch (NoClassDefFoundError e) {
            throw new AssertionError((Object)e);
        }
        return fields;
    }

    private static Method[] getExportedPropertyMethods(Class<?> klass) {
        HashMap<Class<?>, Method[]> map;
        Method[] methods;
        if (sMethodsForClasses == null) {
            sMethodsForClasses = new HashMap(100);
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        if ((methods = (map = sMethodsForClasses).get(klass)) != null) {
            return methods;
        }
        methods = klass.getDeclaredMethodsUnchecked(false);
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Method method : methods) {
            try {
                method.getReturnType();
                method.getParameterTypes();
            }
            catch (NoClassDefFoundError e) {
                continue;
            }
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(ExportedProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            foundMethods.add(method);
            sAnnotations.put(method, method.getAnnotation(ExportedProperty.class));
        }
        methods = foundMethods.toArray(new Method[foundMethods.size()]);
        map.put(klass, methods);
        return methods;
    }

    private static void dumpViewProperties(Context context, Object view, BufferedWriter out) throws IOException {
        ViewDebug.dumpViewProperties(context, view, out, "");
    }

    private static void dumpViewProperties(Context context, Object view, BufferedWriter out, String prefix) throws IOException {
        if (view == null) {
            out.write(prefix + "=4,null ");
            return;
        }
        Class<?> klass = view.getClass();
        do {
            ViewDebug.exportFields(context, view, out, klass, prefix);
            ViewDebug.exportMethods(context, view, out, klass, prefix);
        } while ((klass = klass.getSuperclass()) != Object.class);
    }

    /*
     * Loose catch block
     */
    private static Object callMethodOnAppropriateTheadBlocking(final Method method, Object object) throws IllegalAccessException, InvocationTargetException, TimeoutException {
        if (!(object instanceof View)) {
            return method.invoke(object, (Object[])null);
        }
        final View view = (View)object;
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IllegalAccessException, InvocationTargetException {
                return method.invoke((Object)view, (Object[])null);
            }
        };
        FutureTask<Object> future = new FutureTask<Object>(callable);
        Handler handler = view.getHandler();
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        handler.post(future);
        while (true) {
            try {
                return future.get(4000L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof IllegalAccessException) {
                    throw (IllegalAccessException)t;
                }
                if (t instanceof InvocationTargetException) {
                    throw (InvocationTargetException)t;
                }
                throw new RuntimeException("Unexpected exception", t);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        catch (CancellationException e) {
            throw new RuntimeException("Unexpected cancellation exception", e);
        }
    }

    private static String formatIntToHexString(int value) {
        return "0x" + Integer.toHexString(value).toUpperCase();
    }

    private static void exportMethods(Context context, Object view, BufferedWriter out, Class<?> klass, String prefix) throws IOException {
        for (Method method : ViewDebug.getExportedPropertyMethods(klass)) {
            try {
                String categoryPrefix;
                Object methodValue;
                block13: {
                    ExportedProperty property;
                    Class<?> returnType;
                    block11: {
                        IntToString[] mapping;
                        block12: {
                            methodValue = ViewDebug.callMethodOnAppropriateTheadBlocking(method, view);
                            returnType = method.getReturnType();
                            property = sAnnotations.get(method);
                            String string2 = categoryPrefix = property.category().length() != 0 ? property.category() + ":" : "";
                            if (returnType != Integer.TYPE) break block11;
                            if (!property.resolveId() || context == null) break block12;
                            int id2 = (Integer)methodValue;
                            methodValue = ViewDebug.resolveId(context, id2);
                            break block13;
                        }
                        FlagToString[] flagsMapping = property.flagMapping();
                        if (flagsMapping.length > 0) {
                            int intValue = (Integer)methodValue;
                            String valuePrefix = categoryPrefix + prefix + method.getName() + '_';
                            ViewDebug.exportUnrolledFlags(out, flagsMapping, intValue, valuePrefix);
                        }
                        if ((mapping = property.mapping()).length <= 0) break block13;
                        int intValue = (Integer)methodValue;
                        boolean mapped = false;
                        int mappingCount = mapping.length;
                        for (int j = 0; j < mappingCount; ++j) {
                            IntToString mapper = mapping[j];
                            if (mapper.from() != intValue) continue;
                            methodValue = mapper.to();
                            mapped = true;
                            break;
                        }
                        if (mapped) break block13;
                        methodValue = intValue;
                        break block13;
                    }
                    if (returnType == int[].class) {
                        int[] array2 = (int[])methodValue;
                        String valuePrefix = categoryPrefix + prefix + method.getName() + '_';
                        String suffix = "()";
                        ViewDebug.exportUnrolledArray(context, out, property, array2, valuePrefix, "()");
                        continue;
                    }
                    if (returnType == String[].class) {
                        String[] array3 = (String[])methodValue;
                        if (!property.hasAdjacentMapping() || array3 == null) continue;
                        for (int j = 0; j < array3.length; j += 2) {
                            if (array3[j] == null) continue;
                            ViewDebug.writeEntry(out, categoryPrefix + prefix, array3[j], "()", array3[j + 1] == null ? "null" : array3[j + 1]);
                        }
                        continue;
                    }
                    if (!returnType.isPrimitive() && property.deepExport()) {
                        ViewDebug.dumpViewProperties(context, methodValue, out, prefix + property.prefix());
                        continue;
                    }
                }
                ViewDebug.writeEntry(out, categoryPrefix + prefix, method.getName(), "()", methodValue);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private static void exportFields(Context context, Object view, BufferedWriter out, Class<?> klass, String prefix) throws IOException {
        for (Field field : ViewDebug.getExportedPropertyFields(klass)) {
            try {
                String categoryPrefix;
                Object fieldValue;
                block14: {
                    ExportedProperty property;
                    Class<?> type;
                    block12: {
                        block15: {
                            IntToString[] mapping;
                            block13: {
                                fieldValue = null;
                                type = field.getType();
                                property = sAnnotations.get(field);
                                String string2 = categoryPrefix = property.category().length() != 0 ? property.category() + ":" : "";
                                if (type != Integer.TYPE && type != Byte.TYPE) break block12;
                                if (!property.resolveId() || context == null) break block13;
                                int id2 = field.getInt(view);
                                fieldValue = ViewDebug.resolveId(context, id2);
                                break block14;
                            }
                            FlagToString[] flagsMapping = property.flagMapping();
                            if (flagsMapping.length > 0) {
                                int intValue = field.getInt(view);
                                String valuePrefix = categoryPrefix + prefix + field.getName() + '_';
                                ViewDebug.exportUnrolledFlags(out, flagsMapping, intValue, valuePrefix);
                            }
                            if ((mapping = property.mapping()).length > 0) {
                                int intValue = field.getInt(view);
                                int mappingCount = mapping.length;
                                for (int j = 0; j < mappingCount; ++j) {
                                    IntToString mapped = mapping[j];
                                    if (mapped.from() != intValue) continue;
                                    fieldValue = mapped.to();
                                    break;
                                }
                                if (fieldValue == null) {
                                    fieldValue = intValue;
                                }
                            }
                            if (!property.formatToHexString()) break block14;
                            fieldValue = field.get(view);
                            if (type != Integer.TYPE) break block15;
                            fieldValue = ViewDebug.formatIntToHexString((Integer)fieldValue);
                            break block14;
                        }
                        if (type != Byte.TYPE) break block14;
                        fieldValue = "0x" + Byte.toHexString((byte)((Byte)fieldValue), (boolean)true);
                        break block14;
                    }
                    if (type == int[].class) {
                        int[] array2 = (int[])field.get(view);
                        String valuePrefix = categoryPrefix + prefix + field.getName() + '_';
                        String suffix = "";
                        ViewDebug.exportUnrolledArray(context, out, property, array2, valuePrefix, "");
                        continue;
                    }
                    if (type == String[].class) {
                        String[] array3 = (String[])field.get(view);
                        if (!property.hasAdjacentMapping() || array3 == null) continue;
                        for (int j = 0; j < array3.length; j += 2) {
                            if (array3[j] == null) continue;
                            ViewDebug.writeEntry(out, categoryPrefix + prefix, array3[j], "", array3[j + 1] == null ? "null" : array3[j + 1]);
                        }
                        continue;
                    }
                    if (!type.isPrimitive() && property.deepExport()) {
                        ViewDebug.dumpViewProperties(context, field.get(view), out, prefix + property.prefix());
                        continue;
                    }
                }
                if (fieldValue == null) {
                    fieldValue = field.get(view);
                }
                ViewDebug.writeEntry(out, categoryPrefix + prefix, field.getName(), "", fieldValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void writeEntry(BufferedWriter out, String prefix, String name, String suffix, Object value) throws IOException {
        out.write(prefix);
        out.write(name);
        out.write(suffix);
        out.write("=");
        ViewDebug.writeValue(out, value);
        out.write(32);
    }

    private static void exportUnrolledFlags(BufferedWriter out, FlagToString[] mapping, int intValue, String prefix) throws IOException {
        for (FlagToString flagMapping : mapping) {
            boolean test;
            boolean ifTrue = flagMapping.outputIf();
            int maskResult = intValue & flagMapping.mask();
            boolean bl = test = maskResult == flagMapping.equals();
            if ((!test || !ifTrue) && (test || ifTrue)) continue;
            String name = flagMapping.name();
            String value = ViewDebug.formatIntToHexString(maskResult);
            ViewDebug.writeEntry(out, prefix, name, "", value);
        }
    }

    public static String intToString(Class<?> clazz, String field, int integer2) {
        IntToString[] mapping = ViewDebug.getMapping(clazz, field);
        if (mapping == null) {
            return Integer.toString(integer2);
        }
        for (IntToString map : mapping) {
            if (map.from() != integer2) continue;
            return map.to();
        }
        return Integer.toString(integer2);
    }

    public static String flagsToString(Class<?> clazz, String field, int flags) {
        FlagToString[] mapping = ViewDebug.getFlagMapping(clazz, field);
        if (mapping == null) {
            return Integer.toHexString(flags);
        }
        StringBuilder result = new StringBuilder();
        for (FlagToString flagMapping : mapping) {
            boolean test;
            boolean ifTrue = flagMapping.outputIf();
            int maskResult = flags & flagMapping.mask();
            boolean bl = test = maskResult == flagMapping.equals();
            if (!test || !ifTrue) continue;
            String name = flagMapping.name();
            result.append(name).append(' ');
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static FlagToString[] getFlagMapping(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field).getAnnotation(ExportedProperty.class).flagMapping();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static IntToString[] getMapping(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field).getAnnotation(ExportedProperty.class).mapping();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static void exportUnrolledArray(Context context, BufferedWriter out, ExportedProperty property, int[] array2, String prefix, String suffix) throws IOException {
        IntToString[] indexMapping = property.indexMapping();
        boolean hasIndexMapping = indexMapping.length > 0;
        IntToString[] mapping = property.mapping();
        boolean hasMapping = mapping.length > 0;
        boolean resolveId = property.resolveId() && context != null;
        int valuesCount = array2.length;
        for (int j = 0; j < valuesCount; ++j) {
            String value = null;
            int intValue = array2[j];
            String name = String.valueOf(j);
            if (hasIndexMapping) {
                for (IntToString mapped : indexMapping) {
                    if (mapped.from() != j) continue;
                    name = mapped.to();
                    break;
                }
            }
            if (hasMapping) {
                for (IntToString mapped : mapping) {
                    if (mapped.from() != intValue) continue;
                    value = mapped.to();
                    break;
                }
            }
            if (resolveId) {
                if (value == null) {
                    value = (String)ViewDebug.resolveId(context, intValue);
                }
            } else {
                value = String.valueOf(intValue);
            }
            ViewDebug.writeEntry(out, prefix, name, suffix, value);
        }
    }

    static Object resolveId(Context context, int id2) {
        String fieldValue;
        Resources resources = context.getResources();
        if (id2 >= 0) {
            try {
                fieldValue = resources.getResourceTypeName(id2) + '/' + resources.getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                fieldValue = "id/" + ViewDebug.formatIntToHexString(id2);
            }
        } else {
            fieldValue = "NO_ID";
        }
        return fieldValue;
    }

    private static void writeValue(BufferedWriter out, Object value) throws IOException {
        if (value != null) {
            String output = "[EXCEPTION]";
            try {
                output = value.toString().replace("\n", "\\n");
            }
            finally {
                out.write(String.valueOf(output.length()));
                out.write(",");
                out.write(output);
            }
        } else {
            out.write("4,null");
        }
    }

    private static Field[] capturedViewGetPropertyFields(Class<?> klass) {
        HashMap<Class<?>, Field[]> map;
        Field[] fields;
        if (mCapturedViewFieldsForClasses == null) {
            mCapturedViewFieldsForClasses = new HashMap();
        }
        if ((fields = (map = mCapturedViewFieldsForClasses).get(klass)) != null) {
            return fields;
        }
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (Field field : klass.getFields()) {
            if (!field.isAnnotationPresent(CapturedViewProperty.class)) continue;
            field.setAccessible(true);
            foundFields.add(field);
        }
        fields = foundFields.toArray(new Field[foundFields.size()]);
        map.put(klass, fields);
        return fields;
    }

    private static Method[] capturedViewGetPropertyMethods(Class<?> klass) {
        HashMap<Class<?>, Method[]> map;
        Method[] methods;
        if (mCapturedViewMethodsForClasses == null) {
            mCapturedViewMethodsForClasses = new HashMap();
        }
        if ((methods = (map = mCapturedViewMethodsForClasses).get(klass)) != null) {
            return methods;
        }
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Method method : klass.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(CapturedViewProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            foundMethods.add(method);
        }
        methods = foundMethods.toArray(new Method[foundMethods.size()]);
        map.put(klass, methods);
        return methods;
    }

    private static String capturedViewExportMethods(Object obj, Class<?> klass, String prefix) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Method method : ViewDebug.capturedViewGetPropertyMethods(klass)) {
            try {
                Object methodValue = method.invoke(obj, (Object[])null);
                Class<?> returnType = method.getReturnType();
                CapturedViewProperty property = method.getAnnotation(CapturedViewProperty.class);
                if (property.retrieveReturn()) {
                    sb.append(ViewDebug.capturedViewExportMethods(methodValue, returnType, method.getName() + "#"));
                    continue;
                }
                sb.append(prefix);
                sb.append(method.getName());
                sb.append("()=");
                if (methodValue != null) {
                    String value = methodValue.toString().replace("\n", "\\n");
                    sb.append(value);
                } else {
                    sb.append("null");
                }
                sb.append("; ");
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private static String capturedViewExportFields(Object obj, Class<?> klass, String prefix) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Field field : ViewDebug.capturedViewGetPropertyFields(klass)) {
            try {
                Object fieldValue = field.get(obj);
                sb.append(prefix);
                sb.append(field.getName());
                sb.append("=");
                if (fieldValue != null) {
                    String value = fieldValue.toString().replace("\n", "\\n");
                    sb.append(value);
                } else {
                    sb.append("null");
                }
                sb.append(' ');
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void dumpCapturedView(String tag, Object view) {
        Class<?> klass = view.getClass();
        StringBuilder sb = new StringBuilder(klass.getName() + ": ");
        sb.append(ViewDebug.capturedViewExportFields(view, klass, ""));
        sb.append(ViewDebug.capturedViewExportMethods(view, klass, ""));
        Log.d(tag, sb.toString());
    }

    public static Object invokeViewMethod(final View view, final Method method, final Object[] args) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        view.post(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(method.invoke((Object)view, args));
                }
                catch (InvocationTargetException e) {
                    exception.set(e.getCause());
                }
                catch (Exception e) {
                    exception.set(e);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw new RuntimeException((Throwable)exception.get());
        }
        return result.get();
    }

    public static void setLayoutParameter(final View view, String param, int value) throws NoSuchFieldException, IllegalAccessException {
        final ViewGroup.LayoutParams p = view.getLayoutParams();
        Field f = p.getClass().getField(param);
        if (f.getType() != Integer.TYPE) {
            throw new RuntimeException("Only integer layout parameters can be set. Field " + param + " is of type " + f.getType().getSimpleName());
        }
        f.set(p, value);
        view.post(new Runnable(){

            @Override
            public void run() {
                view.setLayoutParams(p);
            }
        });
    }

    public static interface CanvasProvider {
        public Canvas getCanvas(View var1, int var2, int var3);

        public Bitmap createBitmap();
    }

    public static class HardwareCanvasProvider
    implements CanvasProvider {
        private Picture mPicture;

        @Override
        public Canvas getCanvas(View view, int width, int height) {
            this.mPicture = new Picture();
            return this.mPicture.beginRecording(width, height);
        }

        @Override
        public Bitmap createBitmap() {
            this.mPicture.endRecording();
            return Bitmap.createBitmap(this.mPicture);
        }
    }

    public static class SoftwareCanvasProvider
    implements CanvasProvider {
        private Canvas mCanvas;
        private Bitmap mBitmap;
        private boolean mEnabledHwBitmapsInSwMode;

        @Override
        public Canvas getCanvas(View view, int width, int height) {
            this.mBitmap = Bitmap.createBitmap(view.getResources().getDisplayMetrics(), width, height, Bitmap.Config.ARGB_8888);
            if (this.mBitmap == null) {
                throw new OutOfMemoryError();
            }
            this.mBitmap.setDensity(view.getResources().getDisplayMetrics().densityDpi);
            if (view.mAttachInfo != null) {
                this.mCanvas = view.mAttachInfo.mCanvas;
            }
            if (this.mCanvas == null) {
                this.mCanvas = new Canvas();
            }
            this.mEnabledHwBitmapsInSwMode = this.mCanvas.isHwBitmapsInSwModeEnabled();
            this.mCanvas.setBitmap(this.mBitmap);
            return this.mCanvas;
        }

        @Override
        public Bitmap createBitmap() {
            this.mCanvas.setBitmap(null);
            this.mCanvas.setHwBitmapsInSwModeEnabled(this.mEnabledHwBitmapsInSwMode);
            return this.mBitmap;
        }
    }

    static interface ViewOperation {
        default public void pre() {
        }

        public void run();
    }

    @Deprecated
    public static enum RecyclerTraceType {
        NEW_VIEW,
        BIND_VIEW,
        RECYCLE_FROM_ACTIVE_HEAP,
        RECYCLE_FROM_SCRAP_HEAP,
        MOVE_TO_SCRAP_HEAP,
        MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;

    }

    @Deprecated
    public static enum HierarchyTraceType {
        INVALIDATE,
        INVALIDATE_CHILD,
        INVALIDATE_CHILD_IN_PARENT,
        REQUEST_LAYOUT,
        ON_LAYOUT,
        ON_MEASURE,
        DRAW,
        BUILD_CACHE;

    }

    public static interface HierarchyHandler {
        public void dumpViewHierarchyWithProperties(BufferedWriter var1, int var2);

        public View findHierarchyView(String var1, int var2);
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CapturedViewProperty {
        public boolean retrieveReturn() default false;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FlagToString {
        public int mask();

        public int equals();

        public String name();

        public boolean outputIf() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntToString {
        public int from();

        public String to();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExportedProperty {
        public boolean resolveId() default false;

        public IntToString[] mapping() default {};

        public IntToString[] indexMapping() default {};

        public FlagToString[] flagMapping() default {};

        public boolean deepExport() default false;

        public String prefix() default "";

        public String category() default "";

        public boolean formatToHexString() default false;

        public boolean hasAdjacentMapping() default false;
    }
}

