/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.Trace;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Pools;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager_Delegate;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputConnectionWrapper;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import com.android.internal.view.InputMethodClient;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InputMethodManager {
    static final boolean DEBUG = false;
    static final String TAG = "InputMethodManager";
    static final String PENDING_EVENT_COUNTER = "aq:imm";
    static InputMethodManager sInstance;
    public static final int CONTROL_WINDOW_VIEW_HAS_FOCUS = 1;
    public static final int CONTROL_WINDOW_IS_TEXT_EDITOR = 2;
    public static final int CONTROL_WINDOW_FIRST = 4;
    public static final int CONTROL_START_INITIAL = 256;
    static final long INPUT_METHOD_NOT_RESPONDING_TIMEOUT = 2500L;
    public static final int DISPATCH_IN_PROGRESS = -1;
    public static final int DISPATCH_NOT_HANDLED = 0;
    public static final int DISPATCH_HANDLED = 1;
    public static final int SHOW_IM_PICKER_MODE_AUTO = 0;
    public static final int SHOW_IM_PICKER_MODE_INCLUDE_AUXILIARY_SUBTYPES = 1;
    public static final int SHOW_IM_PICKER_MODE_EXCLUDE_AUXILIARY_SUBTYPES = 2;
    final IInputMethodManager mService;
    final Looper mMainLooper;
    final H mH;
    final IInputContext mIInputContext;
    boolean mActive = false;
    boolean mRestartOnNextWindowFocus = true;
    boolean mFullscreenMode;
    View mCurRootView;
    View mServedView;
    View mNextServedView;
    boolean mServedConnecting;
    EditorInfo mCurrentTextBoxAttribute;
    ControlledInputConnectionWrapper mServedInputConnectionWrapper;
    CompletionInfo[] mCompletions;
    Rect mTmpCursorRect = new Rect();
    Rect mCursorRect = new Rect();
    int mCursorSelStart;
    int mCursorSelEnd;
    int mCursorCandStart;
    int mCursorCandEnd;
    private static final int NOT_AN_ACTION_NOTIFICATION_SEQUENCE_NUMBER = -1;
    private int mNextUserActionNotificationSequenceNumber = -1;
    private int mLastSentUserActionNotificationSequenceNumber = -1;
    private CursorAnchorInfo mCursorAnchorInfo = null;
    int mBindSequence = -1;
    String mCurId;
    IInputMethodSession mCurMethod;
    InputChannel mCurChannel;
    ImeInputEventSender mCurSender;
    private static final int REQUEST_UPDATE_CURSOR_ANCHOR_INFO_NONE = 0;
    private int mRequestUpdateCursorAnchorInfoMonitorMode = 0;
    final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
    final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
    static final int MSG_DUMP = 1;
    static final int MSG_BIND = 2;
    static final int MSG_UNBIND = 3;
    static final int MSG_SET_ACTIVE = 4;
    static final int MSG_SEND_INPUT_EVENT = 5;
    static final int MSG_TIMEOUT_INPUT_EVENT = 6;
    static final int MSG_FLUSH_INPUT_EVENT = 7;
    static final int MSG_SET_USER_ACTION_NOTIFICATION_SEQUENCE_NUMBER = 9;
    static final int MSG_REPORT_FULLSCREEN_MODE = 10;
    final IInputMethodClient.Stub mClient = new IInputMethodClient.Stub(){

        @Override
        protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
            CountDownLatch latch = new CountDownLatch(1);
            SomeArgs sargs = SomeArgs.obtain();
            sargs.arg1 = fd;
            sargs.arg2 = fout;
            sargs.arg3 = args;
            sargs.arg4 = latch;
            InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(1, sargs));
            try {
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    fout.println("Timeout waiting for dump");
                }
            }
            catch (InterruptedException e) {
                fout.println("Interrupted waiting for dump");
            }
        }

        @Override
        public void setUsingInputMethod(boolean state) {
        }

        @Override
        public void onBindMethod(InputBindResult res) {
            InputMethodManager.this.mH.obtainMessage(2, res).sendToTarget();
        }

        @Override
        public void onUnbindMethod(int sequence, int unbindReason) {
            InputMethodManager.this.mH.obtainMessage(3, sequence, unbindReason).sendToTarget();
        }

        @Override
        public void setActive(boolean active, boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(4, active ? 1 : 0, fullscreen ? 1 : 0).sendToTarget();
        }

        @Override
        public void setUserActionNotificationSequenceNumber(int sequenceNumber) {
            InputMethodManager.this.mH.obtainMessage(9, sequenceNumber, 0).sendToTarget();
        }

        @Override
        public void reportFullscreenMode(boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(10, fullscreen ? 1 : 0, 0).sendToTarget();
        }
    };
    final InputConnection mDummyInputConnection = new BaseInputConnection(this, false);
    public static final int SHOW_IMPLICIT = 1;
    public static final int SHOW_FORCED = 2;
    public static final int RESULT_UNCHANGED_SHOWN = 0;
    public static final int RESULT_UNCHANGED_HIDDEN = 1;
    public static final int RESULT_SHOWN = 2;
    public static final int RESULT_HIDDEN = 3;
    public static final int HIDE_IMPLICIT_ONLY = 1;
    public static final int HIDE_NOT_ALWAYS = 2;

    private static boolean isAutofillUIShowing(View servedView) {
        AutofillManager afm = servedView.getContext().getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillUiShowing();
    }

    private static boolean canStartInput(View servedView) {
        return servedView.hasWindowFocus() || InputMethodManager.isAutofillUIShowing(servedView);
    }

    InputMethodManager(Looper looper) throws ServiceManager.ServiceNotFoundException {
        this(IInputMethodManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input_method")), looper);
    }

    InputMethodManager(IInputMethodManager service, Looper looper) {
        this.mService = service;
        this.mMainLooper = looper;
        this.mH = new H(looper);
        this.mIInputContext = new ControlledInputConnectionWrapper(looper, this.mDummyInputConnection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputMethodManager getInstance_Original() {
        Class<InputMethodManager> clazz = InputMethodManager.class;
        synchronized (InputMethodManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new InputMethodManager(Looper.getMainLooper());
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @LayoutlibDelegate
    public static InputMethodManager getInstance() {
        return InputMethodManager_Delegate.getInstance();
    }

    public static InputMethodManager peekInstance() {
        return sInstance;
    }

    public IInputMethodClient getClient() {
        return this.mClient;
    }

    public IInputContext getInputContext() {
        return this.mIInputContext;
    }

    public List<InputMethodInfo> getInputMethodList() {
        try {
            return this.mService.getInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputMethodInfo> getVrInputMethodList() {
        try {
            return this.mService.getVrInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputMethodInfo> getEnabledInputMethodList() {
        try {
            return this.mService.getEnabledInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
        try {
            return this.mService.getEnabledInputMethodSubtypeList(imi == null ? null : imi.getId(), allowsImplicitlySelectedSubtypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void showStatusIcon(IBinder imeToken, String packageName, int iconId) {
        this.showStatusIconInternal(imeToken, packageName, iconId);
    }

    public void showStatusIconInternal(IBinder imeToken, String packageName, int iconId) {
        try {
            this.mService.updateStatusIcon(imeToken, packageName, iconId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void hideStatusIcon(IBinder imeToken) {
        this.hideStatusIconInternal(imeToken);
    }

    public void hideStatusIconInternal(IBinder imeToken) {
        try {
            this.mService.updateStatusIcon(imeToken, null, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setImeWindowStatus(IBinder imeToken, IBinder startInputToken, int vis, int backDisposition) {
        try {
            this.mService.setImeWindowStatus(imeToken, startInputToken, vis, backDisposition);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        try {
            this.mService.registerSuggestionSpansForNotification(spans);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        try {
            this.mService.notifySuggestionPicked(span, originalString, index);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullscreenMode() {
        H h = this.mH;
        synchronized (h) {
            return this.mFullscreenMode;
        }
    }

    public void reportFullscreenMode(IBinder token, boolean fullscreen) {
        try {
            this.mService.reportFullscreenMode(token, fullscreen);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return (this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view)) && this.mCurrentTextBoxAttribute != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.mServedView != null && this.mCurrentTextBoxAttribute != null;
        }
    }

    public boolean isAcceptingText() {
        this.checkFocus();
        return this.mServedInputConnectionWrapper != null && this.mServedInputConnectionWrapper.getInputConnection() != null;
    }

    void clearBindingLocked() {
        this.clearConnectionLocked();
        this.setInputChannelLocked(null);
        this.mBindSequence = -1;
        this.mCurId = null;
        this.mCurMethod = null;
    }

    void setInputChannelLocked(InputChannel channel) {
        if (this.mCurChannel != channel) {
            if (this.mCurSender != null) {
                this.flushPendingEventsLocked();
                this.mCurSender.dispose();
                this.mCurSender = null;
            }
            if (this.mCurChannel != null) {
                this.mCurChannel.dispose();
            }
            this.mCurChannel = channel;
        }
    }

    void clearConnectionLocked() {
        this.mCurrentTextBoxAttribute = null;
        if (this.mServedInputConnectionWrapper != null) {
            this.mServedInputConnectionWrapper.deactivate();
            this.mServedInputConnectionWrapper = null;
        }
    }

    void finishInputLocked() {
        this.mNextServedView = null;
        if (this.mServedView != null) {
            if (this.mCurrentTextBoxAttribute != null) {
                try {
                    this.mService.finishInput(this.mClient);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mServedView = null;
            this.mCompletions = null;
            this.mServedConnecting = false;
            this.clearConnectionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCompletions(View view, CompletionInfo[] completions) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mCompletions = completions;
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.displayCompletions(this.mCompletions);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExtractedText(View view, int token, ExtractedText text) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.updateExtractedText(token, text);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    public boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return false;
            }
            try {
                return this.mService.showSoftInput(this.mClient, flags, resultReceiver);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public void showSoftInputUnchecked(int flags, ResultReceiver resultReceiver) {
        try {
            Log.w(TAG, "showSoftInputUnchecked() is a hidden method, which will be removed soon. If you are using android.support.v7.widget.SearchView, please update to version 26.0 or newer version.");
            this.mService.showSoftInput(this.mClient, flags, resultReceiver);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != windowToken) {
                return false;
            }
            try {
                return this.mService.hideSoftInput(this.mClient, flags, resultReceiver);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSoftInputFromWindow(IBinder windowToken, int showFlags, int hideFlags) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != windowToken) {
                return;
            }
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.toggleSoftInput(showFlags, hideFlags);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public void toggleSoftInput(int showFlags, int hideFlags) {
        if (this.mCurMethod != null) {
            try {
                this.mCurMethod.toggleSoftInput(showFlags, hideFlags);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartInput(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner(3, null, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startInputInner(int startInputReason, IBinder windowGainingFocus, int controlFlags, int softInputMode, int windowFlags) {
        View view;
        H h = this.mH;
        synchronized (h) {
            view = this.mServedView;
            if (view == null) {
                return false;
            }
        }
        Handler vh = view.getHandler();
        if (vh == null) {
            this.closeCurrentInput();
            return false;
        }
        if (vh.getLooper() != Looper.myLooper()) {
            vh.post(() -> this.startInputInner(startInputReason, null, 0, 0, 0));
            return false;
        }
        EditorInfo tba = new EditorInfo();
        tba.packageName = view.getContext().getOpPackageName();
        tba.fieldId = view.getId();
        InputConnection ic = view.onCreateInputConnection(tba);
        H h2 = this.mH;
        synchronized (h2) {
            ControlledInputConnectionWrapper servedContext;
            int missingMethodFlags;
            if (this.mServedView != view || !this.mServedConnecting) {
                return false;
            }
            if (this.mCurrentTextBoxAttribute == null) {
                controlFlags |= 0x100;
            }
            this.mCurrentTextBoxAttribute = tba;
            this.mServedConnecting = false;
            if (this.mServedInputConnectionWrapper != null) {
                this.mServedInputConnectionWrapper.deactivate();
                this.mServedInputConnectionWrapper = null;
            }
            if (ic != null) {
                this.mCursorSelStart = tba.initialSelStart;
                this.mCursorSelEnd = tba.initialSelEnd;
                this.mCursorCandStart = -1;
                this.mCursorCandEnd = -1;
                this.mCursorRect.setEmpty();
                this.mCursorAnchorInfo = null;
                missingMethodFlags = InputConnectionInspector.getMissingMethodFlags(ic);
                Handler icHandler = (missingMethodFlags & 0x20) != 0 ? null : ic.getHandler();
                servedContext = new ControlledInputConnectionWrapper(icHandler != null ? icHandler.getLooper() : vh.getLooper(), ic, this);
            } else {
                servedContext = null;
                missingMethodFlags = 0;
            }
            this.mServedInputConnectionWrapper = servedContext;
            try {
                InputBindResult res = this.mService.startInputOrWindowGainedFocus(startInputReason, this.mClient, windowGainingFocus, controlFlags, softInputMode, windowFlags, tba, servedContext, missingMethodFlags, view.getContext().getApplicationInfo().targetSdkVersion);
                if (res == null) {
                    Log.wtf(TAG, "startInputOrWindowGainedFocus must not return null. startInputReason=" + InputMethodClient.getStartInputReason(startInputReason) + " editorInfo=" + tba + " controlFlags=#" + Integer.toHexString(controlFlags));
                    return false;
                }
                if (res.id != null) {
                    this.setInputChannelLocked(res.channel);
                    this.mBindSequence = res.sequence;
                    this.mCurMethod = res.method;
                    this.mCurId = res.id;
                    this.mNextUserActionNotificationSequenceNumber = res.userActionNotificationSequenceNumber;
                } else if (res.channel != null && res.channel != this.mCurChannel) {
                    res.channel.dispose();
                }
                switch (res.result) {
                    case 11: {
                        this.mRestartOnNextWindowFocus = true;
                    }
                }
                if (this.mCurMethod != null && this.mCompletions != null) {
                    try {
                        this.mCurMethod.displayCompletions(this.mCompletions);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            catch (RemoteException e) {
                Log.w(TAG, "IME died: " + this.mCurId, e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowDismissed(IBinder appWindowToken) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != null && this.mServedView.getWindowToken() == appWindowToken) {
                this.finishInputLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusIn(View view) {
        H h = this.mH;
        synchronized (h) {
            this.focusInLocked(view);
        }
    }

    void focusInLocked(View view) {
        if (view != null && view.isTemporarilyDetached()) {
            return;
        }
        if (this.mCurRootView != view.getRootView()) {
            return;
        }
        this.mNextServedView = view;
        InputMethodManager.scheduleCheckFocusLocked(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusOut(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onViewDetachedFromWindow(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == view) {
                this.mNextServedView = null;
                InputMethodManager.scheduleCheckFocusLocked(view);
            }
        }
    }

    static void scheduleCheckFocusLocked(View view) {
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.dispatchCheckFocus();
        }
    }

    public void checkFocus() {
        if (this.checkFocusNoStartInput(false)) {
            this.startInputInner(4, null, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFocusNoStartInput(boolean forceNewFocus) {
        ControlledInputConnectionWrapper ic;
        if (this.mServedView == this.mNextServedView && !forceNewFocus) {
            return false;
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == this.mNextServedView && !forceNewFocus) {
                return false;
            }
            if (this.mNextServedView == null) {
                this.finishInputLocked();
                this.closeCurrentInput();
                return false;
            }
            ic = this.mServedInputConnectionWrapper;
            this.mServedView = this.mNextServedView;
            this.mCurrentTextBoxAttribute = null;
            this.mCompletions = null;
            this.mServedConnecting = true;
        }
        if (ic != null) {
            ic.finishComposingText();
        }
        return true;
    }

    void closeCurrentInput() {
        try {
            this.mService.hideSoftInput(this.mClient, 2, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostWindowFocus(View rootView, View focusedView, int softInputMode, boolean first, int windowFlags) {
        boolean forceNewFocus = false;
        H h = this.mH;
        synchronized (h) {
            if (this.mRestartOnNextWindowFocus) {
                this.mRestartOnNextWindowFocus = false;
                forceNewFocus = true;
            }
            this.focusInLocked(focusedView != null ? focusedView : rootView);
        }
        int controlFlags = 0;
        if (focusedView != null) {
            controlFlags |= 1;
            if (focusedView.onCheckIsTextEditor()) {
                controlFlags |= 2;
            }
        }
        if (first) {
            controlFlags |= 4;
        }
        if (this.checkFocusNoStartInput(forceNewFocus) && this.startInputInner(1, rootView.getWindowToken(), controlFlags, softInputMode, windowFlags)) {
            return;
        }
        H h2 = this.mH;
        synchronized (h2) {
            try {
                this.mService.startInputOrWindowGainedFocus(2, this.mClient, rootView.getWindowToken(), controlFlags, softInputMode, windowFlags, null, null, 0, rootView.getContext().getApplicationInfo().targetSdkVersion);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreWindowFocus(View rootView, boolean hasWindowFocus) {
        H h = this.mH;
        synchronized (h) {
            if (rootView == null) {
                this.mCurRootView = null;
            }
            if (hasWindowFocus) {
                this.mCurRootView = rootView;
            } else if (rootView == this.mCurRootView) {
                this.mCurRootView = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(View view, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            if (this.mCursorSelStart != selStart || this.mCursorSelEnd != selEnd || this.mCursorCandStart != candidatesStart || this.mCursorCandEnd != candidatesEnd) {
                try {
                    int oldSelStart = this.mCursorSelStart;
                    int oldSelEnd = this.mCursorSelEnd;
                    this.mCursorSelStart = selStart;
                    this.mCursorSelEnd = selEnd;
                    this.mCursorCandStart = candidatesStart;
                    this.mCursorCandEnd = candidatesEnd;
                    this.mCurMethod.updateSelection(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "IME died: " + this.mCurId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewClicked(View view) {
        boolean focusChanged = this.mServedView != this.mNextServedView;
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.viewClicked(focusChanged);
            }
            catch (RemoteException e) {
                Log.w(TAG, "IME died: " + this.mCurId, e);
            }
        }
    }

    @Deprecated
    public boolean isWatchingCursor(View view) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorAnchorInfoEnabled() {
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            boolean isMonitoring = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 2) != 0;
            return isImmediate || isMonitoring;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateCursorAnchorInfoMode(int flags) {
        H h = this.mH;
        synchronized (h) {
            this.mRequestUpdateCursorAnchorInfoMonitorMode = flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateCursor(View view, int left, int top, int right, int bottom) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            this.mTmpCursorRect.set(left, top, right, bottom);
            if (!this.mCursorRect.equals(this.mTmpCursorRect)) {
                try {
                    this.mCurMethod.updateCursor(this.mTmpCursorRect);
                    this.mCursorRect.set(this.mTmpCursorRect);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "IME died: " + this.mCurId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (view == null || cursorAnchorInfo == null) {
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate;
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            boolean bl = isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            if (!isImmediate && Objects.equals(this.mCursorAnchorInfo, cursorAnchorInfo)) {
                return;
            }
            try {
                this.mCurMethod.updateCursorAnchorInfo(cursorAnchorInfo);
                this.mCursorAnchorInfo = cursorAnchorInfo;
                this.mRequestUpdateCursorAnchorInfoMonitorMode &= 0xFFFFFFFE;
            }
            catch (RemoteException e) {
                Log.w(TAG, "IME died: " + this.mCurId, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAppPrivateCommand(View view, String action, Bundle data) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.appPrivateCommand(action, data);
            }
            catch (RemoteException e) {
                Log.w(TAG, "IME died: " + this.mCurId, e);
            }
        }
    }

    @Deprecated
    public void setInputMethod(IBinder token, String id2) {
        this.setInputMethodInternal(token, id2);
    }

    public void setInputMethodInternal(IBinder token, String id2) {
        try {
            this.mService.setInputMethod(token, id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        this.setInputMethodAndSubtypeInternal(token, id2, subtype);
    }

    public void setInputMethodAndSubtypeInternal(IBinder token, String id2, InputMethodSubtype subtype) {
        try {
            this.mService.setInputMethodAndSubtype(token, id2, subtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void hideSoftInputFromInputMethod(IBinder token, int flags) {
        this.hideSoftInputFromInputMethodInternal(token, flags);
    }

    public void hideSoftInputFromInputMethodInternal(IBinder token, int flags) {
        try {
            this.mService.hideMySoftInput(token, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void showSoftInputFromInputMethod(IBinder token, int flags) {
        this.showSoftInputFromInputMethodInternal(token, flags);
    }

    public void showSoftInputFromInputMethodInternal(IBinder token, int flags) {
        try {
            this.mService.showMySoftInput(token, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurMethod != null) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getAction() == 0 && keyEvent.getKeyCode() == 63 && keyEvent.getRepeatCount() == 0) {
                    this.showInputMethodPickerLocked();
                    return 1;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, this.mCurId, callback, handler);
                if (this.mMainLooper.isCurrentThread()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mH.obtainMessage(5, p);
                msg.setAsynchronous(true);
                this.mH.sendMessage(msg);
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchKeyEventFromInputMethod(View targetView, KeyEvent event) {
        H h = this.mH;
        synchronized (h) {
            ViewRootImpl viewRootImpl;
            ViewRootImpl viewRootImpl2 = viewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
            if (viewRootImpl == null && this.mServedView != null) {
                viewRootImpl = this.mServedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
        boolean handled;
        H h = this.mH;
        synchronized (h) {
            int result = this.sendInputEventOnMainLooperLocked(p);
            if (result == -1) {
                return;
            }
            handled = result == 1;
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    int sendInputEventOnMainLooperLocked(PendingEvent p) {
        if (this.mCurChannel != null) {
            InputEvent event;
            int seq;
            if (this.mCurSender == null) {
                this.mCurSender = new ImeInputEventSender(this.mCurChannel, this.mH.getLooper());
            }
            if (this.mCurSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                this.mPendingEvents.put(seq, p);
                Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
                Message msg = this.mH.obtainMessage(6, seq, 0, p);
                msg.setAsynchronous(true);
                this.mH.sendMessageDelayed(msg, 2500L);
                return -1;
            }
            Log.w(TAG, "Unable to send input event to IME: " + this.mCurId + " dropping: " + event);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedInputEvent(int seq, boolean handled, boolean timeout) {
        PendingEvent p;
        H h = this.mH;
        synchronized (h) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index < 0) {
                return;
            }
            p = this.mPendingEvents.valueAt(index);
            this.mPendingEvents.removeAt(index);
            Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
            if (timeout) {
                Log.w(TAG, "Timeout waiting for IME to handle input event after 2500 ms: " + p.mInputMethodId);
            } else {
                this.mH.removeMessages(6, p);
            }
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
        p.mHandled = handled;
        if (p.mHandler.getLooper().isCurrentThread()) {
            p.run();
        } else {
            Message msg = Message.obtain(p.mHandler, p);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private void flushPendingEventsLocked() {
        this.mH.removeMessages(7);
        int count = this.mPendingEvents.size();
        for (int i = 0; i < count; ++i) {
            int seq = this.mPendingEvents.keyAt(i);
            Message msg = this.mH.obtainMessage(7, seq, 0);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, String inputMethodId, FinishedInputEventCallback callback, Handler handler) {
        PendingEvent p = this.mPendingEventPool.acquire();
        if (p == null) {
            p = new PendingEvent();
        }
        p.mEvent = event;
        p.mToken = token;
        p.mInputMethodId = inputMethodId;
        p.mCallback = callback;
        p.mHandler = handler;
        return p;
    }

    private void recyclePendingEventLocked(PendingEvent p) {
        p.recycle();
        this.mPendingEventPool.release(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            this.showInputMethodPickerLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodPicker(boolean showAuxiliarySubtypes) {
        H h = this.mH;
        synchronized (h) {
            try {
                int mode = showAuxiliarySubtypes ? 1 : 2;
                this.mService.showInputMethodPickerFromClient(this.mClient, mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void showInputMethodPickerLocked() {
        try {
            this.mService.showInputMethodPickerFromClient(this.mClient, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isInputMethodPickerShown() {
        try {
            return this.mService.isInputMethodPickerShownForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodAndSubtypeEnabler(String imiId) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.showInputMethodAndSubtypeEnablerFromClient(this.mClient, imiId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public InputMethodSubtype getCurrentInputMethodSubtype() {
        try {
            return this.mService.getCurrentInputMethodSubtype();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.setCurrentInputMethodSubtype(subtype);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUserAction() {
        H h = this.mH;
        synchronized (h) {
            if (this.mLastSentUserActionNotificationSequenceNumber == this.mNextUserActionNotificationSequenceNumber) {
                return;
            }
            try {
                this.mService.notifyUserAction(this.mNextUserActionNotificationSequenceNumber);
                this.mLastSentUserActionNotificationSequenceNumber = this.mNextUserActionNotificationSequenceNumber;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InputMethodInfo, List<InputMethodSubtype>> getShortcutInputMethodsAndSubtypes() {
        H h = this.mH;
        synchronized (h) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> ret;
            block8: {
                ret = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
                try {
                    List info = this.mService.getShortcutInputMethodsAndSubtypes();
                    ArrayList<InputMethodSubtype> subtypes = null;
                    if (info == null || info.isEmpty()) break block8;
                    int N = info.size();
                    for (int i = 0; i < N; ++i) {
                        Object o = info.get(i);
                        if (o instanceof InputMethodInfo) {
                            if (ret.containsKey(o)) {
                                Log.e(TAG, "IMI list already contains the same InputMethod.");
                                break;
                            }
                            subtypes = new ArrayList<InputMethodSubtype>();
                            ret.put((InputMethodInfo)o, subtypes);
                            continue;
                        }
                        if (subtypes == null || !(o instanceof InputMethodSubtype)) continue;
                        subtypes.add((InputMethodSubtype)o);
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return ret;
        }
    }

    public int getInputMethodWindowVisibleHeight() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getInputMethodWindowVisibleHeight();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLastInputMethodWindowForTransition(IBinder token) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.clearLastInputMethodWindowForTransition(token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public boolean switchToLastInputMethod(IBinder imeToken) {
        return this.switchToPreviousInputMethodInternal(imeToken);
    }

    public boolean switchToPreviousInputMethodInternal(IBinder imeToken) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToPreviousInputMethod(imeToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public boolean switchToNextInputMethod(IBinder imeToken, boolean onlyCurrentIme) {
        return this.switchToNextInputMethodInternal(imeToken, onlyCurrentIme);
    }

    public boolean switchToNextInputMethodInternal(IBinder imeToken, boolean onlyCurrentIme) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToNextInputMethod(imeToken, onlyCurrentIme);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder imeToken) {
        return this.shouldOfferSwitchingToNextInputMethodInternal(imeToken);
    }

    public boolean shouldOfferSwitchingToNextInputMethodInternal(IBinder imeToken) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.shouldOfferSwitchingToNextInputMethod(imeToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.setAdditionalInputMethodSubtypes(imiId, subtypes);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public InputMethodSubtype getLastInputMethodSubtype() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getLastInputMethodSubtype();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void exposeContent(IBinder token, InputContentInfo inputContentInfo, EditorInfo editorInfo) {
        IInputContentUriToken uriToken;
        Uri contentUri = inputContentInfo.getContentUri();
        try {
            uriToken = this.mService.createInputContentUriToken(token, contentUri, editorInfo.packageName);
            if (uriToken == null) {
                return;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "createInputContentAccessToken failed. contentUri=" + contentUri.toString() + " packageName=" + editorInfo.packageName, e);
            return;
        }
        inputContentInfo.setUriToken(uriToken);
    }

    void doDump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method client state for " + this + ":");
        p.println("  mService=" + this.mService);
        p.println("  mMainLooper=" + this.mMainLooper);
        p.println("  mIInputContext=" + this.mIInputContext);
        p.println("  mActive=" + this.mActive + " mRestartOnNextWindowFocus=" + this.mRestartOnNextWindowFocus + " mBindSequence=" + this.mBindSequence + " mCurId=" + this.mCurId);
        p.println("  mFullscreenMode=" + this.mFullscreenMode);
        p.println("  mCurMethod=" + this.mCurMethod);
        p.println("  mCurRootView=" + this.mCurRootView);
        p.println("  mServedView=" + this.mServedView);
        p.println("  mNextServedView=" + this.mNextServedView);
        p.println("  mServedConnecting=" + this.mServedConnecting);
        if (this.mCurrentTextBoxAttribute != null) {
            p.println("  mCurrentTextBoxAttribute:");
            this.mCurrentTextBoxAttribute.dump(p, "    ");
        } else {
            p.println("  mCurrentTextBoxAttribute: null");
        }
        p.println("  mServedInputConnectionWrapper=" + this.mServedInputConnectionWrapper);
        p.println("  mCompletions=" + Arrays.toString(this.mCompletions));
        p.println("  mCursorRect=" + this.mCursorRect);
        p.println("  mCursorSelStart=" + this.mCursorSelStart + " mCursorSelEnd=" + this.mCursorSelEnd + " mCursorCandStart=" + this.mCursorCandStart + " mCursorCandEnd=" + this.mCursorCandEnd);
        p.println("  mNextUserActionNotificationSequenceNumber=" + this.mNextUserActionNotificationSequenceNumber + " mLastSentUserActionNotificationSequenceNumber=" + this.mLastSentUserActionNotificationSequenceNumber);
    }

    private static String dumpViewInfo(View view) {
        if (view == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(view);
        sb.append(",focus=" + view.hasFocus());
        sb.append(",windowFocus=" + view.hasWindowFocus());
        sb.append(",autofillUiShowing=" + InputMethodManager.isAutofillUIShowing(view));
        sb.append(",window=" + view.getWindowToken());
        sb.append(",temporaryDetach=" + view.isTemporarilyDetached());
        return sb.toString();
    }

    private class PendingEvent
    implements Runnable {
        public InputEvent mEvent;
        public Object mToken;
        public String mInputMethodId;
        public FinishedInputEventCallback mCallback;
        public Handler mHandler;
        public boolean mHandled;

        private PendingEvent() {
        }

        public void recycle() {
            this.mEvent = null;
            this.mToken = null;
            this.mInputMethodId = null;
            this.mCallback = null;
            this.mHandler = null;
            this.mHandled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mCallback.onFinishedInputEvent(this.mToken, this.mHandled);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.recyclePendingEventLocked(this);
            }
        }
    }

    private class ImeInputEventSender
    extends InputEventSender {
        public ImeInputEventSender(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEventFinished(int seq, boolean handled) {
            InputMethodManager.this.finishedInputEvent(seq, handled, false);
        }
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    private static class ControlledInputConnectionWrapper
    extends IInputConnectionWrapper {
        private final InputMethodManager mParentInputMethodManager;

        public ControlledInputConnectionWrapper(Looper mainLooper, InputConnection conn, InputMethodManager inputMethodManager) {
            super(mainLooper, conn);
            this.mParentInputMethodManager = inputMethodManager;
        }

        @Override
        public boolean isActive() {
            return this.mParentInputMethodManager.mActive && !this.isFinished();
        }

        void deactivate() {
            if (this.isFinished()) {
                return;
            }
            this.closeConnection();
        }

        @Override
        protected void onUserAction() {
            this.mParentInputMethodManager.notifyUserAction();
        }

        public String toString() {
            return "ControlledInputConnectionWrapper{connection=" + this.getInputConnection() + " finished=" + this.isFinished() + " mParentInputMethodManager.mActive=" + this.mParentInputMethodManager.mActive + "}";
        }
    }

    class H
    extends Handler {
        H(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        InputMethodManager.this.doDump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                    }
                    catch (RuntimeException e) {
                        ((PrintWriter)args.arg2).println("Exception: " + e);
                    }
                    Object e = args.arg4;
                    synchronized (e) {
                        ((CountDownLatch)args.arg4).countDown();
                    }
                    args.recycle();
                    return;
                }
                case 2: {
                    InputBindResult res = (InputBindResult)msg.obj;
                    H e = InputMethodManager.this.mH;
                    synchronized (e) {
                        if (InputMethodManager.this.mBindSequence < 0 || InputMethodManager.this.mBindSequence != res.sequence) {
                            Log.w(InputMethodManager.TAG, "Ignoring onBind: cur seq=" + InputMethodManager.this.mBindSequence + ", given seq=" + res.sequence);
                            if (res.channel != null && res.channel != InputMethodManager.this.mCurChannel) {
                                res.channel.dispose();
                            }
                            return;
                        }
                        InputMethodManager.this.mRequestUpdateCursorAnchorInfoMonitorMode = 0;
                        InputMethodManager.this.setInputChannelLocked(res.channel);
                        InputMethodManager.this.mCurMethod = res.method;
                        InputMethodManager.this.mCurId = res.id;
                        InputMethodManager.this.mBindSequence = res.sequence;
                    }
                    InputMethodManager.this.startInputInner(5, null, 0, 0, 0);
                    return;
                }
                case 3: {
                    boolean startInput;
                    int sequence = msg.arg1;
                    int reason = msg.arg2;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        if (InputMethodManager.this.mBindSequence != sequence) {
                            return;
                        }
                        InputMethodManager.this.clearBindingLocked();
                        if (InputMethodManager.this.mServedView != null && InputMethodManager.this.mServedView.isFocused()) {
                            InputMethodManager.this.mServedConnecting = true;
                        }
                        startInput = InputMethodManager.this.mActive;
                    }
                    if (startInput) {
                        InputMethodManager.this.startInputInner(6, null, 0, 0, 0);
                    }
                    return;
                }
                case 4: {
                    boolean active = msg.arg1 != 0;
                    boolean fullscreen = msg.arg2 != 0;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        InputMethodManager.this.mActive = active;
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        if (!active) {
                            InputMethodManager.this.mRestartOnNextWindowFocus = true;
                            try {
                                InputMethodManager.this.mIInputContext.finishComposingText();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                        if (InputMethodManager.this.mServedView != null && InputMethodManager.canStartInput(InputMethodManager.this.mServedView) && InputMethodManager.this.checkFocusNoStartInput(InputMethodManager.this.mRestartOnNextWindowFocus)) {
                            int reason = active ? 7 : 8;
                            InputMethodManager.this.startInputInner(reason, null, 0, 0, 0);
                        }
                    }
                    return;
                }
                case 5: {
                    InputMethodManager.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                    return;
                }
                case 6: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, true);
                    return;
                }
                case 7: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, false);
                    return;
                }
                case 9: {
                    H active = InputMethodManager.this.mH;
                    synchronized (active) {
                        InputMethodManager.this.mNextUserActionNotificationSequenceNumber = msg.arg1;
                    }
                    return;
                }
                case 10: {
                    boolean fullscreen = msg.arg1 != 0;
                    InputConnection ic = null;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        if (InputMethodManager.this.mServedInputConnectionWrapper != null) {
                            ic = InputMethodManager.this.mServedInputConnectionWrapper.getInputConnection();
                        }
                    }
                    if (ic != null) {
                        ic.reportFullscreenMode(fullscreen);
                    }
                    return;
                }
            }
        }
    }
}

