/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.view.math.Math3DHelper;
import android.view.shadow.AmbientShadowConfig;
import android.view.shadow.AmbientShadowVertexCalculator;
import android.view.shadow.TriangleBuffer;
import com.android.layoutlib.bridge.Bridge;

class AmbientShadowBitmapGenerator {
    private final AmbientShadowConfig mShadowConfig;
    private final TriangleBuffer mTriangleBuffer;
    private final AmbientShadowVertexCalculator mCalculator;
    private float mTranslateX;
    private float mTranslateY;
    private boolean mValid;

    public AmbientShadowBitmapGenerator(AmbientShadowConfig shadowConfig) {
        this.mShadowConfig = shadowConfig;
        this.mTriangleBuffer = new TriangleBuffer();
        this.mTriangleBuffer.setSize(this.mShadowConfig.getWidth(), this.mShadowConfig.getHeight(), 0);
        this.mCalculator = new AmbientShadowVertexCalculator(this.mShadowConfig);
    }

    public void populateShadow() {
        try {
            this.mValid = this.mCalculator.generateVertex(this.mShadowConfig.getPolygon());
            if (!this.mValid) {
                Bridge.getLog().warning("info", "Arithmetic error while drawing ambient shadow", null, null);
                return;
            }
            float[] shadowBounds = Math3DHelper.flatBound(this.mCalculator.getVertex(), 2);
            if (shadowBounds[0] < 0.0f) {
                this.mTranslateX = shadowBounds[0] * -1.0f;
            } else if (shadowBounds[2] > (float)this.mShadowConfig.getWidth()) {
                this.mTranslateX = shadowBounds[2] - (float)this.mShadowConfig.getWidth();
            }
            if (shadowBounds[1] < 0.0f) {
                this.mTranslateY = shadowBounds[1] * -1.0f;
            } else if (shadowBounds[3] > (float)this.mShadowConfig.getHeight()) {
                this.mTranslateY = shadowBounds[3] - (float)this.mShadowConfig.getHeight();
            }
            Math3DHelper.translate(this.mCalculator.getVertex(), this.mTranslateX, this.mTranslateY, 2);
            this.mTriangleBuffer.drawTriangles(this.mCalculator.getIndex(), this.mCalculator.getVertex(), this.mCalculator.getColor(), this.mShadowConfig.getShadowStrength());
        }
        catch (ArithmeticException | IndexOutOfBoundsException mathError) {
            Bridge.getLog().warning("info", "Arithmetic error while drawing ambient shadow", (Object)mathError);
        }
        catch (Exception ex) {
            Bridge.getLog().warning("info", "Error while drawing shadow", (Object)ex);
        }
    }

    public boolean isValid() {
        return this.mValid;
    }

    public Bitmap getBitmap() {
        return this.mTriangleBuffer.getImage();
    }

    public float getTranslateX() {
        return this.mTranslateX;
    }

    public float getTranslateY() {
        return this.mTranslateY;
    }
}

