/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

class SpotShadowConfig {
    private final int mWidth;
    private final int mHeight;
    private final int mLightRadius;
    private final int mLightSourcePoints;
    private final int mRays;
    private final int mLayers;
    private final float[] mPoly;
    private final int mPolyLength;
    private float[] mLightCoord;
    private final float mShadowStrength;

    private SpotShadowConfig(Builder builder) {
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
        this.mLightRadius = builder.mLightRadius;
        this.mLightSourcePoints = builder.mLightSourcePoints;
        this.mRays = builder.mRays;
        this.mLayers = builder.mLayers;
        this.mPoly = builder.mPoly;
        this.mPolyLength = builder.mPolyLength;
        this.mLightCoord = new float[3];
        this.mLightCoord[0] = builder.mLightX;
        this.mLightCoord[1] = builder.mLightY;
        this.mLightCoord[2] = builder.mLightHeight;
        this.mShadowStrength = builder.mShadowStrength;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getLightSourcePoints() {
        return this.mLightSourcePoints;
    }

    public int getLightRadius() {
        return this.mLightRadius;
    }

    public float[] getPoly() {
        return this.mPoly;
    }

    public int getPolyLength() {
        return this.mPolyLength;
    }

    public int getRays() {
        return this.mRays;
    }

    public int getLayers() {
        return this.mLayers;
    }

    public void setLightCoord(float x, float y) {
        this.mLightCoord[0] = x;
        this.mLightCoord[1] = y;
    }

    public float getShadowStrength() {
        return this.mShadowStrength;
    }

    public float[] getLightCoord() {
        return this.mLightCoord;
    }

    public static class Builder {
        private int mWidth;
        private int mHeight;
        private int mLightRadius;
        private int mLightSourcePoints;
        private int mRays;
        private int mLayers;
        private float[] mPoly;
        private int mPolyLength;
        private float mLightX;
        private float mLightY;
        private float mLightHeight;
        private float mShadowStrength;

        public Builder setShadowStrength(float shadowStrength) {
            this.mShadowStrength = shadowStrength;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            return this;
        }

        public Builder setLightRadius(int mLightRadius) {
            this.mLightRadius = mLightRadius;
            return this;
        }

        public Builder setLightSourcePoints(int mLightSourcePoints) {
            this.mLightSourcePoints = mLightSourcePoints;
            return this;
        }

        public Builder setRays(int mRays) {
            this.mRays = mRays;
            return this;
        }

        public Builder setLayers(int mLayers) {
            this.mLayers = mLayers;
            return this;
        }

        public Builder setPolygon(float[] poly, int polyLength) {
            this.mPoly = poly;
            this.mPolyLength = polyLength;
            return this;
        }

        public Builder setLightCoord(float lightX, float lightY, float lightHeight) {
            this.mLightX = lightX;
            this.mLightY = lightY;
            this.mLightHeight = lightHeight;
            return this;
        }

        public SpotShadowConfig build() {
            return new SpotShadowConfig(this);
        }
    }
}

