/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.res.AssetFileDescriptor;
import com.android.tools.layoutlib.create.OverrideMethod;

class TextClassifierImplNative {
    private final long mModelPtr;

    TextClassifierImplNative(int fd) {
        this.mModelPtr = TextClassifierImplNative.nativeNew(fd);
        if (this.mModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from file descriptor.");
        }
    }

    TextClassifierImplNative(String path) {
        this.mModelPtr = TextClassifierImplNative.nativeNewFromPath(path);
        if (this.mModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from given file.");
        }
    }

    TextClassifierImplNative(AssetFileDescriptor afd) {
        this.mModelPtr = TextClassifierImplNative.nativeNewFromAssetFileDescriptor(afd, afd.getStartOffset(), afd.getLength());
        if (this.mModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from given AssetFileDescriptor");
        }
    }

    public int[] suggestSelection(String context, int selectionBegin, int selectionEnd, SelectionOptions options) {
        return TextClassifierImplNative.nativeSuggestSelection(this.mModelPtr, context, selectionBegin, selectionEnd, options);
    }

    public ClassificationResult[] classifyText(String context, int selectionBegin, int selectionEnd, ClassificationOptions options) {
        return TextClassifierImplNative.nativeClassifyText(this.mModelPtr, context, selectionBegin, selectionEnd, options);
    }

    public AnnotatedSpan[] annotate(String text, AnnotationOptions options) {
        return TextClassifierImplNative.nativeAnnotate(this.mModelPtr, text, options);
    }

    public void close() {
        TextClassifierImplNative.nativeClose(this.mModelPtr);
    }

    public static String getLocales(int fd) {
        return TextClassifierImplNative.nativeGetLocales(fd);
    }

    public static int getVersion(int fd) {
        return TextClassifierImplNative.nativeGetVersion(fd);
    }

    private static long nativeNew(int n) {
        return OverrideMethod.invokeL("android.view.textclassifier.TextClassifierImplNative#nativeNew(I)J", true, null);
    }

    private static long nativeNewFromPath(String string2) {
        return OverrideMethod.invokeL("android.view.textclassifier.TextClassifierImplNative#nativeNewFromPath(Ljava/lang/String;)J", true, null);
    }

    private static long nativeNewFromAssetFileDescriptor(AssetFileDescriptor assetFileDescriptor, long l, long l2) {
        return OverrideMethod.invokeL("android.view.textclassifier.TextClassifierImplNative#nativeNewFromAssetFileDescriptor(Landroid/content/res/AssetFileDescriptor;JJ)J", true, null);
    }

    private static int[] nativeSuggestSelection(long l, String string2, int n, int n2, SelectionOptions selectionOptions) {
        return (int[])OverrideMethod.invokeA("android.view.textclassifier.TextClassifierImplNative#nativeSuggestSelection(JLjava/lang/String;IILandroid/view/textclassifier/TextClassifierImplNative$SelectionOptions;)[I", true, null);
    }

    private static ClassificationResult[] nativeClassifyText(long l, String string2, int n, int n2, ClassificationOptions classificationOptions) {
        return (ClassificationResult[])OverrideMethod.invokeA("android.view.textclassifier.TextClassifierImplNative#nativeClassifyText(JLjava/lang/String;IILandroid/view/textclassifier/TextClassifierImplNative$ClassificationOptions;)[Landroid/view/textclassifier/TextClassifierImplNative$ClassificationResult;", true, null);
    }

    private static AnnotatedSpan[] nativeAnnotate(long l, String string2, AnnotationOptions annotationOptions) {
        return (AnnotatedSpan[])OverrideMethod.invokeA("android.view.textclassifier.TextClassifierImplNative#nativeAnnotate(JLjava/lang/String;Landroid/view/textclassifier/TextClassifierImplNative$AnnotationOptions;)[Landroid/view/textclassifier/TextClassifierImplNative$AnnotatedSpan;", true, null);
    }

    private static void nativeClose(long l) {
        OverrideMethod.invokeV("android.view.textclassifier.TextClassifierImplNative#nativeClose(J)V", true, null);
    }

    private static String nativeGetLocales(int n) {
        return (String)OverrideMethod.invokeA("android.view.textclassifier.TextClassifierImplNative#nativeGetLocales(I)Ljava/lang/String;", true, null);
    }

    private static int nativeGetVersion(int n) {
        return OverrideMethod.invokeI("android.view.textclassifier.TextClassifierImplNative#nativeGetVersion(I)I", true, null);
    }

    static {
        System.loadLibrary("textclassifier");
    }

    public static class AnnotationOptions {
        private final long mReferenceTimeMsUtc;
        private final String mReferenceTimezone;
        private final String mLocales;

        AnnotationOptions(long referenceTimeMsUtc, String referenceTimezone, String locale) {
            this.mReferenceTimeMsUtc = referenceTimeMsUtc;
            this.mReferenceTimezone = referenceTimezone;
            this.mLocales = locale;
        }

        public long getReferenceTimeMsUtc() {
            return this.mReferenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.mReferenceTimezone;
        }

        public String getLocale() {
            return this.mLocales;
        }
    }

    public static class ClassificationOptions {
        private final long mReferenceTimeMsUtc;
        private final String mReferenceTimezone;
        private final String mLocales;

        ClassificationOptions(long referenceTimeMsUtc, String referenceTimezone, String locale) {
            this.mReferenceTimeMsUtc = referenceTimeMsUtc;
            this.mReferenceTimezone = referenceTimezone;
            this.mLocales = locale;
        }

        public long getReferenceTimeMsUtc() {
            return this.mReferenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.mReferenceTimezone;
        }

        public String getLocale() {
            return this.mLocales;
        }
    }

    public static class SelectionOptions {
        private final String mLocales;

        SelectionOptions(String locales) {
            this.mLocales = locales;
        }

        public String getLocales() {
            return this.mLocales;
        }
    }

    public static class AnnotatedSpan {
        private final int mStartIndex;
        private final int mEndIndex;
        private final ClassificationResult[] mClassification;

        AnnotatedSpan(int startIndex, int endIndex, ClassificationResult[] classification) {
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mClassification = classification;
        }

        public int getStartIndex() {
            return this.mStartIndex;
        }

        public int getEndIndex() {
            return this.mEndIndex;
        }

        public ClassificationResult[] getClassification() {
            return this.mClassification;
        }
    }

    public static class ClassificationResult {
        private final String mCollection;
        private final float mScore;
        private final DatetimeResult mDatetimeResult;

        ClassificationResult(String collection, float score, DatetimeResult datetimeResult) {
            this.mCollection = collection;
            this.mScore = score;
            this.mDatetimeResult = datetimeResult;
        }

        public String getCollection() {
            if (this.mCollection.equals("date") && this.mDatetimeResult != null) {
                switch (this.mDatetimeResult.getGranularity()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        return "datetime";
                    }
                }
                return "date";
            }
            return this.mCollection;
        }

        public float getScore() {
            return this.mScore;
        }

        public DatetimeResult getDatetimeResult() {
            return this.mDatetimeResult;
        }
    }

    public static class DatetimeResult {
        static final int GRANULARITY_YEAR = 0;
        static final int GRANULARITY_MONTH = 1;
        static final int GRANULARITY_WEEK = 2;
        static final int GRANULARITY_DAY = 3;
        static final int GRANULARITY_HOUR = 4;
        static final int GRANULARITY_MINUTE = 5;
        static final int GRANULARITY_SECOND = 6;
        private final long mTimeMsUtc;
        private final int mGranularity;

        DatetimeResult(long timeMsUtc, int granularity) {
            this.mGranularity = granularity;
            this.mTimeMsUtc = timeMsUtc;
        }

        public long getTimeMsUtc() {
            return this.mTimeMsUtc;
        }

        public int getGranularity() {
            return this.mGranularity;
        }
    }
}

