/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import com.android.internal.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;

public class KernelCpuProcReader {
    private static final String TAG = "KernelCpuProcReader";
    private static final int ERROR_THRESHOLD = 5;
    private static final long DEFAULT_THROTTLE_INTERVAL = 3000L;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final String PROC_UID_FREQ_TIME = "/proc/uid_cpupower/time_in_state";
    private static final String PROC_UID_ACTIVE_TIME = "/proc/uid_cpupower/concurrent_active_time";
    private static final String PROC_UID_CLUSTER_TIME = "/proc/uid_cpupower/concurrent_policy_time";
    private static final KernelCpuProcReader mFreqTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/time_in_state");
    private static final KernelCpuProcReader mActiveTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_active_time");
    private static final KernelCpuProcReader mClusterTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_policy_time");
    private int mErrors;
    private long mThrottleInterval = 3000L;
    private long mLastReadTime = Long.MIN_VALUE;
    private final Path mProc;
    private byte[] mBuffer = new byte[8192];
    private int mContentSize;

    public static KernelCpuProcReader getFreqTimeReaderInstance() {
        return mFreqTimeReader;
    }

    public static KernelCpuProcReader getActiveTimeReaderInstance() {
        return mActiveTimeReader;
    }

    public static KernelCpuProcReader getClusterTimeReaderInstance() {
        return mClusterTimeReader;
    }

    @VisibleForTesting
    public KernelCpuProcReader(String procFile) {
        this.mProc = Paths.get(procFile, new String[0]);
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer readBytes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setThrottleInterval(long throttleInterval) {
        if (throttleInterval >= 0L) {
            this.mThrottleInterval = throttleInterval;
        }
    }
}

