/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.LongSparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class MemoryPowerCalculator
extends PowerCalculator {
    public static final String TAG = "MemoryPowerCalculator";
    private static final boolean DEBUG = false;
    private final double[] powerAverages;

    public MemoryPowerCalculator(PowerProfile profile) {
        int numBuckets = profile.getNumElements("memory.bandwidths");
        this.powerAverages = new double[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.powerAverages[i] = profile.getAveragePower("memory.bandwidths", i);
            if (this.powerAverages[i] != 0.0) continue;
        }
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        double totalMah = 0.0;
        long totalTimeMs = 0L;
        LongSparseArray<? extends BatteryStats.Timer> timers = stats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.powerAverages.length; ++i) {
            double mAatRail = this.powerAverages[(int)timers.keyAt(i)];
            long timeMs = timers.valueAt(i).getTotalTimeLocked(rawRealtimeUs, statsType);
            double mAm = mAatRail * (double)timeMs / 60000.0;
            totalMah += mAm / 60.0;
            totalTimeMs += timeMs;
        }
        app.usagePowerMah = totalMah;
        app.usageTimeMs = totalTimeMs;
    }
}

