/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.view.ContextThemeWrapper;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import com.android.internal.policy.PhoneWindow;
import java.lang.ref.WeakReference;

class DecorContext
extends ContextThemeWrapper {
    private PhoneWindow mPhoneWindow;
    private WindowManager mWindowManager;
    private Resources mActivityResources;
    private WeakReference<Context> mActivityContext;

    public DecorContext(Context context, Context activityContext) {
        super(context, null);
        this.mActivityContext = new WeakReference<Context>(activityContext);
        this.mActivityResources = activityContext.getResources();
    }

    void setPhoneWindow(PhoneWindow phoneWindow) {
        this.mPhoneWindow = phoneWindow;
        this.mWindowManager = null;
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            if (this.mWindowManager == null) {
                WindowManagerImpl wm = (WindowManagerImpl)super.getSystemService("window");
                this.mWindowManager = wm.createLocalWindowManager(this.mPhoneWindow);
            }
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    @Override
    public Resources getResources() {
        Context activityContext = (Context)this.mActivityContext.get();
        if (activityContext != null) {
            this.mActivityResources = activityContext.getResources();
        }
        return this.mActivityResources;
    }

    @Override
    public AssetManager getAssets() {
        return this.mActivityResources.getAssets();
    }
}

