/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayDeque;

public class NotificationVisibility
implements Parcelable {
    private static final String TAG = "NoViz";
    private static final int MAX_POOL_SIZE = 25;
    private static ArrayDeque<NotificationVisibility> sPool = new ArrayDeque(25);
    private static int sNexrId = 0;
    public String key;
    public int rank;
    public int count;
    public boolean visible = true;
    int id = sNexrId++;
    public static final Parcelable.Creator<NotificationVisibility> CREATOR = new Parcelable.Creator<NotificationVisibility>(){

        @Override
        public NotificationVisibility createFromParcel(Parcel parcel) {
            return NotificationVisibility.obtain(parcel);
        }

        public NotificationVisibility[] newArray(int size) {
            return new NotificationVisibility[size];
        }
    };

    private NotificationVisibility() {
    }

    private NotificationVisibility(String key, int rank, int count, boolean visibile) {
        this();
        this.key = key;
        this.rank = rank;
        this.count = count;
        this.visible = visibile;
    }

    public String toString() {
        return "NotificationVisibility(id=" + this.id + " key=" + this.key + " rank=" + this.rank + " count=" + this.count + (this.visible ? " visible" : "") + " )";
    }

    public NotificationVisibility clone() {
        return NotificationVisibility.obtain(this.key, this.rank, this.count, this.visible);
    }

    public int hashCode() {
        return this.key == null ? 0 : this.key.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof NotificationVisibility) {
            NotificationVisibility thatViz = (NotificationVisibility)that;
            return this.key == null && thatViz.key == null || this.key.equals(thatViz.key);
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.key);
        out.writeInt(this.rank);
        out.writeInt(this.count);
        out.writeInt(this.visible ? 1 : 0);
    }

    private void readFromParcel(Parcel in) {
        this.key = in.readString();
        this.rank = in.readInt();
        this.count = in.readInt();
        this.visible = in.readInt() != 0;
    }

    public static NotificationVisibility obtain(String key, int rank, int count, boolean visible) {
        NotificationVisibility vo = NotificationVisibility.obtain();
        vo.key = key;
        vo.rank = rank;
        vo.count = count;
        vo.visible = visible;
        return vo;
    }

    private static NotificationVisibility obtain(Parcel in) {
        NotificationVisibility vo = NotificationVisibility.obtain();
        vo.readFromParcel(in);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NotificationVisibility obtain() {
        ArrayDeque<NotificationVisibility> arrayDeque = sPool;
        synchronized (arrayDeque) {
            if (!sPool.isEmpty()) {
                return sPool.poll();
            }
        }
        return new NotificationVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.key == null) {
            return;
        }
        this.key = null;
        if (sPool.size() < 25) {
            ArrayDeque<NotificationVisibility> arrayDeque = sPool;
            synchronized (arrayDeque) {
                sPool.offer(this);
            }
        }
    }
}

