/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.app.Notification;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import java.util.Objects;

public class NotificationMessagingUtil {
    private static final String DEFAULT_SMS_APP_SETTING = "sms_default_application";
    private final Context mContext;
    private ArrayMap<Integer, String> mDefaultSmsApp = new ArrayMap();
    private final ContentObserver mSmsContentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (Settings.Secure.getUriFor(NotificationMessagingUtil.DEFAULT_SMS_APP_SETTING).equals(uri)) {
                NotificationMessagingUtil.this.cacheDefaultSmsApp(userId);
            }
        }
    };

    public NotificationMessagingUtil(Context context) {
        this.mContext = context;
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor(DEFAULT_SMS_APP_SETTING), false, this.mSmsContentObserver);
    }

    public boolean isImportantMessaging(StatusBarNotification sbn, int importance) {
        if (importance < 2) {
            return false;
        }
        return this.hasMessagingStyle(sbn) || this.isCategoryMessage(sbn) && this.isDefaultMessagingApp(sbn);
    }

    public boolean isMessaging(StatusBarNotification sbn) {
        return this.hasMessagingStyle(sbn) || this.isDefaultMessagingApp(sbn) || this.isCategoryMessage(sbn);
    }

    private boolean isDefaultMessagingApp(StatusBarNotification sbn) {
        int userId = sbn.getUserId();
        if (userId == -10000 || userId == -1) {
            return false;
        }
        if (this.mDefaultSmsApp.get(userId) == null) {
            this.cacheDefaultSmsApp(userId);
        }
        return Objects.equals(this.mDefaultSmsApp.get(userId), sbn.getPackageName());
    }

    private void cacheDefaultSmsApp(int userId) {
        this.mDefaultSmsApp.put(userId, Settings.Secure.getStringForUser(this.mContext.getContentResolver(), DEFAULT_SMS_APP_SETTING, userId));
    }

    private boolean hasMessagingStyle(StatusBarNotification sbn) {
        Class<? extends Notification.Style> style2 = sbn.getNotification().getNotificationStyle();
        return Notification.MessagingStyle.class.equals(style2);
    }

    private boolean isCategoryMessage(StatusBarNotification sbn) {
        return "msg".equals(sbn.getNotification().category);
    }
}

