/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;

public class NetworkPinner
extends ConnectivityManager.NetworkCallback {
    private static final String TAG = NetworkPinner.class.getSimpleName();
    @VisibleForTesting
    protected static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static ConnectivityManager sCM;
    @GuardedBy(value="sLock")
    private static Callback sCallback;
    @VisibleForTesting
    @GuardedBy(value="sLock")
    protected static Network sNetwork;

    private static void maybeInitConnectivityManager(Context context) {
        if (sCM == null && (sCM = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            throw new IllegalStateException("Bad luck, ConnectivityService not started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pin(Context context, NetworkRequest request) {
        Object object = sLock;
        synchronized (object) {
            if (sCallback == null) {
                NetworkPinner.maybeInitConnectivityManager(context);
                sCallback = new Callback();
                try {
                    sCM.registerNetworkCallback(request, sCallback);
                }
                catch (SecurityException e) {
                    Log.d(TAG, "Failed to register network callback", e);
                    sCallback = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpin() {
        Object object = sLock;
        synchronized (object) {
            if (sCallback != null) {
                try {
                    sCM.bindProcessToNetwork(null);
                    sCM.unregisterNetworkCallback(sCallback);
                }
                catch (SecurityException e) {
                    Log.d(TAG, "Failed to unregister network callback", e);
                }
                sCallback = null;
                sNetwork = null;
            }
        }
    }

    private static class Callback
    extends ConnectivityManager.NetworkCallback {
        private Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAvailable(Network network) {
            Object object = sLock;
            synchronized (object) {
                if (this != sCallback) {
                    return;
                }
                if (sCM.getBoundNetworkForProcess() == null && sNetwork == null) {
                    sCM.bindProcessToNetwork(network);
                    sNetwork = network;
                    Log.d(TAG, "Wifi alternate reality enabled on network " + network);
                }
                sLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLost(Network network) {
            Object object = sLock;
            synchronized (object) {
                if (this != sCallback) {
                    return;
                }
                if (network.equals(sNetwork) && network.equals(sCM.getBoundNetworkForProcess())) {
                    NetworkPinner.unpin();
                    Log.d(TAG, "Wifi alternate reality disabled on network " + network);
                }
                sLock.notify();
            }
        }
    }
}

