package app.cash.redwood.layout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.MainAxisAlignment
import app.cash.redwood.layout.api.Overflow
import app.cash.redwood.layout.api.Padding
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryProvider
import app.cash.redwood.layout.widget.Row
import kotlin.OptIn
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun Row(
  width: Constraint = Constraint.Wrap,
  height: Constraint = Constraint.Wrap,
  padding: Padding = Padding.Zero,
  overflow: Overflow = Overflow.Clip,
  horizontalAlignment: MainAxisAlignment = MainAxisAlignment.Start,
  verticalAlignment: CrossAxisAlignment = CrossAxisAlignment.Start,
  layoutModifier: LayoutModifier = LayoutModifier,
  children: @Composable RowScope.() -> Unit,
): Unit {
  RedwoodComposeNode<RedwoodLayoutWidgetFactoryProvider<*>, Row<*>>(
      factory = { it.RedwoodLayout.Row() },
      update = {
        set(layoutModifier) { layoutModifiers = it }
        set(width, Row<*>::width)
        set(height, Row<*>::height)
        set(padding, Row<*>::padding)
        set(overflow, Row<*>::overflow)
        set(horizontalAlignment, Row<*>::horizontalAlignment)
        set(verticalAlignment, Row<*>::verticalAlignment)
      },
      content = {
        into(Row<*>::children) {
          RowScopeImpl.children()
        }
      },
      )
}
