package app.cash.redwood.layout.compose

import androidx.compose.runtime.Stable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.LayoutScopeMarker
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.Padding
import kotlin.Double

@LayoutScopeMarker
public interface RowScope {
  @Stable
  public fun LayoutModifier.grow(`value`: Double): LayoutModifier = then(GrowImpl(`value`))

  @Stable
  public fun LayoutModifier.shrink(`value`: Double): LayoutModifier = then(ShrinkImpl(`value`))

  @Stable
  public fun LayoutModifier.padding(padding: Padding): LayoutModifier = then(PaddingImpl(padding))

  @Stable
  public fun LayoutModifier.verticalAlignment(alignment: CrossAxisAlignment): LayoutModifier =
      then(VerticalAlignmentImpl(alignment))
}

internal object RowScopeImpl : RowScope
