package app.cash.redwood.layout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.MainAxisAlignment
import app.cash.redwood.layout.api.Overflow
import app.cash.redwood.layout.api.Padding
import app.cash.redwood.layout.widget.Column
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryProvider
import kotlin.OptIn
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun Column(
  width: Constraint = Constraint.Wrap,
  height: Constraint = Constraint.Wrap,
  padding: Padding = Padding.Zero,
  overflow: Overflow = Overflow.Clip,
  horizontalAlignment: CrossAxisAlignment = CrossAxisAlignment.Start,
  verticalAlignment: MainAxisAlignment = MainAxisAlignment.Start,
  layoutModifier: LayoutModifier = LayoutModifier,
  children: @Composable ColumnScope.() -> Unit,
): Unit {
  RedwoodComposeNode<RedwoodLayoutWidgetFactoryProvider<*>, Column<*>>(
      factory = { it.RedwoodLayout.Column() },
      update = {
        set(layoutModifier) { layoutModifiers = it }
        set(width, Column<*>::width)
        set(height, Column<*>::height)
        set(padding, Column<*>::padding)
        set(overflow, Column<*>::overflow)
        set(horizontalAlignment, Column<*>::horizontalAlignment)
        set(verticalAlignment, Column<*>::verticalAlignment)
      },
      content = {
        into(Column<*>::children) {
          ColumnScopeImpl.children()
        }
      },
      )
}
