package app.cash.redwood.layout.compose

import androidx.compose.runtime.Stable
import app.cash.redwood.LayoutModifier
import app.cash.redwood.LayoutScopeMarker
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.Padding
import kotlin.Double

@LayoutScopeMarker
public interface ColumnScope {
  @Stable
  public fun LayoutModifier.grow(`value`: Double): LayoutModifier = then(GrowImpl(`value`))

  @Stable
  public fun LayoutModifier.shrink(`value`: Double): LayoutModifier = then(ShrinkImpl(`value`))

  @Stable
  public fun LayoutModifier.padding(padding: Padding): LayoutModifier = then(PaddingImpl(padding))

  @Stable
  public fun LayoutModifier.horizontalAlignment(alignment: CrossAxisAlignment): LayoutModifier =
      then(HorizontalAlignmentImpl(alignment))
}

internal object ColumnScopeImpl : ColumnScope
