package app.cash.redwood.layout.compose

import app.cash.redwood.layout.Grow
import app.cash.redwood.layout.HorizontalAlignment
import app.cash.redwood.layout.Shrink
import app.cash.redwood.layout.VerticalAlignment
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.Padding
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String

internal class GrowImpl(
  public override val `value`: Double,
) : Grow {
  public override fun equals(other: Any?): Boolean = other is Grow
  && other.`value` == `value`

  public override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + `value`.hashCode()
    return hash
  }

  public override fun toString(): String = """Grow(value=$value)"""
}

internal class ShrinkImpl(
  public override val `value`: Double,
) : Shrink {
  public override fun equals(other: Any?): Boolean = other is Shrink
  && other.`value` == `value`

  public override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + `value`.hashCode()
    return hash
  }

  public override fun toString(): String = """Shrink(value=$value)"""
}

internal class PaddingImpl(
  public override val padding: Padding,
) : app.cash.redwood.layout.Padding {
  public override fun equals(other: Any?): Boolean = other is app.cash.redwood.layout.Padding
  && other.padding == padding

  public override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + padding.hashCode()
    return hash
  }

  public override fun toString(): String = """Padding(padding=$padding)"""
}

internal class HorizontalAlignmentImpl(
  public override val alignment: CrossAxisAlignment,
) : HorizontalAlignment {
  public override fun equals(other: Any?): Boolean = other is HorizontalAlignment
  && other.alignment == alignment

  public override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + alignment.hashCode()
    return hash
  }

  public override fun toString(): String = """HorizontalAlignment(alignment=$alignment)"""
}

internal class VerticalAlignmentImpl(
  public override val alignment: CrossAxisAlignment,
) : VerticalAlignment {
  public override fun equals(other: Any?): Boolean = other is VerticalAlignment
  && other.alignment == alignment

  public override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + alignment.hashCode()
    return hash
  }

  public override fun toString(): String = """VerticalAlignment(alignment=$alignment)"""
}
