package app.cash.redwood.layout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.compose.WidgetNode
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.MainAxisAlignment
import app.cash.redwood.layout.api.Overflow
import app.cash.redwood.layout.widget.Column
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryProvider
import app.cash.redwood.ui.Margin
import kotlin.OptIn
import kotlin.Unit

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun Column(
  width: Constraint = Constraint.Wrap,
  height: Constraint = Constraint.Wrap,
  margin: Margin = Margin.Zero,
  overflow: Overflow = Overflow.Clip,
  horizontalAlignment: CrossAxisAlignment = CrossAxisAlignment.Start,
  verticalAlignment: MainAxisAlignment = MainAxisAlignment.Start,
  modifier: Modifier = Modifier,
  children: @Composable ColumnScope.() -> Unit,
) {
  RedwoodComposeNode<RedwoodLayoutWidgetFactoryProvider<*>, Column<*>>(
      factory = { it.RedwoodLayout.Column() },
      update = {
        set(modifier, WidgetNode.SetModifiers)
        set(width) { recordChanged(); widget.width(it) }
        set(height) { recordChanged(); widget.height(it) }
        set(margin) { recordChanged(); widget.margin(it) }
        set(overflow) { recordChanged(); widget.overflow(it) }
        set(horizontalAlignment) { recordChanged(); widget.horizontalAlignment(it) }
        set(verticalAlignment) { recordChanged(); widget.verticalAlignment(it) }
      },
      content = {
        into(Column<*>::children) {
          ColumnScopeImpl.children()
        }
      },
      )
}
