package app.cash.redwood.layout.compose

import androidx.compose.runtime.Stable
import app.cash.redwood.LayoutScopeMarker
import app.cash.redwood.Modifier
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.ui.Dp
import app.cash.redwood.ui.Margin
import kotlin.Double

@LayoutScopeMarker
public interface RowScope {
  @Stable
  public fun Modifier.grow(`value`: Double): Modifier = then(GrowImpl(`value`))

  @Stable
  public fun Modifier.shrink(`value`: Double): Modifier = then(ShrinkImpl(`value`))

  @Stable
  public fun Modifier.margin(margin: Margin): Modifier = then(MarginImpl(margin))

  @Stable
  public fun Modifier.verticalAlignment(alignment: CrossAxisAlignment): Modifier =
      then(VerticalAlignmentImpl(alignment))

  @Stable
  public fun Modifier.width(width: Dp): Modifier = then(WidthImpl(width))

  @Stable
  public fun Modifier.height(height: Dp): Modifier = then(HeightImpl(height))

  @Stable
  public fun Modifier.size(width: Dp, height: Dp): Modifier = then(SizeImpl(width, height))
}

internal object RowScopeImpl : RowScope
