package app.cash.redwood.layout.compose

import androidx.compose.runtime.Composable
import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.compose.RedwoodComposeNode
import app.cash.redwood.compose.WidgetNode
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryProvider
import app.cash.redwood.layout.widget.Spacer
import app.cash.redwood.ui.Dp
import kotlin.OptIn

@Composable
@OptIn(RedwoodCodegenApi::class)
public fun Spacer(
  width: Dp = Dp(0.0),
  height: Dp = Dp(0.0),
  modifier: Modifier = Modifier,
) {
  RedwoodComposeNode<RedwoodLayoutWidgetFactoryProvider<*>, Spacer<*>>(
      factory = { it.RedwoodLayout.Spacer() },
      update = {
        set(modifier, WidgetNode.SetModifiers)
        set(width) { recordChanged(); widget.width(it) }
        set(height) { recordChanged(); widget.height(it) }
      },
      content = {
      },
      )
}
