package app.cash.redwood.layout.compose

import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.modifier.Grow
import app.cash.redwood.layout.modifier.Height
import app.cash.redwood.layout.modifier.HorizontalAlignment
import app.cash.redwood.layout.modifier.Shrink
import app.cash.redwood.layout.modifier.Size
import app.cash.redwood.layout.modifier.VerticalAlignment
import app.cash.redwood.layout.modifier.Width
import app.cash.redwood.ui.Dp
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import app.cash.redwood.layout.modifier.Margin as ModifierMargin
import app.cash.redwood.ui.Margin as UiMargin

internal class GrowImpl(
  override val `value`: Double,
) : Grow {
  override fun equals(other: Any?): Boolean = other is Grow
  && other.`value` == `value`

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + `value`.hashCode()
    return hash
  }

  override fun toString(): String = """Grow(value=$value)"""
}

internal class ShrinkImpl(
  override val `value`: Double,
) : Shrink {
  override fun equals(other: Any?): Boolean = other is Shrink
  && other.`value` == `value`

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + `value`.hashCode()
    return hash
  }

  override fun toString(): String = """Shrink(value=$value)"""
}

internal class MarginImpl(
  override val margin: UiMargin,
) : ModifierMargin {
  override fun equals(other: Any?): Boolean = other is ModifierMargin
  && other.margin == margin

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + margin.hashCode()
    return hash
  }

  override fun toString(): String = """Margin(margin=$margin)"""
}

internal class HorizontalAlignmentImpl(
  override val alignment: CrossAxisAlignment,
) : HorizontalAlignment {
  override fun equals(other: Any?): Boolean = other is HorizontalAlignment
  && other.alignment == alignment

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + alignment.hashCode()
    return hash
  }

  override fun toString(): String = """HorizontalAlignment(alignment=$alignment)"""
}

internal class VerticalAlignmentImpl(
  override val alignment: CrossAxisAlignment,
) : VerticalAlignment {
  override fun equals(other: Any?): Boolean = other is VerticalAlignment
  && other.alignment == alignment

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + alignment.hashCode()
    return hash
  }

  override fun toString(): String = """VerticalAlignment(alignment=$alignment)"""
}

internal class WidthImpl(
  override val width: Dp,
) : Width {
  override fun equals(other: Any?): Boolean = other is Width
  && other.width == width

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + width.hashCode()
    return hash
  }

  override fun toString(): String = """Width(width=$width)"""
}

internal class HeightImpl(
  override val height: Dp,
) : Height {
  override fun equals(other: Any?): Boolean = other is Height
  && other.height == height

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + height.hashCode()
    return hash
  }

  override fun toString(): String = """Height(height=$height)"""
}

internal class SizeImpl(
  override val width: Dp,
  override val height: Dp,
) : Size {
  override fun equals(other: Any?): Boolean = other is Size
  && other.width == width
  && other.height == height

  override fun hashCode(): Int {
    var hash = 17
    hash = 31 * hash + width.hashCode()
    hash = 31 * hash + height.hashCode()
    return hash
  }

  override fun toString(): String = """Size(width=$width, height=$height)"""
}
