@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.testing

import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryOwner
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.testing.toDebugString
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.Widget
import app.cash.redwood.widget.WidgetSystem
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.listOf

public class BoxValue(
  override val modifier: Modifier = Modifier,
  public val width: Constraint = Constraint.Wrap,
  public val height: Constraint = Constraint.Wrap,
  public val margin: Margin = Margin.Zero,
  public val horizontalAlignment: CrossAxisAlignment = CrossAxisAlignment.Start,
  public val verticalAlignment: CrossAxisAlignment = CrossAxisAlignment.Start,
  public val children: List<WidgetValue> = listOf(),
) : WidgetValue {
  override val childrenLists: List<List<WidgetValue>>
    get() = listOf(children)

  override fun equals(other: Any?): Boolean = other is BoxValue &&
  other.modifier == modifier &&
  other.width == width &&
  other.height == height &&
  other.margin == margin &&
  other.horizontalAlignment == horizontalAlignment &&
  other.verticalAlignment == verticalAlignment &&
  other.children == children

  override fun hashCode(): Int = listOf(modifier, width, height, margin, horizontalAlignment,
      verticalAlignment, children).hashCode()

  override fun toString(): String =
      """BoxValue(modifier=$modifier, width=$width, height=$height, margin=$margin, horizontalAlignment=$horizontalAlignment, verticalAlignment=$verticalAlignment, children=$children)"""

  override fun toDebugString(): String = buildString {
    append("Box")
    append("""
        |(
        |  width = $width, 
        |  height = $height, 
        |  margin = $margin, 
        |  horizontalAlignment = $horizontalAlignment, 
        |  verticalAlignment = $verticalAlignment
        |""".trimMargin())
    append(")")
    append(" {")
    if (childrenLists[0].isNotEmpty()) {
      appendLine()
      append(childrenLists[0].toDebugString().prependIndent("  "))
      append("\n}")
    }
    else {
      append(" }")
    }
  }

  @OptIn(RedwoodCodegenApi::class)
  override fun <W : Any> toWidget(widgetSystem: WidgetSystem<W>): Widget<W> {
    @Suppress("UNCHECKED_CAST") // Type parameter shared in generated code.
    val factoryOwner = widgetSystem as RedwoodLayoutWidgetFactoryOwner<W>
    val instance = factoryOwner.RedwoodLayout.Box()

    instance.width(width)
    instance.height(height)
    instance.margin(margin)
    instance.horizontalAlignment(horizontalAlignment)
    instance.verticalAlignment(verticalAlignment)
    instance.modifier = modifier

    for ((index, child) in children.withIndex()) {
      instance.children.insert(index, child.toWidget(widgetSystem))
    }

    return instance
  }
}
