@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.testing

import app.cash.redwood.Modifier
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.MainAxisAlignment
import app.cash.redwood.layout.api.Overflow
import app.cash.redwood.layout.widget.Row
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Margin
import app.cash.redwood.ui.Px
import app.cash.redwood.widget.MutableListChildren
import kotlin.Suppress
import kotlin.Unit

internal class MutableRow : Row<WidgetValue> {
  override val `value`: WidgetValue
    get() = RowValue(
      modifier = modifier,
      width = width!!,
      height = height!!,
      margin = margin!!,
      overflow = overflow!!,
      horizontalAlignment = horizontalAlignment!!,
      verticalAlignment = verticalAlignment!!,
      onScroll = onScroll,
      children = children.map { it.`value` },
    )

  override var modifier: Modifier = Modifier

  private var width: Constraint? = null

  private var height: Constraint? = null

  private var margin: Margin? = null

  private var overflow: Overflow? = null

  private var horizontalAlignment: MainAxisAlignment? = null

  private var verticalAlignment: CrossAxisAlignment? = null

  private var onScroll: ((Px) -> Unit)? = null

  override val children: MutableListChildren<WidgetValue> = MutableListChildren()

  override fun width(width: Constraint) {
    this.width = width
  }

  override fun height(height: Constraint) {
    this.height = height
  }

  override fun margin(margin: Margin) {
    this.margin = margin
  }

  override fun overflow(overflow: Overflow) {
    this.overflow = overflow
  }

  override fun horizontalAlignment(horizontalAlignment: MainAxisAlignment) {
    this.horizontalAlignment = horizontalAlignment
  }

  override fun verticalAlignment(verticalAlignment: CrossAxisAlignment) {
    this.verticalAlignment = verticalAlignment
  }

  override fun onScroll(onScroll: ((Px) -> Unit)?) {
    this.onScroll = onScroll
  }
}
