@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.testing

import app.cash.redwood.Modifier
import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.layout.widget.RedwoodLayoutWidgetFactoryOwner
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Dp
import app.cash.redwood.widget.Widget
import app.cash.redwood.widget.WidgetSystem
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.OptIn
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.listOf

public class SpacerValue(
  override val modifier: Modifier = Modifier,
  public val width: Dp = Dp(0.0),
  public val height: Dp = Dp(0.0),
) : WidgetValue {
  override val childrenLists: List<List<WidgetValue>>
    get() = listOf()

  override fun equals(other: Any?): Boolean = other is SpacerValue &&
  other.modifier == modifier &&
  other.width == width &&
  other.height == height

  override fun hashCode(): Int = listOf(modifier, width, height).hashCode()

  override fun toString(): String =
      """SpacerValue(modifier=$modifier, width=$width, height=$height)"""

  @OptIn(RedwoodCodegenApi::class)
  override fun <W : Any> toWidget(widgetSystem: WidgetSystem<W>): Widget<W> {
    @Suppress("UNCHECKED_CAST") // Type parameter shared in generated code.
    val factoryOwner = widgetSystem as RedwoodLayoutWidgetFactoryOwner<W>
    val instance = factoryOwner.RedwoodLayout.Spacer()

    instance.width(width)
    instance.height(height)
    instance.modifier = modifier


    return instance
  }
}
