package app.cash.redwood.layout.widget

import app.cash.redwood.Modifier
import app.cash.redwood.layout.api.Constraint
import app.cash.redwood.layout.api.CrossAxisAlignment
import app.cash.redwood.layout.api.MainAxisAlignment
import app.cash.redwood.layout.api.Overflow
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Margin
import app.cash.redwood.widget.MutableListChildren

internal class MutableColumn : Column<WidgetValue> {
  override val `value`: WidgetValue
    get() = ColumnValue(
      modifier = modifier,
      width = width!!,
      height = height!!,
      margin = margin!!,
      overflow = overflow!!,
      horizontalAlignment = horizontalAlignment!!,
      verticalAlignment = verticalAlignment!!,
      children = children.map { it.`value` },
    )

  override var modifier: Modifier = Modifier

  private var width: Constraint? = null

  private var height: Constraint? = null

  private var margin: Margin? = null

  private var overflow: Overflow? = null

  private var horizontalAlignment: CrossAxisAlignment? = null

  private var verticalAlignment: MainAxisAlignment? = null

  override val children: MutableListChildren<WidgetValue> = MutableListChildren()

  override fun width(width: Constraint) {
    this.width = width
  }

  override fun height(height: Constraint) {
    this.height = height
  }

  override fun margin(margin: Margin) {
    this.margin = margin
  }

  override fun overflow(overflow: Overflow) {
    this.overflow = overflow
  }

  override fun horizontalAlignment(horizontalAlignment: CrossAxisAlignment) {
    this.horizontalAlignment = horizontalAlignment
  }

  override fun verticalAlignment(verticalAlignment: MainAxisAlignment) {
    this.verticalAlignment = verticalAlignment
  }
}
