package app.cash.redwood.layout.widget

import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.testing.TestRedwoodComposition
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.UiConfiguration
import app.cash.redwood.widget.MutableListChildren
import kotlin.OptIn
import kotlin.collections.List
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.flow.MutableStateFlow

@OptIn(RedwoodCodegenApi::class)
public suspend fun <R>
    RedwoodLayoutTester(body: suspend TestRedwoodComposition<List<WidgetValue>>.() -> R): R =
    coroutineScope {
  val factories = RedwoodLayoutWidgetFactories(
    RedwoodLayout = RedwoodLayoutTestingWidgetFactory(),
  )
  val container = MutableListChildren<WidgetValue>()
  val tester = TestRedwoodComposition(this, factories, container,
      MutableStateFlow(UiConfiguration())) {
    container.map { it.value }
  }
  try {
    tester.body()
  } finally {
    tester.cancel()
  }
}
