package app.cash.redwood.layout.widget

import app.cash.redwood.Modifier
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.Dp
import app.cash.redwood.widget.Widget
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.listOf

public class SpacerValue(
  override val modifier: Modifier = Modifier,
  public val width: Dp = Dp(0.0),
  public val height: Dp = Dp(0.0),
) : WidgetValue {
  override val childrenLists: List<List<WidgetValue>>
    get() = listOf()

  override fun equals(other: Any?): Boolean = other is SpacerValue &&
  other.modifier == modifier &&
  other.width == width &&
  other.height == height

  override fun hashCode(): Int = listOf(modifier, width, height).hashCode()

  override fun toString(): String =
      """SpacerValue(modifier=$modifier, width=$width, height=$height)"""

  override fun <W : Any> toWidget(provider: Widget.Provider<W>): Widget<W> {
    val factory = provider as RedwoodLayoutWidgetFactoryProvider<W>
    val instance = factory.RedwoodLayout.Spacer()

    instance.modifier = modifier
    instance.width(width)
    instance.height(height)


    return instance
  }
}
