@file:Suppress("DEPRECATION", "OVERRIDE_DEPRECATION")

package app.cash.redwood.layout.widget

import app.cash.redwood.RedwoodCodegenApi
import app.cash.redwood.testing.NoOpOnBackPressedDispatcher
import app.cash.redwood.testing.TestRedwoodComposition
import app.cash.redwood.testing.TestSavedState
import app.cash.redwood.testing.WidgetValue
import app.cash.redwood.ui.OnBackPressedDispatcher
import app.cash.redwood.ui.UiConfiguration
import app.cash.redwood.widget.MutableListChildren
import kotlin.OptIn
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.coroutines.coroutineScope

@OptIn(RedwoodCodegenApi::class)
public suspend fun <R> RedwoodLayoutTester(
  onBackPressedDispatcher: OnBackPressedDispatcher = NoOpOnBackPressedDispatcher,
  savedState: TestSavedState? = null,
  uiConfiguration: UiConfiguration = UiConfiguration(),
  body: suspend TestRedwoodComposition<List<WidgetValue>>.() -> R,
): R = coroutineScope {
  val factories = RedwoodLayoutWidgetFactories(
    RedwoodLayout = RedwoodLayoutTestingWidgetFactory(),
  )
  val container = MutableListChildren<WidgetValue>()
  val tester = TestRedwoodComposition(this, factories, container, onBackPressedDispatcher,
      savedState, uiConfiguration) {
    container.map { it.value }
  }
  try {
    tester.body()
  } finally {
    tester.cancel()
  }
}
